/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.webauthn;

import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.runtime.QuarkusPrincipal;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.quarkus.security.webauthn.WebAuthnAuthenticationRequest;
import io.quarkus.security.webauthn.WebAuthnSecurity;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.UniEmitter;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.Credentials;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.security.Principal;
import java.util.function.Consumer;

@ApplicationScoped
public class WebAuthnIdentityProvider
implements IdentityProvider<WebAuthnAuthenticationRequest> {
    @Inject
    WebAuthnSecurity security;

    public Class<WebAuthnAuthenticationRequest> getRequestType() {
        return WebAuthnAuthenticationRequest.class;
    }

    public Uni<SecurityIdentity> authenticate(final WebAuthnAuthenticationRequest request, AuthenticationRequestContext context) {
        return Uni.createFrom().emitter((Consumer)new Consumer<UniEmitter<? super SecurityIdentity>>(){

            @Override
            public void accept(final UniEmitter<? super SecurityIdentity> emitter) {
                WebAuthnIdentityProvider.this.security.getWebAuthn().authenticate((Credentials)request.getCredentials(), (Handler)new Handler<AsyncResult<User>>(){

                    public void handle(AsyncResult<User> event) {
                        if (event.failed()) {
                            emitter.fail(event.cause());
                        } else {
                            QuarkusSecurityIdentity.Builder builder = QuarkusSecurityIdentity.builder();
                            builder.setPrincipal((Principal)new QuarkusPrincipal(request.getCredentials().getUsername()));
                            emitter.complete((Object)builder.build());
                        }
                    }
                });
            }
        });
    }
}

