/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.UniOnSubscribeCall;
import io.smallrye.mutiny.operators.UniOnSubscribeInvoke;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class UniOnSubscribe<T> {
    private final Uni<T> upstream;

    public UniOnSubscribe(Uni<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public Uni<T> invoke(Consumer<? super UniSubscription> callback) {
        return Infrastructure.onUniCreation(new UniOnSubscribeInvoke<T>(this.upstream, ParameterValidation.nonNull(callback, "callback")));
    }

    public Uni<T> invoke(Runnable callback) {
        Runnable actual = ParameterValidation.nonNull(callback, "callback");
        return this.invoke((? super UniSubscription ignored) -> actual.run());
    }

    public Uni<T> call(Function<? super UniSubscription, Uni<?>> action) {
        return Infrastructure.onUniCreation(new UniOnSubscribeCall<T>(this.upstream, ParameterValidation.nonNull(action, "action")));
    }

    public Uni<T> call(Supplier<Uni<?>> action) {
        Supplier<Uni<?>> actual = ParameterValidation.nonNull(action, "action");
        return this.call((? super UniSubscription ignored) -> (Uni)actual.get());
    }

    @Deprecated
    public Uni<T> invokeUni(Function<? super UniSubscription, Uni<?>> action) {
        return this.call(action);
    }
}

