/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni.builders;

import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.uni.builders.StateHolder;
import io.smallrye.mutiny.subscription.UniSubscriber;
import java.util.function.Function;
import java.util.function.Supplier;

public class UniCreateFromItemWithState<T, S>
extends AbstractUni<T> {
    private final Function<S, ? extends T> mapper;
    private final StateHolder<S> holder;

    public UniCreateFromItemWithState(Supplier<S> stateSupplier, Function<S, ? extends T> mapper) {
        this.holder = new StateHolder<S>(stateSupplier);
        this.mapper = mapper;
    }

    @Override
    protected void subscribing(UniSubscriber<? super T> subscriber) {
        T item;
        S state;
        subscriber.onSubscribe(EmptyUniSubscription.CANCELLED);
        try {
            state = this.holder.get();
        }
        catch (Exception e) {
            subscriber.onFailure(e);
            return;
        }
        try {
            item = this.mapper.apply(state);
        }
        catch (Throwable err) {
            subscriber.onFailure(err);
            return;
        }
        subscriber.onItem(item);
    }
}

