package io.smallrye.reactive.messaging.providers.connectors.i18n;

import java.util.Locale;
import java.io.Serializable;
import java.lang.String;
import java.util.Arrays;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
public class InMemoryExceptions_$bundle implements InMemoryExceptions, Serializable {
    private static final long serialVersionUID = 1L;
    protected InMemoryExceptions_$bundle() {}
    public static final InMemoryExceptions_$bundle INSTANCE = new InMemoryExceptions_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String illegalArgumentChannelNameNull$str() {
        return "SRMSG18300: The channel name must not be `null` or blank";
    }
    @Override
    public final IllegalArgumentException illegalArgumentChannelNameNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentChannelNameNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String illegalArgumentInvalidIncomingConfig$str() {
        return "SRMSG18301: Invalid incoming configuration, `channel-name` is not set";
    }
    @Override
    public final IllegalArgumentException illegalArgumentInvalidIncomingConfig() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentInvalidIncomingConfig$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalArgumentInvalidOutgoingConfig$str() {
        return "SRMSG18302: Invalid outgoing configuration, `channel-name` is not set";
    }
    @Override
    public final IllegalArgumentException illegalArgumentInvalidOutgoingConfig() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentInvalidOutgoingConfig$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalArgumentChannelMustNotBeNull$str() {
        return "SRMSG18303: `channel` must not be `null`";
    }
    @Override
    public final IllegalArgumentException illegalArgumentChannelMustNotBeNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentChannelMustNotBeNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalArgumentUnknownChannel$str() {
        return "SRMSG18304: Unknown channel %s";
    }
    @Override
    public final IllegalArgumentException illegalArgumentUnknownChannel(final String channel) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentUnknownChannel$str(), channel));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
