/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.cdi;

import io.smallrye.jwt.JsonUtils;
import io.smallrye.jwt.auth.cdi.CDILogging;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.json.JsonNumber;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.eclipse.microprofile.jwt.Claim;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.JsonWebToken;

public class RawClaimTypeProducer {
    @Inject
    JsonWebToken currentToken;

    @Produces
    @Claim(value="")
    Set<String> getClaimAsSet(InjectionPoint ip) {
        CDILogging.log.getClaimAsSet(ip);
        if (this.currentToken == null) {
            return null;
        }
        String name = RawClaimTypeProducer.getName(ip);
        return (Set)JsonUtils.convert(Set.class, this.currentToken.getClaim(name));
    }

    @Produces
    @Claim(value="")
    String getClaimAsString(InjectionPoint ip) {
        CDILogging.log.getClaimAsString(ip);
        if (this.currentToken == null) {
            return null;
        }
        String name = RawClaimTypeProducer.getName(ip);
        Optional optValue = this.currentToken.claim(name);
        String returnValue = null;
        if (optValue.isPresent()) {
            Object value = optValue.get();
            if (value instanceof JsonString) {
                JsonString jsonValue = (JsonString)value;
                returnValue = jsonValue.getString();
            } else {
                returnValue = value.toString();
            }
        }
        return returnValue;
    }

    @Produces
    @Claim(value="")
    Long getClaimAsLong(InjectionPoint ip) {
        CDILogging.log.getClaimAsLong(ip);
        if (this.currentToken == null) {
            return null;
        }
        String name = RawClaimTypeProducer.getName(ip);
        Optional optValue = this.currentToken.claim(name);
        Long returnValue = null;
        if (optValue.isPresent()) {
            Object value = optValue.get();
            if (value instanceof JsonNumber) {
                JsonNumber jsonValue = (JsonNumber)value;
                returnValue = jsonValue.longValue();
            } else {
                returnValue = Long.parseLong(value.toString());
            }
        }
        return returnValue;
    }

    @Produces
    @Claim(value="")
    Double getClaimAsDouble(InjectionPoint ip) {
        CDILogging.log.getClaimAsDouble(ip);
        if (this.currentToken == null) {
            return null;
        }
        String name = RawClaimTypeProducer.getName(ip);
        Optional optValue = this.currentToken.claim(name);
        Double returnValue = null;
        if (optValue.isPresent()) {
            Object value = optValue.get();
            if (value instanceof JsonNumber) {
                JsonNumber jsonValue = (JsonNumber)value;
                returnValue = jsonValue.doubleValue();
            } else {
                returnValue = Double.parseDouble(value.toString());
            }
        }
        return returnValue;
    }

    @Produces
    @Claim(value="")
    Boolean getClaimAsBoolean(InjectionPoint ip) {
        CDILogging.log.getClaimAsBoolean(ip);
        if (this.currentToken == null) {
            return null;
        }
        String name = RawClaimTypeProducer.getName(ip);
        Optional optValue = this.currentToken.claim(name);
        Boolean returnValue = null;
        if (optValue.isPresent()) {
            Object value = optValue.get();
            if (value instanceof JsonValue) {
                JsonValue.ValueType valueType = ((JsonValue)value).getValueType();
                if (valueType.equals((Object)JsonValue.ValueType.TRUE)) {
                    returnValue = true;
                } else if (valueType.equals((Object)JsonValue.ValueType.FALSE)) {
                    returnValue = false;
                }
            } else {
                returnValue = Boolean.valueOf(value.toString());
            }
        }
        return returnValue;
    }

    @Produces
    @Claim(value="")
    public Optional getOptionalValue(InjectionPoint ip) {
        CDILogging.log.getOptionalValue(ip);
        if (this.currentToken == null) {
            return Optional.empty();
        }
        return this.currentToken.claim(RawClaimTypeProducer.getName(ip));
    }

    static String getName(InjectionPoint ip) {
        String name = null;
        for (Annotation ann : ip.getQualifiers()) {
            if (!(ann instanceof Claim)) continue;
            Claim claim = (Claim)ann;
            name = claim.standard() == Claims.UNKNOWN ? claim.value() : claim.standard().name();
        }
        return name;
    }
}

