/*
 * Decompiled with CFR 0.152.
 */
package scala_maven;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionNumber
implements Comparable<VersionNumber> {
    private static final Pattern _regexp = Pattern.compile("(\\d+)\\.(\\d+)(\\.\\d+)?([-\\.].+)?");
    int major;
    int minor;
    int bugfix;
    String modifier;

    public VersionNumber() {
        this.major = 0;
        this.minor = 0;
        this.bugfix = 0;
    }

    public VersionNumber(String s) {
        Matcher match = _regexp.matcher(s);
        if (!match.find()) {
            throw new IllegalArgumentException("invalid versionNumber : major.minor(.bugfix)(modifier) :" + s);
        }
        this.major = Integer.parseInt(match.group(1));
        this.minor = Integer.parseInt(match.group(2));
        if (match.group(3) != null && match.group(3).length() > 1) {
            this.bugfix = Integer.parseInt(match.group(3).substring(1));
        }
        if (match.group(4) != null && match.group(4).length() > 1) {
            this.modifier = match.group(4);
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.major).append('.').append(this.minor).append('.').append(this.bugfix);
        if (this.modifier != null && this.modifier.length() > 0) {
            str.append(this.modifier);
        }
        return str.toString();
    }

    @Override
    public int compareTo(VersionNumber o) {
        int back = 0;
        if (back == 0 && this.major > o.major) {
            back = 1;
        }
        if (back == 0 && this.major < o.major) {
            back = -1;
        }
        if (back == 0 && this.minor > o.minor) {
            back = 1;
        }
        if (back == 0 && this.minor < o.minor) {
            back = -1;
        }
        if (back == 0 && this.bugfix > o.bugfix) {
            back = 1;
        }
        if (back == 0 && this.bugfix < o.bugfix) {
            back = -1;
        }
        return back;
    }

    public boolean isZero() {
        return this.major == 0 && this.minor == 0 && this.bugfix == 0;
    }

    String applyScalaArtifactVersioningScheme(String name) {
        return name + '_' + (this.modifier == null ? this.major + "." + this.minor : this.toString());
    }
}

