/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public final class FileUtils {
    private FileUtils() {
    }

    public static List<File> listDirectoryContent(final Path directory, final Function<File, Boolean> filter) throws IOException {
        final ArrayList<File> files = new ArrayList<File>();
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                File f = file.toFile();
                if (((Boolean)filter.apply(f)).booleanValue()) {
                    files.add(f);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                File f = dir.toFile();
                if (!dir.equals(directory) && ((Boolean)filter.apply(f)).booleanValue()) {
                    files.add(f);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return files;
    }

    public static void deleteDirectory(Path directory) {
        try {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

