/*
 * Decompiled with CFR 0.152.
 */
package net.nicoulaj.maven.plugins.checksum.mojo;

import java.util.LinkedList;
import java.util.List;
import net.nicoulaj.maven.plugins.checksum.mojo.AbstractChecksumMojo;
import net.nicoulaj.maven.plugins.checksum.mojo.ChecksumFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="artifacts", defaultPhase=LifecyclePhase.VERIFY, requiresProject=true, inheritByDefault=false, threadSafe=true)
public class ArtifactsMojo
extends AbstractChecksumMojo {
    public static final String NAME = "artifacts";
    @Parameter(defaultValue="true")
    protected boolean individualFiles;
    @Parameter
    protected String individualFilesOutputDirectory;
    @Parameter(defaultValue="false")
    protected boolean csvSummary;
    @Parameter(defaultValue="artifacts-checksums.csv")
    protected String csvSummaryFile;
    @Parameter(defaultValue="false")
    protected boolean xmlSummary;
    @Parameter(defaultValue="artifacts-checksums.xml")
    protected String xmlSummaryFile;
    @Parameter(defaultValue="false")
    protected boolean shasumSummary;
    @Parameter(defaultValue="artifacts-checksums.sha")
    protected String shasumSummaryFile;

    @Override
    protected List<ChecksumFile> getFilesToProcess() {
        LinkedList<ChecksumFile> files = new LinkedList<ChecksumFile>();
        if (this.hasValidFile(this.project.getArtifact())) {
            files.add(new ChecksumFile("", this.project.getArtifact().getFile()));
        }
        if (this.project.getAttachedArtifacts() != null) {
            for (Artifact artifact : this.project.getAttachedArtifacts()) {
                if (!this.hasValidFile(artifact)) continue;
                files.add(new ChecksumFile("", artifact.getFile()));
            }
        }
        return files;
    }

    protected boolean hasValidFile(Artifact artifact) {
        boolean hasValidFile = artifact != null && artifact.getFile() != null && artifact.getFile().exists();
        hasValidFile = hasValidFile && !artifact.getFile().getPath().equals(this.project.getFile().getPath());
        hasValidFile = hasValidFile && artifact.getFile().getPath().startsWith(this.project.getBuild().getDirectory());
        return hasValidFile;
    }

    @Override
    protected boolean isIndividualFiles() {
        return this.individualFiles;
    }

    @Override
    protected String getIndividualFilesOutputDirectory() {
        return this.individualFilesOutputDirectory;
    }

    @Override
    protected boolean isCsvSummary() {
        return this.csvSummary;
    }

    @Override
    protected String getCsvSummaryFile() {
        return this.csvSummaryFile;
    }

    @Override
    protected boolean isXmlSummary() {
        return this.xmlSummary;
    }

    @Override
    protected String getXmlSummaryFile() {
        return this.xmlSummaryFile;
    }

    @Override
    protected boolean isShasumSummary() {
        return this.shasumSummary;
    }

    @Override
    protected String getShasumSummaryFile() {
        return this.shasumSummaryFile;
    }
}

