/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.reasoner.UnsupportedEntailmentTypeException;
import uk.ac.manchester.cs.jfact.TranslationMachinery;
import uk.ac.manchester.cs.jfact.kernel.ReasoningKernel;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleExpression;

public class EntailmentChecker
implements OWLAxiomVisitorEx<Boolean>,
Serializable {
    private static final long serialVersionUID = 11000L;
    private final ReasoningKernel kernel;
    private final TranslationMachinery tr;
    private final OWLDataFactory df;

    @Nonnull
    private static Boolean b(boolean b) {
        return b;
    }

    public EntailmentChecker(ReasoningKernel k, OWLDataFactory df, TranslationMachinery tr) {
        this.kernel = k;
        this.tr = tr;
        this.df = df;
    }

    public Boolean visit(OWLSubClassOfAxiom axiom) {
        if (axiom.getSuperClass().equals(this.df.getOWLThing()) || axiom.getSubClass().equals(this.df.getOWLNothing())) {
            return EntailmentChecker.b(true);
        }
        ConceptExpression sub = this.tr.pointer(axiom.getSubClass());
        if (!this.kernel.isSatisfiable(sub)) {
            return true;
        }
        ConceptExpression sup = this.tr.pointer(axiom.getSuperClass());
        return EntailmentChecker.b(this.kernel.isSubsumedBy(sub, sup));
    }

    public Boolean visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        return (Boolean)axiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
    }

    public Boolean visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        return this.kernel.isAsymmetric(this.tr.pointer((OWLObjectPropertyExpression)axiom.getProperty()));
    }

    public Boolean visit(OWLReflexiveObjectPropertyAxiom axiom) {
        return EntailmentChecker.b(this.kernel.isReflexive(this.tr.pointer((OWLObjectPropertyExpression)axiom.getProperty())));
    }

    public Boolean visit(OWLDisjointClassesAxiom axiom) {
        Set classExpressions = axiom.getClassExpressions();
        if (classExpressions.size() == 2) {
            Iterator it = classExpressions.iterator();
            return EntailmentChecker.b(this.kernel.isDisjoint(this.tr.pointer((OWLClassExpression)it.next()), this.tr.pointer((OWLClassExpression)it.next())));
        }
        for (OWLAxiom ax : axiom.asOWLSubClassOfAxioms()) {
            if (((Boolean)ax.accept((OWLAxiomVisitorEx)this)).booleanValue()) continue;
            return EntailmentChecker.b(false);
        }
        return EntailmentChecker.b(true);
    }

    public Boolean visit(OWLDataPropertyDomainAxiom axiom) {
        return (Boolean)axiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
    }

    public Boolean visit(OWLObjectPropertyDomainAxiom axiom) {
        return (Boolean)axiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
    }

    public Boolean visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        for (OWLAxiom ax : axiom.asSubObjectPropertyOfAxioms()) {
            if (((Boolean)ax.accept((OWLAxiomVisitorEx)this)).booleanValue()) continue;
            return EntailmentChecker.b(false);
        }
        return EntailmentChecker.b(true);
    }

    public Boolean visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        return (Boolean)axiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
    }

    public Boolean visit(OWLDifferentIndividualsAxiom axiom) {
        for (OWLSubClassOfAxiom ax : axiom.asOWLSubClassOfAxioms()) {
            if (((Boolean)ax.accept((OWLAxiomVisitorEx)this)).booleanValue()) continue;
            return EntailmentChecker.b(false);
        }
        return EntailmentChecker.b(true);
    }

    public Boolean visit(OWLDisjointDataPropertiesAxiom axiom) {
        ArrayList l = new ArrayList(axiom.getProperties());
        for (int i = 0; i < l.size() - 1; ++i) {
            for (int j = i + 1; j < l.size(); ++j) {
                if (this.kernel.isDisjointRoles(this.tr.pointer((OWLDataPropertyExpression)l.get(i)), this.tr.pointer((OWLDataPropertyExpression)l.get(i)))) continue;
                return EntailmentChecker.b(false);
            }
        }
        return EntailmentChecker.b(true);
    }

    public Boolean visit(OWLDisjointObjectPropertiesAxiom axiom) {
        ArrayList l = new ArrayList(axiom.getProperties());
        for (int i = 0; i < l.size() - 1; ++i) {
            for (int j = i + 1; j < l.size(); ++j) {
                if (this.kernel.isDisjointRoles(this.tr.pointer((OWLObjectPropertyExpression)l.get(i)), this.tr.pointer((OWLObjectPropertyExpression)l.get(i)))) continue;
                return EntailmentChecker.b(false);
            }
        }
        return EntailmentChecker.b(true);
    }

    public Boolean visit(OWLObjectPropertyRangeAxiom axiom) {
        return (Boolean)axiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
    }

    public Boolean visit(OWLObjectPropertyAssertionAxiom axiom) {
        return (Boolean)axiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
    }

    public Boolean visit(OWLFunctionalObjectPropertyAxiom axiom) {
        return EntailmentChecker.b(this.kernel.isFunctional(this.tr.pointer((OWLObjectPropertyExpression)axiom.getProperty())));
    }

    public Boolean visit(OWLSubObjectPropertyOfAxiom axiom) {
        return EntailmentChecker.b(this.kernel.isSubRoles(this.tr.pointer((OWLObjectPropertyExpression)axiom.getSubProperty()), this.tr.pointer((OWLObjectPropertyExpression)axiom.getSuperProperty())));
    }

    public Boolean visit(OWLDisjointUnionAxiom axiom) {
        return (Boolean)axiom.getOWLEquivalentClassesAxiom().accept((OWLAxiomVisitorEx)this) != false && (Boolean)axiom.getOWLDisjointClassesAxiom().accept((OWLAxiomVisitorEx)this) != false;
    }

    public Boolean visit(OWLDeclarationAxiom axiom) {
        return EntailmentChecker.b(false);
    }

    public Boolean visit(OWLAnnotationAssertionAxiom axiom) {
        return EntailmentChecker.b(false);
    }

    public Boolean visit(OWLSymmetricObjectPropertyAxiom axiom) {
        return EntailmentChecker.b(this.kernel.isSymmetric(this.tr.pointer((OWLObjectPropertyExpression)axiom.getProperty())));
    }

    public Boolean visit(OWLDataPropertyRangeAxiom axiom) {
        return (Boolean)axiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
    }

    public Boolean visit(OWLFunctionalDataPropertyAxiom axiom) {
        return EntailmentChecker.b(this.kernel.isFunctional(this.tr.pointer((OWLDataPropertyExpression)axiom.getProperty())));
    }

    public Boolean visit(OWLEquivalentDataPropertiesAxiom axiom) {
        for (OWLAxiom ax : axiom.asSubDataPropertyOfAxioms()) {
            if (((Boolean)ax.accept((OWLAxiomVisitorEx)this)).booleanValue()) continue;
            return EntailmentChecker.b(false);
        }
        return EntailmentChecker.b(true);
    }

    public Boolean visit(OWLClassAssertionAxiom axiom) {
        return EntailmentChecker.b(this.kernel.isInstance(this.tr.pointer(axiom.getIndividual()), this.tr.pointer(axiom.getClassExpression())));
    }

    public Boolean visit(OWLEquivalentClassesAxiom axiom) {
        Set classExpressionSet = axiom.getClassExpressions();
        if (classExpressionSet.size() == 2) {
            Iterator it = classExpressionSet.iterator();
            return EntailmentChecker.b(this.kernel.isEquivalent(this.tr.pointer((OWLClassExpression)it.next()), this.tr.pointer((OWLClassExpression)it.next())));
        }
        for (OWLAxiom ax : axiom.asOWLSubClassOfAxioms()) {
            if (((Boolean)ax.accept((OWLAxiomVisitorEx)this)).booleanValue()) continue;
            return EntailmentChecker.b(false);
        }
        return EntailmentChecker.b(true);
    }

    public Boolean visit(OWLDataPropertyAssertionAxiom axiom) {
        return (Boolean)axiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
    }

    public Boolean visit(OWLTransitiveObjectPropertyAxiom axiom) {
        return EntailmentChecker.b(this.kernel.isTransitive(this.tr.pointer((OWLObjectPropertyExpression)axiom.getProperty())));
    }

    public Boolean visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        return EntailmentChecker.b(this.kernel.isIrreflexive(this.tr.pointer((OWLObjectPropertyExpression)axiom.getProperty())));
    }

    public Boolean visit(OWLSubDataPropertyOfAxiom axiom) {
        return this.kernel.isSubRoles(this.tr.pointer((OWLDataPropertyExpression)axiom.getSubProperty()), this.tr.pointer((OWLDataPropertyExpression)axiom.getSuperProperty()));
    }

    public Boolean visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        return this.kernel.isInverseFunctional(this.tr.pointer((OWLObjectPropertyExpression)axiom.getProperty()));
    }

    public Boolean visit(OWLSameIndividualAxiom axiom) {
        for (OWLSameIndividualAxiom ax : axiom.asPairwiseAxioms()) {
            Iterator it = ax.getIndividuals().iterator();
            OWLIndividual indA = (OWLIndividual)it.next();
            OWLIndividual indB = (OWLIndividual)it.next();
            if (this.kernel.isSameIndividuals(this.tr.pointer(indA), this.tr.pointer(indB))) continue;
            return EntailmentChecker.b(false);
        }
        return EntailmentChecker.b(true);
    }

    public Boolean visit(OWLSubPropertyChainOfAxiom axiom) {
        ArrayList<ObjectRoleExpression> l = new ArrayList<ObjectRoleExpression>();
        for (OWLObjectPropertyExpression p : axiom.getPropertyChain()) {
            l.add(this.tr.pointer(p));
        }
        return EntailmentChecker.b(this.kernel.isSubChain(this.tr.pointer(axiom.getSuperProperty()), l));
    }

    public Boolean visit(OWLInverseObjectPropertiesAxiom axiom) {
        for (OWLAxiom ax : axiom.asSubObjectPropertyOfAxioms()) {
            if (((Boolean)ax.accept((OWLAxiomVisitorEx)this)).booleanValue()) continue;
            return EntailmentChecker.b(false);
        }
        return EntailmentChecker.b(true);
    }

    public Boolean visit(OWLHasKeyAxiom axiom) {
        throw new UnsupportedEntailmentTypeException((OWLAxiom)axiom);
    }

    public Boolean visit(OWLDatatypeDefinitionAxiom axiom) {
        throw new UnsupportedEntailmentTypeException((OWLAxiom)axiom);
    }

    public Boolean visit(SWRLRule rule) {
        throw new UnsupportedEntailmentTypeException((OWLAxiom)rule);
    }

    public Boolean visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        return EntailmentChecker.b(false);
    }

    public Boolean visit(OWLAnnotationPropertyDomainAxiom axiom) {
        return EntailmentChecker.b(false);
    }

    public Boolean visit(OWLAnnotationPropertyRangeAxiom axiom) {
        return EntailmentChecker.b(false);
    }
}

