/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataRangeVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNodeSet;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.jfact.AxiomTranslator;
import uk.ac.manchester.cs.jfact.ClassExpressionTranslator;
import uk.ac.manchester.cs.jfact.DataPropertyTranslator;
import uk.ac.manchester.cs.jfact.DataRangeTranslator;
import uk.ac.manchester.cs.jfact.EntailmentChecker;
import uk.ac.manchester.cs.jfact.EntityVisitorEx;
import uk.ac.manchester.cs.jfact.IndividualTranslator;
import uk.ac.manchester.cs.jfact.ObjectPropertyTranslator;
import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.Literal;
import uk.ac.manchester.cs.jfact.kernel.ExpressionCache;
import uk.ac.manchester.cs.jfact.kernel.ReasoningKernel;
import uk.ac.manchester.cs.jfact.kernel.dl.IndividualName;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.Axioms;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.AxiomInterface;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataRoleExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.Expression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.IndividualExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleExpression;

public class TranslationMachinery
implements Serializable {
    private static final long serialVersionUID = 11000L;
    @Nonnull
    private final AxiomTranslator axiomTranslator;
    @Nonnull
    private final ClassExpressionTranslator classExpressionTranslator;
    @Nonnull
    private final DataRangeTranslator dataRangeTranslator;
    @Nonnull
    private final ObjectPropertyTranslator objectPropertyTranslator;
    @Nonnull
    private final DataPropertyTranslator dataPropertyTranslator;
    @Nonnull
    private final IndividualTranslator individualTranslator;
    @Nonnull
    private final EntailmentChecker entailmentChecker;
    @Nonnull
    private final Map<OWLAxiom, AxiomInterface> axiom2PtrMap = new HashMap<OWLAxiom, AxiomInterface>();
    @Nonnull
    private final Map<AxiomInterface, OWLAxiom> ptr2AxiomMap = new HashMap<AxiomInterface, OWLAxiom>();
    protected final ReasoningKernel kernel;
    protected final ExpressionCache em;
    protected final OWLDataFactory df;
    protected final DatatypeFactory datatypefactory;

    public TranslationMachinery(ReasoningKernel kernel, OWLDataFactory df, DatatypeFactory factory) {
        this.kernel = kernel;
        this.datatypefactory = factory;
        this.em = kernel.getExpressionManager();
        this.df = df;
        this.axiomTranslator = new AxiomTranslator(kernel.getOntology(), df, this);
        this.classExpressionTranslator = new ClassExpressionTranslator(this.em, df, this);
        this.dataRangeTranslator = new DataRangeTranslator(this.em, df, this, this.datatypefactory);
        this.objectPropertyTranslator = new ObjectPropertyTranslator(this.em, df, this);
        this.dataPropertyTranslator = new DataPropertyTranslator(this.em, df, this);
        this.individualTranslator = new IndividualTranslator(this.em, df, this);
        this.entailmentChecker = new EntailmentChecker(kernel, df, this);
    }

    public List<Expression> translateExpressions(Set<OWLEntity> signature) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        for (OWLEntity entity : signature) {
            Expression ex = (Expression)entity.accept((OWLEntityVisitorEx)new EntityVisitorEx(this));
            if (ex == Axioms.dummyExpression()) continue;
            list.add(ex);
        }
        return list;
    }

    public void loadAxioms(Collection<OWLAxiom> axioms) {
        for (OWLAxiom axiom : axioms) {
            AxiomInterface axiomPointer;
            if (this.axiom2PtrMap.containsKey(axiom) || (axiomPointer = (AxiomInterface)axiom.accept((OWLAxiomVisitorEx)this.axiomTranslator)) == Axioms.dummy()) continue;
            this.axiom2PtrMap.put(axiom, axiomPointer);
            this.ptr2AxiomMap.put(axiomPointer, axiom);
        }
    }

    public void retractAxiom(OWLAxiom axiom) {
        AxiomInterface ptr = this.axiom2PtrMap.get(axiom);
        if (ptr != null) {
            this.kernel.getOntology().retract(ptr);
            this.axiom2PtrMap.remove(axiom);
            this.ptr2AxiomMap.remove(ptr);
        }
    }

    @Nonnull
    protected ConceptExpression pointer(OWLClassExpression classExpression) {
        return (ConceptExpression)classExpression.accept((OWLClassExpressionVisitorEx)this.classExpressionTranslator);
    }

    @Nonnull
    protected DataExpression pointer(OWLDataRange dataRange) {
        return (DataExpression)dataRange.accept((OWLDataRangeVisitorEx)this.dataRangeTranslator);
    }

    @Nonnull
    protected ObjectRoleExpression pointer(OWLObjectPropertyExpression propertyExpression) {
        OWLObjectPropertyExpression simp = propertyExpression.getSimplified();
        if (simp.isAnonymous()) {
            OWLObjectInverseOf inv = (OWLObjectInverseOf)simp;
            return this.em.inverse((ObjectRoleExpression)this.objectPropertyTranslator.getPointerFromEntity(inv.getInverse().asOWLObjectProperty()));
        }
        return (ObjectRoleExpression)this.objectPropertyTranslator.getPointerFromEntity(simp.asOWLObjectProperty());
    }

    @Nonnull
    protected DataRoleExpression pointer(OWLDataPropertyExpression propertyExpression) {
        return (DataRoleExpression)this.dataPropertyTranslator.getPointerFromEntity(propertyExpression.asOWLDataProperty());
    }

    @Nonnull
    protected synchronized IndividualName pointer(OWLIndividual individual) {
        if (!individual.isAnonymous()) {
            return (IndividualName)this.individualTranslator.getPointerFromEntity(individual.asOWLNamedIndividual());
        }
        return this.em.individual(IRI.create((String)individual.toStringID()));
    }

    @Nonnull
    protected synchronized Datatype<?> pointer(OWLDatatype datatype) {
        OWLAPIPreconditions.checkNotNull((Object)datatype, (String)"datatype cannot be null");
        return this.datatypefactory.getKnownDatatype(datatype.getIRI());
    }

    @Nonnull
    protected synchronized Literal<?> pointer(OWLLiteral literal) {
        String value = literal.getLiteral();
        if (literal.isRDFPlainLiteral()) {
            value = value + '@' + literal.getLang();
        }
        IRI string = literal.getDatatype().getIRI();
        Datatype<?> knownDatatype = this.datatypefactory.getKnownDatatype(string);
        return knownDatatype.buildLiteral(value);
    }

    @Nonnull
    protected NodeSet<OWLNamedIndividual> translateNodeSet(Iterable<IndividualExpression> pointers) {
        OWLNamedIndividualNodeSet ns = new OWLNamedIndividualNodeSet();
        for (IndividualExpression pointer : pointers) {
            OWLNamedIndividual ind;
            if (!(pointer instanceof IndividualName) || (ind = (OWLNamedIndividual)this.individualTranslator.getEntityFromPointer((IndividualName)pointer)) == null) continue;
            ns.addEntity((OWLObject)ind);
        }
        return ns;
    }

    public List<IndividualExpression> translate(Set<OWLIndividual> inds) {
        ArrayList<IndividualExpression> l = new ArrayList<IndividualExpression>();
        for (OWLIndividual ind : inds) {
            l.add(this.pointer(ind));
        }
        return l;
    }

    public ClassExpressionTranslator getClassExpressionTranslator() {
        return this.classExpressionTranslator;
    }

    public DataRangeTranslator getDataRangeTranslator() {
        return this.dataRangeTranslator;
    }

    public ObjectPropertyTranslator getObjectPropertyTranslator() {
        return this.objectPropertyTranslator;
    }

    public DataPropertyTranslator getDataPropertyTranslator() {
        return this.dataPropertyTranslator;
    }

    public IndividualTranslator getIndividualTranslator() {
        return this.individualTranslator;
    }

    @Nonnull
    public EntailmentChecker getEntailmentChecker() {
        return this.entailmentChecker;
    }

    public Set<OWLAxiom> translateTAxiomSet(Collection<AxiomInterface> trace) {
        HashSet<OWLAxiom> ret = new HashSet<OWLAxiom>();
        for (AxiomInterface ap : trace) {
            ret.add(this.ptr2AxiomMap.get(ap));
        }
        return ret;
    }
}

