/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.datatypes;

import java.util.Collection;
import javax.annotation.Nonnull;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeEnumeration;
import uk.ac.manchester.cs.jfact.datatypes.Facets;
import uk.ac.manchester.cs.jfact.datatypes.Literal;
import uk.ac.manchester.cs.jfact.datatypes.NumericDatatype;
import uk.ac.manchester.cs.jfact.datatypes.OrderedDatatype;

public class DatatypeNumericEnumeration<R extends Comparable<R>>
extends DatatypeEnumeration<R>
implements NumericDatatype<R> {
    public DatatypeNumericEnumeration(@Nonnull NumericDatatype<R> d) {
        super(d);
    }

    public DatatypeNumericEnumeration(@Nonnull NumericDatatype<R> d, @Nonnull Literal<R> l) {
        this(d);
        this.literals.add(l);
    }

    public DatatypeNumericEnumeration(@Nonnull NumericDatatype<R> d, @Nonnull Collection<Literal<R>> c) {
        this(d);
        this.literals.addAll(c);
    }

    @Override
    public DatatypeNumericEnumeration<R> add(Literal<R> d) {
        DatatypeNumericEnumeration<R> toReturn = new DatatypeNumericEnumeration<R>((NumericDatatype)this.host, this.literals);
        toReturn.literals.add(d);
        return toReturn;
    }

    @Override
    public boolean isNumericDatatype() {
        return true;
    }

    @Override
    public NumericDatatype<R> asNumericDatatype() {
        return this;
    }

    @Override
    public boolean isOrderedDatatype() {
        return true;
    }

    @Override
    public boolean hasMinExclusive() {
        return false;
    }

    @Override
    public boolean hasMinInclusive() {
        return !this.literals.isEmpty();
    }

    @Override
    public boolean hasMaxExclusive() {
        return false;
    }

    @Override
    public boolean hasMaxInclusive() {
        return !this.literals.isEmpty();
    }

    @Override
    public boolean hasMin() {
        return !this.literals.isEmpty();
    }

    @Override
    public boolean hasMax() {
        return !this.literals.isEmpty();
    }

    @Override
    public R getMin() {
        if (this.literals.isEmpty()) {
            return null;
        }
        Object r = Facets.minInclusive.parseNumber(this.literals.get(0));
        return (R)r;
    }

    @Override
    public R getMax() {
        if (this.literals.isEmpty()) {
            return null;
        }
        Object r = Facets.maxInclusive.parseNumber(this.literals.get(this.literals.size() - 1));
        return (R)r;
    }

    @Override
    public OrderedDatatype<R> asOrderedDatatype() {
        return this;
    }
}

