/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.dep;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import org.roaringbitmap.IntIterator;
import org.roaringbitmap.RoaringBitmap;

@PortedFrom(file="tDepSet.h", name="TDepSet")
public class DepSet
implements Serializable {
    private static final long serialVersionUID = 11000L;
    @Original
    private RoaringBitmap delegate = null;
    private int cardinality = 0;

    @PortedFrom(file="tDepSet.h", name="create")
    public static DepSet create() {
        return new DepSet();
    }

    @PortedFrom(file="tDepSet.h", name="create")
    public static DepSet create(int i) {
        return new DepSet(i);
    }

    public static DepSet create(int ... values) {
        return DepSet.create(RoaringBitmap.bitmapOf((int[])values));
    }

    @PortedFrom(file="tDepSet.h", name="create")
    public static DepSet create(DepSet dep) {
        if (dep == null) {
            return DepSet.create();
        }
        return new DepSet(dep.delegate, dep.cardinality);
    }

    @PortedFrom(file="tDepSet.h", name="+")
    public static DepSet plus(DepSet ds1, DepSet ds2) {
        if (ds1 == null && ds2 == null) {
            return new DepSet();
        }
        if (ds1 == null || ds1.isEmpty()) {
            if (ds2 == null || ds2.isEmpty()) {
                return new DepSet();
            }
            return new DepSet(ds2.delegate, ds2.cardinality);
        }
        if (ds2 == null || ds2.isEmpty()) {
            return new DepSet(ds1.delegate, ds1.cardinality);
        }
        DepSet toReturn = new DepSet();
        toReturn.add(ds1);
        toReturn.add(ds2);
        return toReturn;
    }

    @PortedFrom(file="tDepSet.h", name="create")
    public static DepSet create(RoaringBitmap delegate) {
        return new DepSet(delegate, delegate == null ? 0 : delegate.getCardinality());
    }

    protected DepSet() {
    }

    private DepSet(RoaringBitmap d, int card) {
        this.delegate = d;
        this.cardinality = card;
    }

    @Original
    public RoaringBitmap getDelegate() {
        return this.delegate;
    }

    protected DepSet(int i) {
        this.delegate = RoaringBitmap.bitmapOf((int[])new int[]{i});
        this.cardinality = 1;
    }

    @PortedFrom(file="tDepSet.h", name="level")
    public int level() {
        return DepSet.max(this.delegate);
    }

    private static int max(RoaringBitmap set) {
        if (set == null || set.isEmpty()) {
            return 0;
        }
        return set.getReverseIntIterator().next();
    }

    @PortedFrom(file="tDepSet.h", name="empty")
    public boolean isEmpty() {
        return this.cardinality == 0;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        return "{" + this.delegate.toString() + "}";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof DepSet) {
            DepSet obj2 = (DepSet)obj;
            if (this.delegate == null) {
                return obj2.delegate == null;
            }
            if (this.cardinality != obj2.cardinality) {
                return false;
            }
            assert (this.cardinality == obj2.cardinality);
            if (this.cardinality == 0) {
                return true;
            }
            return this.delegate.equals((Object)obj2.delegate);
        }
        return false;
    }

    public int hashCode() {
        return this.delegate == null ? 0 : this.delegate.hashCode();
    }

    @PortedFrom(file="tDepSet.h", name="size")
    public int size() {
        return this.cardinality;
    }

    @PortedFrom(file="tDepSet.h", name="restrict")
    public void restrict(int level) {
        if (this.delegate != null) {
            RoaringBitmap f = new RoaringBitmap();
            IntIterator it = this.delegate.getIntIterator();
            while (it.hasNext()) {
                int i = it.next();
                if (i >= level) continue;
                f.add(i);
            }
            if (f.isEmpty()) {
                this.delegate = null;
                this.cardinality = 0;
            } else {
                this.delegate = f;
                this.cardinality = this.delegate.getCardinality();
            }
        }
    }

    @PortedFrom(file="tDepSet.h", name="clear")
    public void clear() {
        this.delegate = null;
        this.cardinality = 0;
    }

    @PortedFrom(file="tDepSet.h", name="add")
    public void add(DepSet toAdd) {
        if (toAdd == null || toAdd.size() == 0) {
            return;
        }
        if (this.delegate == null) {
            this.delegate = toAdd.delegate;
            this.cardinality = this.delegate.getCardinality();
            return;
        }
        this.delegate = RoaringBitmap.or((RoaringBitmap)this.delegate, (RoaringBitmap)toAdd.delegate);
        this.cardinality = this.delegate.getCardinality();
    }
}

