/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.helpers;

import java.util.Arrays;
import uk.ac.manchester.cs.jfact.helpers.AbstractFastSet;
import uk.ac.manchester.cs.jfact.helpers.FastSet;

public class IntList
extends AbstractFastSet {
    protected int[] values;
    protected int size = 0;
    protected static int defaultSize = 16;

    @Override
    public int get(int i) {
        if (this.values != null) {
            return this.values[i];
        }
        throw new IllegalArgumentException("Illegal argument " + i + ": no such element");
    }

    protected void init() {
        this.values = new int[defaultSize];
        this.size = 0;
    }

    public void add(int e) {
        if (this.values == null) {
            this.init();
        }
        if (this.size >= this.values.length) {
            this.values = Arrays.copyOf(this.values, this.values.length + defaultSize);
        }
        this.values[this.size] = e;
        ++this.size;
    }

    @Override
    public void addAll(FastSet c) {
        if (c.isEmpty()) {
            return;
        }
        if (this.values == null) {
            this.values = Arrays.copyOf(((IntList)c).values, c.size());
            this.size = c.size();
            return;
        }
        for (int i = 0; i < c.size(); ++i) {
            this.add(c.get(i));
        }
    }

    @Override
    public void clear() {
        this.values = null;
        this.size = 0;
    }

    @Override
    public boolean contains(int o) {
        if (this.values != null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.values[i] != o) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAll(FastSet c) {
        if (c.isEmpty()) {
            return true;
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.size() > this.size) {
            return false;
        }
        for (int i = 0; i < c.size(); ++i) {
            if (this.contains(c.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.values == null;
    }

    @Override
    public boolean containsAny(FastSet c) {
        if (c.isEmpty() || this.isEmpty()) {
            return false;
        }
        for (int i = 0; i < c.size(); ++i) {
            if (!this.contains(c.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void remove(int o) {
        if (this.values == null) {
            return;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.values[i] != o) continue;
            this.removeAt(i);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int[] toIntArray() {
        if (this.values == null) {
            return new int[0];
        }
        return Arrays.copyOf(this.values, this.size);
    }

    @Override
    public boolean intersect(FastSet f) {
        return this.containsAny(f);
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (this == arg0) {
            return true;
        }
        if (arg0 instanceof FastSet) {
            FastSet arg = (FastSet)arg0;
            if (this.size != arg.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (arg.get(i) == this.get(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public void removeAt(int i) {
        if (this.values == null) {
            return;
        }
        if (i > -1 && i < this.size) {
            if (this.size == 1) {
                this.values = null;
                this.size = 0;
                return;
            }
            for (int j = i; j < this.size - 1; ++j) {
                this.values[j] = this.values[j + 1];
            }
            --this.size;
        }
        if (this.size == 0) {
            this.values = null;
        }
    }

    @Override
    public void removeAll(int i, int end) {
        if (this.values == null) {
            return;
        }
        if (end < -1 || end < i || end > this.size || i < -1 || i > this.size) {
            throw new IllegalArgumentException("illegal arguments: " + i + " " + end + " size: " + this.size);
        }
        if (this.size == 1 || i == 0 && end == this.size) {
            this.values = null;
            this.size = 0;
            return;
        }
        if (end == this.size) {
            this.size = i;
        } else {
            int delta = end - i;
            for (int j = i; j < this.size - delta; ++j) {
                this.values[j] = this.values[j + delta];
            }
            this.size -= delta;
        }
        if (this.size == 0) {
            this.values = null;
        }
    }

    @Override
    public void removeAllValues(int ... vals) {
        if (this.values == null) {
            return;
        }
        for (int i : vals) {
            this.remove(i);
        }
        if (this.size == 0) {
            this.values = null;
        }
    }

    @Override
    public void completeSet(int value) {
        for (int i = 0; i <= value; ++i) {
            this.add(i);
        }
    }
}

