/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import uk.ac.manchester.cs.jfact.helpers.DLTree;
import uk.ac.manchester.cs.jfact.helpers.DLTreeFactory;
import uk.ac.manchester.cs.jfact.helpers.LogAdapter;
import uk.ac.manchester.cs.jfact.kernel.Concept;
import uk.ac.manchester.cs.jfact.kernel.InAx;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.TBox;
import uk.ac.manchester.cs.jfact.kernel.Token;
import uk.ac.manchester.cs.jfact.kernel.options.JFactReasonerConfiguration;
import uk.ac.manchester.cs.jfact.split.TOntologyAtom;

@PortedFrom(file="tAxiom.h", name="TAxiom")
public class Axiom
implements Serializable {
    private static final long serialVersionUID = 11000L;
    private static LogAdapter absorptionLog;
    private Axiom origin;
    @PortedFrom(file="tAxiom.h", name="Disjuncts")
    private final Set<DLTree> disjuncts = new LinkedHashSet<DLTree>();
    @Original
    private TOntologyAtom atom;

    public static void setLogAdapter(LogAdapter l) {
        absorptionLog = l;
    }

    public Axiom(Axiom parent) {
        this.origin = parent;
    }

    @PortedFrom(file="tAxiom.h", name="absorbIntoNegConcept")
    public boolean absorbIntoNegConcept(TBox KB) {
        Concept Concept2;
        ArrayList<DLTree> Cons = new ArrayList<DLTree>();
        DLTree bestConcept = null;
        for (DLTree p : this.disjuncts) {
            if (p.token() != Token.NOT || !p.getChild().isName() || !(Concept2 = InAx.getConcept(p.getChild())).isPrimitive() || Concept2.isSingleton() || Concept2.getDescription() != null) continue;
            InAx.SAbsNAttempt();
            Cons.add(p);
        }
        if (Cons.isEmpty()) {
            return false;
        }
        InAx.SAbsNApply();
        bestConcept = (DLTree)Cons.get(0);
        Concept2 = InAx.getConcept(bestConcept.getChild());
        JFactReasonerConfiguration options = KB.getOptions();
        if (options.isAbsorptionLoggingActive()) {
            absorptionLog.print((Object)" N-Absorb GCI to concept ", (Object)Concept2.getName());
            if (Cons.size() > 1) {
                absorptionLog.print(" (other options are");
                for (int j = 1; j < Cons.size(); ++j) {
                    absorptionLog.print((Object)" ", (Object)InAx.getConcept(((DLTree)Cons.get(j)).getChild()).getName());
                }
                absorptionLog.print(")");
            }
        }
        Concept nC = KB.getAuxConcept(this.createAnAxiom(bestConcept));
        KB.makeNonPrimitive(Concept2, DLTreeFactory.createSNFNot(KB.getTree(nC)));
        return true;
    }

    @PortedFrom(file="tAxiom.h", name="copy")
    private Axiom copy(DLTree skip) {
        Axiom ret = new Axiom(this);
        for (DLTree i : this.disjuncts) {
            if (i.equals(skip)) continue;
            ret.disjuncts.add(i.copy());
        }
        return ret;
    }

    @PortedFrom(file="tAxiom.h", name="isCyclic")
    boolean isCyclic() {
        Axiom p = this.origin;
        while (p != null) {
            if (p.equals(this)) {
                absorptionLog.print(" same as ancestor");
                return true;
            }
            p = p.origin;
        }
        return false;
    }

    @PortedFrom(file="tAxiom.h", name="simplifyPosNP")
    private Axiom simplifyPosNP(DLTree pos) {
        InAx.SAbsRepCN();
        Axiom ret = this.copy(pos);
        ret.add(DLTreeFactory.createSNFNot(InAx.getConcept(pos.getChild()).getDescription().copy()));
        absorptionLog.print((Object)" simplify CN expression for ", (Object)pos.getChild());
        return ret;
    }

    @PortedFrom(file="tAxiom.h", name="simplifyNegNP")
    private Axiom simplifyNegNP(DLTree pos) {
        InAx.SAbsRepCN();
        Axiom ret = this.copy(pos);
        ret.add(InAx.getConcept(pos).getDescription().copy());
        absorptionLog.print((Object)" simplify ~CN expression for ", (Object)pos);
        return ret;
    }

    @PortedFrom(file="tAxiom.h", name="split")
    private List<Axiom> split(List<Axiom> acc, DLTree pos, DLTree pAnd) {
        if (pAnd.isAND()) {
            ArrayList<DLTree> children = new ArrayList<DLTree>(pAnd.getChildren());
            acc = this.split(acc, pos, (DLTree)children.remove(0));
            if (!children.isEmpty()) {
                acc = this.split(acc, pos, DLTreeFactory.createSNFAnd(children));
            }
        } else {
            Axiom ret = this.copy(pos);
            ret.add(DLTreeFactory.createSNFNot(pAnd.copy()));
            acc.add(ret);
        }
        return acc;
    }

    @PortedFrom(file="tAxiom.h", name="split")
    public List<Axiom> split() {
        List<Axiom> acc = new ArrayList<Axiom>();
        for (DLTree p : this.disjuncts) {
            if (!InAx.isAnd(p)) continue;
            InAx.SAbsSplit();
            absorptionLog.print((Object)" split AND expression ", (Object)p.getChild());
            acc = this.split(acc, p, p.getChildren().iterator().next());
            return acc;
        }
        return acc;
    }

    @PortedFrom(file="tAxiom.h", name="add")
    public void add(DLTree p) {
        if (InAx.isBot(p)) {
            return;
        }
        if (InAx.isOr(p)) {
            for (DLTree d : p.getChildren()) {
                this.add(d);
            }
            return;
        }
        this.disjuncts.add(p);
    }

    public String toString() {
        StringBuilder b = new StringBuilder(" (neg-and ");
        for (DLTree p : this.disjuncts) {
            b.append(p);
        }
        b.append(')');
        return b.toString();
    }

    @PortedFrom(file="tAxiom.h", name="simplifyCN")
    public Axiom simplifyCN(TBox t) {
        for (DLTree p : this.disjuncts) {
            if (InAx.isPosNP(p, t)) {
                return this.simplifyPosNP(p);
            }
            if (!InAx.isNegNP(p, t)) continue;
            return this.simplifyNegNP(p);
        }
        return null;
    }

    @PortedFrom(file="tAxiom.h", name="simplifyForall")
    public Axiom simplifyForall(TBox KB) {
        for (DLTree i : this.disjuncts) {
            if (!InAx.isAbsForall(i)) continue;
            return this.simplifyForall(i, KB);
        }
        return null;
    }

    public Axiom simplifySForall(TBox KB) {
        for (DLTree i : this.disjuncts) {
            if (!InAx.isSimpleForall(i)) continue;
            return this.simplifyForall(i, KB);
        }
        return null;
    }

    @PortedFrom(file="tAxiom.h", name="simplifyForall")
    private Axiom simplifyForall(DLTree pos, TBox KB) {
        InAx.SAbsRepForall();
        DLTree pAll = pos.getChild();
        absorptionLog.print((Object)" simplify ALL expression", (Object)pAll);
        Axiom ret = this.copy(pos);
        ret.add(KB.getTree(KB.replaceForall(pAll.copy())));
        return ret;
    }

    @PortedFrom(file="tAxiom.h", name="createAnAxiom")
    public DLTree createAnAxiom(DLTree replaced) {
        if (this.disjuncts.isEmpty()) {
            return DLTreeFactory.createBottom();
        }
        ArrayList<DLTree> leaves = new ArrayList<DLTree>();
        for (DLTree d : this.disjuncts) {
            if (d.equals(replaced)) continue;
            leaves.add(d.copy());
        }
        DLTree result = DLTreeFactory.createSNFAnd(leaves);
        return DLTreeFactory.createSNFNot(result);
    }

    @PortedFrom(file="tAxiom.h", name="absorbIntoBottom")
    public boolean absorbIntoBottom() {
        ArrayList<DLTree> Pos = new ArrayList<DLTree>();
        ArrayList<DLTree> Neg = new ArrayList<DLTree>();
        block5: for (DLTree p : this.disjuncts) {
            switch (p.token()) {
                case BOTTOM: {
                    InAx.SAbsBApply();
                    absorptionLog.print(" Absorb into BOTTOM");
                    return true;
                }
                case TOP: {
                    continue block5;
                }
                case NOT: {
                    Neg.add(p.getChild());
                    continue block5;
                }
            }
            Pos.add(p);
        }
        for (DLTree q : Neg) {
            for (DLTree s : Pos) {
                if (!q.equals(s)) continue;
                InAx.SAbsBApply();
                absorptionLog.print((Object)" Absorb into BOTTOM due to (not", (Object)q, (Object)") and", (Object)s);
                return true;
            }
        }
        return false;
    }

    @PortedFrom(file="tAxiom.h", name="absorbIntoConcept")
    public boolean absorbIntoConcept(TBox KB) {
        ArrayList<DLTree> Cons = new ArrayList<DLTree>();
        DLTree bestConcept = null;
        for (DLTree p : this.disjuncts) {
            if (!InAx.isNegPC(p)) continue;
            InAx.SAbsCAttempt();
            Cons.add(p);
            if (!InAx.getConcept(p).isSystem()) continue;
            bestConcept = p;
        }
        if (Cons.isEmpty()) {
            return false;
        }
        InAx.SAbsCApply();
        if (bestConcept == null) {
            bestConcept = (DLTree)Cons.get(0);
        }
        Concept Concept2 = InAx.getConcept(bestConcept);
        if (KB.getOptions().isAbsorptionLoggingActive()) {
            absorptionLog.print((Object)" C-Absorb GCI to concept ", (Object)Concept2.getName());
            if (Cons.size() > 1) {
                absorptionLog.print(" (other options are");
                for (int j = 1; j < Cons.size(); ++j) {
                    absorptionLog.print((Object)" ", (Object)InAx.getConcept((DLTree)Cons.get(j)).getName());
                }
                absorptionLog.print(")");
            }
        }
        Concept2.addDesc(this.createAnAxiom(bestConcept));
        Concept2.removeSelfFromDescription();
        KB.clearRelevanceInfo();
        KB.checkToldCycle(Concept2);
        KB.clearRelevanceInfo();
        return true;
    }

    @PortedFrom(file="tAxiom.h", name="absorbIntoDomain")
    public boolean absorbIntoDomain(TBox KB) {
        ArrayList<DLTree> Cons = new ArrayList<DLTree>();
        DLTree bestSome = null;
        for (DLTree p : this.disjuncts) {
            if (p.token() != Token.NOT || p.getChild().token() != Token.FORALL && p.getChild().token() != Token.LE) continue;
            InAx.SAbsRAttempt();
            Cons.add(p);
            if (!p.getChild().getRight().isBOTTOM()) continue;
            bestSome = p;
            break;
        }
        if (Cons.isEmpty()) {
            return false;
        }
        InAx.SAbsRApply();
        Role role = bestSome != null ? Role.resolveRole(bestSome.getChild().getLeft()) : Role.resolveRole(((DLTree)Cons.get(0)).getChild().getLeft());
        if (KB.getOptions().isAbsorptionLoggingActive()) {
            absorptionLog.print((Object)" R-Absorb GCI to the domain of role ", (Object)role.getName());
            if (Cons.size() > 1) {
                absorptionLog.print(" (other options are");
                for (int j = 1; j < Cons.size(); ++j) {
                    absorptionLog.print((Object)" ", (Object)Role.resolveRole(((DLTree)Cons.get(j)).getChild().getLeft()).getName());
                }
                absorptionLog.print(")");
            }
        }
        role.setDomain(this.createAnAxiom(bestSome));
        return true;
    }

    @PortedFrom(file="tAxiom.h", name="absorbIntoTop")
    public boolean absorbIntoTop(TBox KB) {
        Concept C = null;
        for (DLTree p : this.disjuncts) {
            if (InAx.isBot(p)) continue;
            if (InAx.isPosCN(p)) {
                if (C != null) {
                    return false;
                }
                C = InAx.getConcept(p.getChild());
                if (!C.isSingleton()) continue;
                return false;
            }
            return false;
        }
        if (C == null) {
            return false;
        }
        InAx.SAbsTApply();
        DLTree desc = KB.makeNonPrimitive(C, DLTreeFactory.createTop());
        if (KB.getOptions().isAbsorptionLoggingActive()) {
            absorptionLog.print("TAxiom.absorbIntoTop() T-Absorb GCI to axiom\n");
            if (desc != null) {
                absorptionLog.print((Object)"s *TOP* [=", (Object)desc, (Object)" and\n");
            }
            absorptionLog.print((Object)" ", (Object)C.getName(), (Object)" = *TOP*\n");
        }
        if (desc != null) {
            KB.addSubsumeAxiom(DLTreeFactory.createTop(), desc);
        }
        return true;
    }

    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (this == arg0) {
            return true;
        }
        if (arg0 instanceof Axiom) {
            Axiom ax = (Axiom)arg0;
            return this.disjuncts.equals(ax.disjuncts);
        }
        return false;
    }

    public int hashCode() {
        return this.disjuncts.hashCode();
    }

    @Original
    public TOntologyAtom getAtom() {
        return this.atom;
    }

    @Original
    public void setAtom(TOntologyAtom atom) {
        this.atom = atom;
    }
}

