/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.roaringbitmap.RoaringBitmap;
import uk.ac.manchester.cs.jfact.dep.DepSet;
import uk.ac.manchester.cs.jfact.helpers.ArrayIntMap;
import uk.ac.manchester.cs.jfact.helpers.Helper;
import uk.ac.manchester.cs.jfact.kernel.ConceptWDep;
import uk.ac.manchester.cs.jfact.kernel.Restorer;
import uk.ac.manchester.cs.jfact.kernel.UnMerge;
import uk.ac.manchester.cs.jfact.kernel.options.JFactReasonerConfiguration;

@PortedFrom(file="CWDArray.h", name="CWDArray")
public class CWDArray
implements Serializable {
    private static final long serialVersionUID = 11000L;
    @Original
    private static final double distribution = 0.025;
    @PortedFrom(file="CWDArray.h", name="Base")
    private final List<ConceptWDep> base;
    @Original
    @Nonnull
    private RoaringBitmap cache = new RoaringBitmap();
    @Original
    private final ArrayIntMap indexes = new ArrayIntMap();
    @Original
    private int size = 0;
    @Original
    private JFactReasonerConfiguration options;

    public CWDArray(JFactReasonerConfiguration config, int size) {
        this.options = config;
        this.base = new ArrayList<ConceptWDep>(size);
    }

    @PortedFrom(file="CWDArray.h", name="init")
    public void init() {
        this.base.clear();
        this.cache.clear();
        this.indexes.clear();
        this.size = 0;
    }

    @PortedFrom(file="CWDArray.h", name="begin")
    public List<ConceptWDep> getBase() {
        return this.base;
    }

    @Original
    public ArrayIntMap getContainedConcepts() {
        return this.indexes;
    }

    @Original
    protected void private_add(ConceptWDep p) {
        this.base.add(p);
        ++this.size;
        this.cache.add(CWDArray.asPositive(p.getConcept()));
        this.indexes.put(p.getConcept(), this.size - 1);
    }

    @PortedFrom(file="CWDArray.h", name="contains")
    public boolean contains(int bp) {
        return this.cache.contains(CWDArray.asPositive(bp));
    }

    @Original
    private static int asPositive(int p) {
        return p >= 0 ? 2 * p : 1 - 2 * p;
    }

    @PortedFrom(file="CWDArray.h", name="index")
    public int index(int bp) {
        if (!this.cache.contains(CWDArray.asPositive(bp))) {
            return -1;
        }
        return this.indexes.get(bp);
    }

    @PortedFrom(file="CWDArray.h", name="get")
    public DepSet get(int bp) {
        ConceptWDep cwd = this.getConceptWithBP(bp);
        if (cwd == null) {
            return null;
        }
        return cwd.getDep();
    }

    @Original
    public ConceptWDep getConceptWithBP(int bp) {
        if (!this.cache.contains(CWDArray.asPositive(bp))) {
            return null;
        }
        int i = this.indexes.get(bp);
        if (i < 0) {
            return null;
        }
        return this.base.get(i);
    }

    @PortedFrom(file="CWDArray.h", name="size")
    public int size() {
        return this.size;
    }

    @PortedFrom(file="CWDArray.h", name="<=")
    public boolean lesserequal(CWDArray label) {
        Iterator iterator = this.cache.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if (label.cache.contains(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.indexes.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof CWDArray) {
            CWDArray obj2 = (CWDArray)obj;
            return this.indexes.equals(obj2.indexes);
        }
        return false;
    }

    @PortedFrom(file="CWDArray.h", name="save")
    public int save() {
        return this.size;
    }

    @PortedFrom(file="CWDArray.h", name="updateDepSet")
    public Restorer updateDepSet(int index, DepSet dep) {
        if (dep.isEmpty()) {
            throw new IllegalArgumentException();
        }
        UnMerge ret = new UnMerge(this, this.base.get(index), index);
        this.base.get(index).addDep(dep);
        return ret;
    }

    @PortedFrom(file="CWDArray.h", name="updateDepSet")
    public List<Restorer> updateDepSet(DepSet dep) {
        if (dep.isEmpty()) {
            throw new IllegalArgumentException();
        }
        ArrayList<Restorer> toReturn = new ArrayList<Restorer>(this.size);
        for (int i = 0; i < this.size; ++i) {
            UnMerge ret = new UnMerge(this, this.base.get(i), i);
            this.base.get(i).addDep(dep);
            toReturn.add(ret);
        }
        return toReturn;
    }

    @PortedFrom(file="CWDArray.h", name="restore")
    public void restore(int ss, int level) {
        int count = 0;
        for (int i = ss; i < this.size; ++i) {
            if (!this.options.isRKG_USE_DYNAMIC_BACKJUMPING() || this.base.get(i).getDep().level() >= level) {
                int concept = this.base.get(i).getConcept();
                this.indexes.remove(concept);
                this.cache.remove(CWDArray.asPositive(concept));
                continue;
            }
            ++count;
        }
        Helper.resize(this.base, ss + count);
        this.size = ss + count;
    }

    public String toString() {
        StringBuilder o = new StringBuilder();
        o.append(" [");
        for (int i = 0; i < this.size; ++i) {
            if (i != 0) {
                o.append(", ");
            }
            o.append(this.base.get(i));
        }
        o.append(']');
        return o.toString();
    }
}

