/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeEntry;
import uk.ac.manchester.cs.jfact.datatypes.LiteralEntry;
import uk.ac.manchester.cs.jfact.helpers.DLVertex;
import uk.ac.manchester.cs.jfact.helpers.FastSet;
import uk.ac.manchester.cs.jfact.helpers.FastSetFactory;
import uk.ac.manchester.cs.jfact.helpers.Helper;
import uk.ac.manchester.cs.jfact.helpers.LogAdapter;
import uk.ac.manchester.cs.jfact.helpers.StatIndex;
import uk.ac.manchester.cs.jfact.helpers.Templates;
import uk.ac.manchester.cs.jfact.helpers.UnreachableSituationException;
import uk.ac.manchester.cs.jfact.kernel.Concept;
import uk.ac.manchester.cs.jfact.kernel.DLVTable;
import uk.ac.manchester.cs.jfact.kernel.DagTag;
import uk.ac.manchester.cs.jfact.kernel.MergableLabel;
import uk.ac.manchester.cs.jfact.kernel.NamedEntry;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.RoleMaster;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheInterface;
import uk.ac.manchester.cs.jfact.kernel.options.JFactReasonerConfiguration;

@PortedFrom(file="dlDag.h", name="DLDag")
public class DLDag
implements Serializable {
    private static final long serialVersionUID = 11000L;
    @PortedFrom(file="dlDag.h", name="Heap")
    private final List<DLVertex> heap = new ArrayList<DLVertex>();
    private Set<NamedEntry> cache = new HashSet<NamedEntry>();
    @PortedFrom(file="dlDag.h", name="listAnds")
    private final FastSet listAnds = FastSetFactory.create();
    @Original
    private final EnumMap<DagTag, DLVTable> indexes = new EnumMap(DagTag.class);
    @PortedFrom(file="dlDag.h", name="nCacheHits")
    private int nCacheHits;
    @PortedFrom(file="dlDag.h", name="sortArraySize")
    private int sortArraySize;
    @PortedFrom(file="dlDag.h", name="iSort")
    private int iSort;
    @PortedFrom(file="dlDag.h", name="sortAscend")
    private boolean sortAscend;
    @PortedFrom(file="dlDag.h", name="preferNonGen")
    private boolean preferNonGen;
    @PortedFrom(file="dlDag.h", name="useDLVCache")
    private boolean useDLVCache;
    @PortedFrom(file="dlDag.h", name="finalDagSize")
    private int finalDagSize;
    @Original
    private final JFactReasonerConfiguration options;

    @PortedFrom(file="dlDag.h", name="replaceVertex")
    public void replaceVertex(int i, DLVertex v, NamedEntry C) {
        this.heap.set(i > 0 ? i : -i, v);
        v.setConcept(C);
        this.cache.clear();
    }

    @PortedFrom(file="dlDag.h", name="index")
    public int index(NamedEntry c) {
        for (int i = 0; i < this.heap.size(); ++i) {
            NamedEntry concept = this.heap.get(i).getConcept();
            if (concept == null || !concept.equals(c)) continue;
            return i;
        }
        return 0;
    }

    @PortedFrom(file="dlDag.h", name="isCorrectOption")
    private static boolean isCorrectOption(String str) {
        if (str == null) {
            return false;
        }
        int n = str.length();
        if (n < 1 || n > 3) {
            return false;
        }
        char Method2 = str.charAt(0);
        int Order = n >= 2 ? (int)str.charAt(1) : 97;
        int NGPref = n == 3 ? (int)str.charAt(2) : 112;
        return !(Method2 != 'S' && Method2 != 'D' && Method2 != 'F' && Method2 != 'B' && Method2 != 'G' && Method2 != '0' || Order != 97 && Order != 100 || NGPref != 112 && NGPref != 110);
    }

    @PortedFrom(file="dlDag.h", name="Recompute")
    private void recompute() {
        for (int p = 0; p < this.listAnds.size(); ++p) {
            this.heap.get(this.listAnds.get(p)).sortEntry(this);
        }
    }

    @PortedFrom(file="dlDag.h", name="clearDFS")
    private void clearDFS() {
        for (DLVertex d : this.heap) {
            d.clearDFS();
        }
    }

    @PortedFrom(file="dlDag.h", name="updateIndex")
    public void updateIndex(DagTag tag, int value) {
        if (!this.indexes.containsKey((Object)tag)) {
            return;
        }
        this.indexes.get((Object)tag).addElement(value);
        if (tag == DagTag.dtCollection || tag == DagTag.dtAnd) {
            this.listAnds.add(value);
        }
    }

    @PortedFrom(file="dlDag.h", name="directAdd")
    public int directAdd(DLVertex v, boolean knownNew) {
        int index;
        if (knownNew) {
            this.heap.add(v);
            this.cache.add(v.getConcept());
            return this.heap.size() - 1;
        }
        if (this.cache.isEmpty()) {
            for (DLVertex v1 : this.heap) {
                this.cache.add(v1.getConcept());
            }
        }
        if (this.cache.contains(v.getConcept()) && (index = this.index(v.getConcept())) != 0) {
            return index;
        }
        this.heap.add(v);
        this.cache.add(v.getConcept());
        return this.heap.size() - 1;
    }

    @PortedFrom(file="dlDag.h", name="directAddAndCache")
    public int directAddAndCache(DLVertex v) {
        int ret = this.directAdd(v, false);
        if (this.useDLVCache) {
            this.updateIndex(v.getType(), ret);
        }
        return ret;
    }

    @PortedFrom(file="dlDag.h", name="isLast")
    public boolean isLast(int p) {
        int last = this.heap.size() - 1;
        return p == last || -p == last;
    }

    @PortedFrom(file="dlDag.h", name="setExpressionCache")
    public void setExpressionCache(boolean val) {
        this.useDLVCache = val;
    }

    @PortedFrom(file="dlDag.h", name="get")
    public DLVertex get(int i) {
        assert (Helper.isValid(i));
        return this.heap.get(i < 0 ? -i : i);
    }

    @PortedFrom(file="dlDag.h", name="size")
    public int size() {
        return this.heap.size();
    }

    @PortedFrom(file="dlDag.h", name="maxSize")
    public int maxSize() {
        return this.size() + (this.size() < 220 ? 10 : this.size() / 20);
    }

    @PortedFrom(file="dlDag.h", name="setSubOrder")
    public void setSubOrder() {
        this.setOrderOptions(this.options.getORSortSub());
    }

    @PortedFrom(file="dlDag.h", name="setSatOrder")
    public void setSatOrder() {
        this.setOrderOptions(this.options.getORSortSat());
    }

    @PortedFrom(file="dlDag.h", name="getCache")
    public ModelCacheInterface getCache(int p) {
        return this.get(p).getCache(p > 0);
    }

    @PortedFrom(file="dlDag.h", name="setCache")
    public void setCache(int p, ModelCacheInterface cache) {
        this.get(p).setCache(p > 0, cache);
    }

    @PortedFrom(file="dlDag.h", name="merge")
    public void merge(MergableLabel ml, int p) {
        if (p != 0 && p != 1 && p != -1) {
            this.get(p).merge(ml);
        }
    }

    @PortedFrom(file="dlDag.h", name="haveSameSort")
    public boolean haveSameSort(int p, int q) {
        if (this.options.isRKG_USE_SORTED_REASONING()) {
            assert (p > 0 && q > 0);
            if (p == 1 || q == 1) {
                return true;
            }
            if (p >= this.sortArraySize || q >= this.sortArraySize) {
                return true;
            }
            return this.get(p).getSort().equals(this.get(q).getSort());
        }
        return true;
    }

    @PortedFrom(file="dlDag.h", name="PrintStat")
    public void printStat(LogAdapter o) {
        o.printTemplate(Templates.PRINT_STAT, this.heap.size(), this.nCacheHits);
        if (this.options.isRKG_PRINT_DAG_USAGE()) {
            this.printDAGUsage(o);
        }
    }

    public String toString() {
        StringBuilder o = new StringBuilder("\nDag structure");
        for (int i = 1; i < this.size(); ++i) {
            o.append('\n');
            o.append(i);
            o.append(' ');
            o.append(this.get(i));
        }
        o.append('\n');
        return o.toString();
    }

    @PortedFrom(file="dlDag.h", name="add")
    public int add(DLVertex v) {
        int ret;
        int n = ret = this.useDLVCache ? this.indexes.get((Object)v.getType()).locate(v) : 0;
        if (!Helper.isValid(ret)) {
            ret = this.directAddAndCache(v);
            return ret;
        }
        ++this.nCacheHits;
        return ret;
    }

    public DLDag(JFactReasonerConfiguration Options) {
        this.options = Options;
        DLVTable indexAnd = new DLVTable(this);
        DLVTable indexAll = new DLVTable(this);
        DLVTable indexLE = new DLVTable(this);
        this.indexes.put(DagTag.dtCollection, indexAnd);
        this.indexes.put(DagTag.dtAnd, indexAnd);
        this.indexes.put(DagTag.dtIrr, indexAll);
        this.indexes.put(DagTag.dtForall, indexAll);
        this.indexes.put(DagTag.dtLE, indexLE);
        this.nCacheHits = 0;
        this.useDLVCache = true;
        this.finalDagSize = 0;
        this.heap.add(new DLVertex(DagTag.dtBad));
        this.heap.add(new DLVertex(DagTag.dtTop));
        if (!DLDag.isCorrectOption(this.options.getORSortSat()) || !DLDag.isCorrectOption(this.options.getORSortSub())) {
            throw new OWLRuntimeException("DAG: wrong OR sorting options");
        }
    }

    @PortedFrom(file="dlDag.h", name="setFinalSize")
    public void setFinalSize() {
        this.finalDagSize = this.size();
        this.setExpressionCache(false);
    }

    @PortedFrom(file="dlDag.h", name="removeQuery")
    public void removeQuery() {
        block5: for (int i = this.size() - 1; i >= this.finalDagSize; --i) {
            DLVertex v = this.heap.get(i);
            switch (v.getType()) {
                case dtDataType: 
                case dtDataExpr: {
                    ((DatatypeEntry)v.getConcept()).setIndex(0);
                    continue block5;
                }
                case dtDataValue: {
                    ((LiteralEntry)v.getConcept()).setIndex(0);
                    continue block5;
                }
                case dtPConcept: 
                case dtNConcept: {
                    ((Concept)v.getConcept()).clear();
                    continue block5;
                }
            }
        }
        Helper.resize(this.heap, this.finalDagSize);
        this.cache.clear();
    }

    @PortedFrom(file="dlDag.h", name="setOrderDefaults")
    public void setOrderDefaults(String defSat, String defSub) {
        assert (DLDag.isCorrectOption(defSat) && DLDag.isCorrectOption(defSub));
        this.options.getLog().print((Object)"orSortSat: initial=", (Object)this.options.getORSortSat(), (Object)", default=", (Object)defSat);
        if (this.options.getORSortSat().charAt(0) == '0') {
            this.options.setorSortSat(defSat);
        }
        this.options.getLog().print((Object)", used=", (Object)this.options.getORSortSat(), (Object)"\n");
        this.options.getLog().print((Object)"orSortSub: initial=", (Object)this.options.getORSortSub(), (Object)", default=", (Object)defSub);
        if (this.options.getORSortSub().charAt(0) == '0') {
            this.options.setorSortSub(defSub);
        }
        this.options.getLog().print((Object)", used=", (Object)this.options.getORSortSub(), (Object)"\n");
    }

    @PortedFrom(file="dlDag.h", name="setOrderOptions")
    public void setOrderOptions(String opt) {
        if (opt.charAt(0) == '0') {
            return;
        }
        this.sortAscend = opt.charAt(1) == 'a';
        this.preferNonGen = opt.charAt(2) == 'p';
        this.iSort = StatIndex.choose(opt.charAt(0));
        this.recompute();
    }

    @PortedFrom(file="dlDag.h", name="computeVertexStat")
    private void computeVertexStat(DLVertex v, boolean pos, int depth) {
        if (v.isVisited(pos)) {
            v.setInCycle(pos);
            return;
        }
        v.setVisited(pos);
        switch (v.getType()) {
            case dtCollection: {
                if (!pos) break;
            }
            case dtAnd: {
                for (int q : v.begin()) {
                    boolean pos2;
                    int index = Helper.createBiPointer(q, pos);
                    DLVertex vertex = this.get(index);
                    boolean bl = pos2 = index > 0;
                    if (vertex.isProcessed(pos2)) continue;
                    this.computeVertexStat(vertex, pos2, depth + 1);
                }
                break;
            }
            case dtProj: {
                if (!pos) break;
            }
            case dtPConcept: 
            case dtNConcept: 
            case dtPSingleton: 
            case dtNSingleton: 
            case dtForall: 
            case dtChoose: 
            case dtLE: {
                boolean pos2;
                int index = Helper.createBiPointer(v.getConceptIndex(), pos);
                DLVertex vertex = this.get(index);
                boolean bl = pos2 = index > 0;
                if (vertex.isProcessed(pos2)) break;
                this.computeVertexStat(vertex, pos2, depth + 1);
                break;
            }
        }
        v.setProcessed(pos);
        this.updateVertexStat(v, pos);
    }

    @PortedFrom(file="dlDag.h", name="updateVertexStat")
    private void updateVertexStat(DLVertex v, boolean pos) {
        int d = 0;
        int s = 1;
        int b = 0;
        int g = 0;
        if (!v.getType().omitStat(pos)) {
            if (Helper.isValid(v.getConceptIndex())) {
                this.updateVertexStat(v, v.getConceptIndex(), pos);
            } else {
                for (int q : v.begin()) {
                    this.updateVertexStat(v, q, pos);
                }
            }
        }
        d = v.getDepth(pos);
        switch (v.getType()) {
            case dtAnd: {
                if (pos) break;
                ++b;
                break;
            }
            case dtForall: {
                ++d;
                if (pos) break;
                ++g;
                break;
            }
            case dtLE: {
                ++d;
                if (!pos) {
                    ++g;
                    break;
                }
                if (v.getNumberLE() == 1) break;
                ++b;
                break;
            }
            case dtProj: {
                if (!pos) break;
                ++b;
                break;
            }
        }
        v.updateStatValues(d, s, b, g, pos);
    }

    @PortedFrom(file="dlDag.h", name="computeVertexFreq")
    private void computeVertexFreq(int p) {
        boolean pos;
        DLVertex v = this.get(p);
        boolean bl = pos = p > 0;
        if (v.isVisited(pos)) {
            return;
        }
        v.incFreqValue(pos);
        v.setVisited(pos);
        if (v.getType().omitStat(pos)) {
            return;
        }
        if (Helper.isValid(v.getConceptIndex())) {
            this.computeVertexFreq(v.getConceptIndex(), pos);
        } else {
            for (int q : v.begin()) {
                this.computeVertexFreq(q, pos);
            }
        }
    }

    @PortedFrom(file="dlDag.h", name="updateVertexStat")
    private void updateVertexStat(DLVertex v, int p, boolean pos) {
        boolean same;
        DLVertex w = this.get(p);
        boolean bl = same = pos == p > 0;
        if (w.isInCycle(same)) {
            v.setInCycle(pos);
        }
        v.updateStatValues(w, same, pos);
    }

    @PortedFrom(file="dlDag.h", name="computeVertexFreq")
    private void computeVertexFreq(int p, boolean pos) {
        this.computeVertexFreq(Helper.createBiPointer(p, pos));
    }

    @PortedFrom(file="dlDag.h", name="gatherStatistic")
    public void gatherStatistic() {
        int i;
        for (i = 0; i < this.listAnds.size(); ++i) {
            boolean pos;
            int index = -this.listAnds.get(i);
            DLVertex v = this.get(index);
            boolean bl = pos = index > 0;
            if (v.isProcessed(pos)) continue;
            this.computeVertexStat(v, pos, 0);
        }
        if (this.options.getORSortSat().charAt(0) != 'F' && this.options.getORSortSub().charAt(0) != 'F') {
            return;
        }
        this.clearDFS();
        for (i = this.size() - 1; i > 1; --i) {
            if (!this.get(i).getType().isCNameTag()) continue;
            this.computeVertexFreq(i);
        }
    }

    @PortedFrom(file="dlDag.h", name="less")
    public int compare(int p1, int p2) {
        int key2;
        if (p1 == p2) {
            return 0;
        }
        if (this.preferNonGen) {
            if (p1 < 0 && p2 > 0) {
                return -1;
            }
            if (p1 > 0 && p2 < 0) {
                return 1;
            }
        }
        DLVertex v1 = this.get(p1);
        DLVertex v2 = this.get(p2);
        int key1 = v1.getStat(this.iSort);
        if (key1 == (key2 = v2.getStat(this.iSort))) {
            return 0;
        }
        if (this.sortAscend) {
            return key1 - key2;
        }
        return key2 - key1;
    }

    @PortedFrom(file="dlDag.h", name="PrintDAGUsage")
    public void printDAGUsage(LogAdapter o) {
        int n = 0;
        int total = this.heap.size() * 2 - 2;
        for (DLVertex i : this.heap) {
            if (i.getUsage(true) == 0L) {
                ++n;
            }
            if (i.getUsage(false) != 0L) continue;
            ++n;
        }
        o.printTemplate(Templates.PRINTDAGUSAGE, n, n * 100 / total, total);
    }

    /*
     * WARNING - void declaration
     */
    @PortedFrom(file="dlDag.h", name="determineSorts")
    public void determineSorts(RoleMaster ORM, RoleMaster DRM) {
        void var5_13;
        void var5_12;
        MergableLabel lab;
        void var5_8;
        this.sortArraySize = this.heap.size();
        List<Role> ORM_Begin = ORM.getRoles();
        for (Role role : ORM_Begin) {
            if (role.isSynonym()) continue;
            this.mergeSorts(role);
        }
        List<Role> DRM_Begin = DRM.getRoles();
        for (Role p : DRM_Begin) {
            if (p.isSynonym()) continue;
            this.mergeSorts(p);
        }
        int n = 2;
        while (var5_8 < this.heap.size()) {
            this.mergeSorts(this.heap.get((int)var5_8));
            ++var5_8;
        }
        boolean bl = false;
        for (int i = 2; i < this.heap.size(); ++i) {
            void var5_10;
            MergableLabel lab2 = this.heap.get(i).getSort();
            lab2.resolve();
            if (!lab2.isSample()) continue;
            ++var5_10;
        }
        for (Role p : ORM_Begin) {
            void var5_11;
            if (p.isSynonym()) continue;
            lab = p.getDomainLabel();
            lab.resolve();
            if (!lab.isSample()) continue;
            ++var5_11;
        }
        for (Role p : DRM_Begin) {
            if (p.isSynonym()) continue;
            lab = p.getDomainLabel();
            lab.resolve();
            if (!lab.isSample()) continue;
            ++var5_12;
        }
        if (var5_12 > 0) {
            --var5_13;
        }
        this.options.getLog().printTemplate(Templates.DETERMINE_SORTS, var5_13 > 0 ? Integer.valueOf((int)var5_13) : "no");
    }

    @PortedFrom(file="dlDag.h", name="mergeSorts")
    private void mergeSorts(Role R) {
        R.mergeSupersDomain();
        this.merge(R.getDomainLabel(), R.getBPDomain());
        for (Role q : R.begin_topfunc()) {
            this.merge(R.getDomainLabel(), q.getFunctional());
        }
    }

    @PortedFrom(file="dlDag.h", name="mergeSorts")
    private void mergeSorts(DLVertex v) {
        switch (v.getType()) {
            case dtForall: 
            case dtLE: {
                v.merge(v.getRole().getDomainLabel());
                this.merge(v.getRole().getRangeLabel(), v.getConceptIndex());
                break;
            }
            case dtProj: {
                v.merge(v.getRole().getDomainLabel());
                v.merge(v.getProjRole().getDomainLabel());
                this.merge(v.getRole().getDomainLabel(), v.getConceptIndex());
                v.getRole().getRangeLabel().merge(v.getProjRole().getRangeLabel());
                break;
            }
            case dtIrr: {
                v.merge(v.getRole().getDomainLabel());
                v.merge(v.getRole().getRangeLabel());
                break;
            }
            case dtCollection: 
            case dtAnd: {
                for (int q : v.begin()) {
                    this.merge(v.getSort(), q);
                }
                break;
            }
            case dtPConcept: 
            case dtNConcept: 
            case dtPSingleton: 
            case dtNSingleton: 
            case dtChoose: {
                this.merge(v.getSort(), v.getConceptIndex());
                break;
            }
            case dtDataType: 
            case dtDataExpr: 
            case dtDataValue: 
            case dtNN: {
                break;
            }
            default: {
                throw new UnreachableSituationException();
            }
        }
    }

    @PortedFrom(file="dlDag.h", name="updateSorts")
    public void updateSorts(int a, Role R, int b) {
        this.merge(R.getDomainLabel(), a);
        this.merge(R.getRangeLabel(), b);
    }
}

