/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.ReasonerInternalException;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.LiteralEntry;
import uk.ac.manchester.cs.jfact.helpers.DLTree;
import uk.ac.manchester.cs.jfact.helpers.DLTreeFactory;
import uk.ac.manchester.cs.jfact.helpers.Timer;
import uk.ac.manchester.cs.jfact.kernel.CacheStatus;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.Concept;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTree;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTreeArc;
import uk.ac.manchester.cs.jfact.kernel.ExpressionCache;
import uk.ac.manchester.cs.jfact.kernel.ExpressionManager;
import uk.ac.manchester.cs.jfact.kernel.ExpressionTranslator;
import uk.ac.manchester.cs.jfact.kernel.Individual;
import uk.ac.manchester.cs.jfact.kernel.KBStatus;
import uk.ac.manchester.cs.jfact.kernel.Lexeme;
import uk.ac.manchester.cs.jfact.kernel.Ontology;
import uk.ac.manchester.cs.jfact.kernel.OntologyLoader;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.RoleMaster;
import uk.ac.manchester.cs.jfact.kernel.TBox;
import uk.ac.manchester.cs.jfact.kernel.Taxonomy;
import uk.ac.manchester.cs.jfact.kernel.TaxonomyVertex;
import uk.ac.manchester.cs.jfact.kernel.Token;
import uk.ac.manchester.cs.jfact.kernel.actors.Actor;
import uk.ac.manchester.cs.jfact.kernel.actors.RIActor;
import uk.ac.manchester.cs.jfact.kernel.actors.SupConceptActor;
import uk.ac.manchester.cs.jfact.kernel.actors.TaxonomyActor;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptBottom;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptName;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptTop;
import uk.ac.manchester.cs.jfact.kernel.dl.IndividualName;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleName;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.AxiomInterface;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataRoleExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.Expression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.IndividualExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.NamedEntity;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleComplexExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.RoleExpression;
import uk.ac.manchester.cs.jfact.kernel.options.JFactReasonerConfiguration;
import uk.ac.manchester.cs.jfact.split.AtomicDecomposer;
import uk.ac.manchester.cs.jfact.split.KnowledgeExplorer;
import uk.ac.manchester.cs.jfact.split.LocalityChecker;
import uk.ac.manchester.cs.jfact.split.ModuleType;
import uk.ac.manchester.cs.jfact.split.OntologyBasedModularizer;
import uk.ac.manchester.cs.jfact.split.TOntologyAtom;
import uk.ac.manchester.cs.jfact.split.TSignature;

@PortedFrom(file="Kernel.h", name="ReasoningKernel")
public class ReasoningKernel
implements Serializable {
    private static final String ROLE_EXPECTED = "Role expression expected in getNeighbours() method";
    private static final long serialVersionUID = 11000L;
    @PortedFrom(file="Kernel.h", name="KernelOptions")
    private final JFactReasonerConfiguration kernelOptions;
    @PortedFrom(file="Kernel.h", name="pTBox")
    protected TBox pTBox;
    @PortedFrom(file="Kernel.h", name="Ontology")
    private final Ontology ontology = new Ontology();
    @PortedFrom(file="Kernel.h", name="pET")
    private ExpressionTranslator pET;
    @PortedFrom(file="Kernel.h", name="Name2Sig")
    private final Map<NamedEntity, TSignature> Name2Sig = new HashMap<NamedEntity, TSignature>();
    @PortedFrom(file="Kernel.h", name="OntoSig")
    private TSignature OntoSig;
    @Original
    private AtomicBoolean interrupted;
    @PortedFrom(file="Kernel.h", name="cacheLevel")
    private CacheStatus cacheLevel;
    @PortedFrom(file="Kernel.h", name="cachedQueryTree")
    private DLTree cachedQueryTree = null;
    @PortedFrom(file="Kernel.h", name="cachedConcept")
    private Concept cachedConcept;
    @PortedFrom(file="Kernel.h", name="cachedVertex")
    private TaxonomyVertex cachedVertex;
    @PortedFrom(file="Kernel.h", name="reasoningFailed")
    private boolean reasoningFailed = false;
    @PortedFrom(file="Kernel.h", name="TraceVec")
    private final List<AxiomInterface> traceVec = new ArrayList<AxiomInterface>();
    @PortedFrom(file="Kernel.h", name="NeedTracing")
    private boolean needTracing = false;
    @Original
    private final DatatypeFactory datatypeFactory;
    @PortedFrom(file="Kernel.h", name="KE")
    private KnowledgeExplorer KE;
    @PortedFrom(file="Kernel.h", name="AD")
    private AtomicDecomposer AD;
    @PortedFrom(file="Kernel.h", name="ModSyn")
    private OntologyBasedModularizer ModSyn = null;
    @PortedFrom(file="Kernel.h", name="ModSem")
    private OntologyBasedModularizer ModSem = null;
    @PortedFrom(file="Kernel.h", name="Result")
    private final Set<AxiomInterface> Result = new HashSet<AxiomInterface>();
    @PortedFrom(file="Kernel.h", name="cachedQuery")
    private ConceptExpression cachedQuery = null;
    @PortedFrom(file="Kernel.h", name="ignoreExprCache")
    private boolean ignoreExprCache = false;
    private final Timer moduleTimer = new Timer();

    @Original
    public void setInterruptedSwitch(AtomicBoolean b) {
        this.interrupted = b;
    }

    @PortedFrom(file="Kernel.h", name="clearQueryCache")
    private void clearQueryCache() {
        this.cachedQuery = null;
        this.cachedQueryTree = null;
    }

    @PortedFrom(file="Kernel.h", name="setQueryCache")
    private void setQueryCache(ConceptExpression query) {
        this.clearQueryCache();
        this.cachedQuery = query;
    }

    @PortedFrom(file="Kernel.h", name="setQueryCache")
    private void setQueryCache(DLTree query) {
        this.clearQueryCache();
        this.cachedQueryTree = query;
    }

    @PortedFrom(file="Kernel.h", name="setIgnoreExprCache")
    public void setIgnoreExprCache(boolean value) {
        this.ignoreExprCache = value;
    }

    @PortedFrom(file="Kernel.h", name="checkQueryCache")
    private boolean checkQueryCache(ConceptExpression query) {
        return this.ignoreExprCache ? false : query.equals(this.cachedQuery);
    }

    @PortedFrom(file="Kernel.h", name="checkQueryCache")
    private boolean checkQueryCache(DLTree query) {
        return DLTree.equalTrees(this.cachedQueryTree, query);
    }

    @PortedFrom(file="Kernel.h", name="getStatus")
    private KBStatus getStatus() {
        if (this.pTBox == null) {
            return KBStatus.kbEmpty;
        }
        if (this.ontology.isChanged()) {
            return KBStatus.kbLoading;
        }
        return this.pTBox.getStatus();
    }

    @PortedFrom(file="Kernel.h", name="e")
    public DLTree e(Expression expr) {
        return expr.accept(this.pET);
    }

    @PortedFrom(file="Kernel.h", name="getFreshFiller")
    private DLTree getFreshFiller(Role R) {
        if (R.isDataRole()) {
            LiteralEntry t = new LiteralEntry("freshliteral");
            t.setLiteral(DatatypeFactory.LITERAL.buildLiteral("freshliteral"));
            return DLTreeFactory.wrap(t);
        }
        return this.getTBox().getFreshConcept();
    }

    @PortedFrom(file="Kernel.h", name="Role")
    private RoleExpression Role(Role R) {
        if (R.isDataRole()) {
            return this.getExpressionManager().dataRole(R.getName());
        }
        return this.getExpressionManager().objectRole(R.getName());
    }

    @PortedFrom(file="Kernel.h", name="initCacheAndFlags")
    private void initCacheAndFlags() {
        this.cacheLevel = CacheStatus.csEmpty;
        this.clearQueryCache();
        this.cachedConcept = null;
        this.cachedVertex = null;
        this.needTracing = false;
    }

    @PortedFrom(file="Kernel.h", name="needTracing")
    public void needTracing() {
        this.needTracing = true;
    }

    @PortedFrom(file="Kernel.h", name="getTrace")
    public List<AxiomInterface> getTrace() {
        ArrayList<AxiomInterface> toReturn = new ArrayList<AxiomInterface>(this.traceVec);
        this.traceVec.clear();
        return toReturn;
    }

    @PortedFrom(file="Kernel.h", name="setSignature")
    public void setSignature(TSignature sig) {
        if (this.pET != null) {
            this.pET.setSignature(sig);
        }
    }

    @PortedFrom(file="Kernel.h", name="getOntology")
    public Ontology getOntology() {
        return this.ontology;
    }

    @PortedFrom(file="Kernel.h", name="getRelated")
    private List<Individual> getRelated(Individual I, Role R) {
        if (!I.hasRelatedCache(R)) {
            I.setRelatedCache(R, this.buildRelatedCache(I, R));
        }
        return I.getRelatedCache(R);
    }

    @PortedFrom(file="Kernel.h", name="checkSatTree")
    private boolean checkSatTree(DLTree C) {
        if (C.isTOP()) {
            return true;
        }
        if (C.isBOTTOM()) {
            return false;
        }
        this.setUpCache(C, CacheStatus.csSat);
        return this.getTBox().isSatisfiable(this.cachedConcept);
    }

    @PortedFrom(file="Kernel.h", name="checkSat")
    private boolean checkSat(ConceptExpression C) {
        this.setUpCache(C, CacheStatus.csSat);
        return this.getTBox().isSatisfiable(this.cachedConcept);
    }

    @PortedFrom(file="Kernel.h", name="isNameOrConst")
    private static boolean isNameOrConst(ConceptExpression C) {
        return C instanceof ConceptName || C instanceof ConceptTop || C instanceof ConceptBottom;
    }

    @PortedFrom(file="Kernel.h", name="isNameOrConst")
    private static boolean isNameOrConst(DLTree C) {
        return C.isBOTTOM() || C.isTOP() || C.isName();
    }

    @PortedFrom(file="Kernel.h", name="checkSub")
    private boolean checkSub(@Nonnull ConceptExpression C, @Nonnull ConceptExpression D) {
        if (ReasoningKernel.isNameOrConst(D) && ReasoningKernel.isNameOrConst(C)) {
            return this.checkSub(this.getTBox().getCI(this.e(C)), this.getTBox().getCI(this.e(D)));
        }
        return !this.checkSat(ExpressionManager.and(C, ExpressionManager.not(D)));
    }

    @PortedFrom(file="Kernel.h", name="getModExtractor")
    public OntologyBasedModularizer getModExtractor(boolean useSemantic) {
        if (useSemantic) {
            if (this.ModSem == null) {
                this.ModSem = new OntologyBasedModularizer(this.ontology, OntologyBasedModularizer.buildTModularizer(useSemantic, this));
            }
            return this.ModSem;
        }
        if (this.ModSyn == null) {
            this.ModSyn = new OntologyBasedModularizer(this.ontology, OntologyBasedModularizer.buildTModularizer(useSemantic, this));
        }
        return this.ModSyn;
    }

    @PortedFrom(file="Kernel.h", name="getModule")
    public List<AxiomInterface> getModule(List<Expression> signature, boolean useSemantic, ModuleType type) {
        TSignature Sig = new TSignature();
        Sig.setLocality(false);
        for (Expression q : signature) {
            if (!(q instanceof NamedEntity)) continue;
            Sig.add((NamedEntity)((Object)q));
        }
        return this.getModExtractor(useSemantic).getModule(Sig, type);
    }

    @PortedFrom(file="Kernel.h", name="getNonLocal")
    public Set<AxiomInterface> getNonLocal(List<Expression> signature, boolean useSemantic, ModuleType type) {
        TSignature Sig = new TSignature();
        Sig.setLocality(type == ModuleType.M_TOP);
        for (Expression q : signature) {
            if (!(q instanceof NamedEntity)) continue;
            Sig.add((NamedEntity)((Object)q));
        }
        LocalityChecker LC = this.getModExtractor(useSemantic).getModularizer().getLocalityChecker();
        LC.setSignatureValue(Sig);
        this.Result.clear();
        for (AxiomInterface p : this.getOntology().getAxioms()) {
            if (LC.local(p)) continue;
            this.Result.add(p);
        }
        return this.Result;
    }

    @PortedFrom(file="Kernel.h", name="checkSub")
    private boolean checkSub(Concept C, Concept D) {
        if (D.getpName() == 0) {
            if (C.getpName() == 0) {
                return C.equals(D);
            }
            return !this.getTBox().isSatisfiable(C);
        }
        if (C.getpName() == 0) {
            return !this.checkSatTree(DLTreeFactory.createSNFNot(this.getTBox().getTree(C)));
        }
        if (D.isTop() || C.isBottom()) {
            return true;
        }
        if (this.getStatus().ordinal() < KBStatus.kbClassified.ordinal()) {
            return this.getTBox().isSubHolds(C, D);
        }
        SupConceptActor actor = new SupConceptActor(D);
        Taxonomy tax = this.getCTaxonomy();
        return tax.getRelativesInfo(C.getTaxVertex(), actor, true, false, true);
    }

    @PortedFrom(file="Kernel.h", name="checkTBox")
    private void checkTBox() {
        if (this.pTBox == null) {
            throw new ReasonerInternalException("KB Not Initialised");
        }
    }

    @PortedFrom(file="Kernel.h", name="getTBox")
    public TBox getTBox() {
        this.checkTBox();
        return this.pTBox;
    }

    @PortedFrom(file="Kernel.h", name="clearTBox")
    private void clearTBox() {
        this.pTBox = null;
        this.pET = null;
        this.getExpressionManager().clearNameCache();
    }

    @PortedFrom(file="Kernel.h", name="getORM")
    private RoleMaster getORM() {
        return this.getTBox().getORM();
    }

    @PortedFrom(file="Kernel.h", name="getDRM")
    private RoleMaster getDRM() {
        return this.getTBox().getDRM();
    }

    @PortedFrom(file="Kernel.h", name="getCTaxonomy")
    private Taxonomy getCTaxonomy() {
        return this.getTBox().getTaxonomy();
    }

    @PortedFrom(file="Kernel.h", name="getORTaxonomy")
    private Taxonomy getORTaxonomy() {
        if (!this.isKBPreprocessed()) {
            throw new ReasonerInternalException("No access to the object role taxonomy: ontology not preprocessed");
        }
        return this.getORM().getTaxonomy();
    }

    @PortedFrom(file="Kernel.h", name="getDRTaxonomy")
    private Taxonomy getDRTaxonomy() {
        if (!this.isKBPreprocessed()) {
            throw new ReasonerInternalException("No access to the data role taxonomy: ontology not preprocessed");
        }
        return this.getDRM().getTaxonomy();
    }

    @PortedFrom(file="Kernel.h", name="getIndividual")
    private Individual getIndividual(IndividualExpression i, String reason) {
        DLTree I = this.e(i);
        if (I == null) {
            throw new ReasonerInternalException(reason);
        }
        return (Individual)this.getTBox().getCI(I);
    }

    @PortedFrom(file="Kernel.h", name="getRole")
    private Role getRole(RoleExpression r, String reason) {
        return Role.resolveRole(this.e(r), reason);
    }

    @PortedFrom(file="Kernel.h", name="getTaxonomy")
    private Taxonomy getTaxonomy(Role R) {
        return R.isDataRole() ? this.getDRTaxonomy() : this.getORTaxonomy();
    }

    @PortedFrom(file="Kernel.h", name="getTaxVertex")
    private static TaxonomyVertex getTaxVertex(Role R) {
        return R.getTaxVertex();
    }

    @PortedFrom(file="Kernel.h", name="getOptions")
    public JFactReasonerConfiguration getOptions() {
        return this.kernelOptions;
    }

    @PortedFrom(file="Kernel.h", name="isKBPreprocessed")
    public boolean isKBPreprocessed() {
        return this.getStatus().ordinal() >= KBStatus.kbCChecked.ordinal();
    }

    @PortedFrom(file="Kernel.h", name="isKBClassified")
    public boolean isKBClassified() {
        return this.getStatus().ordinal() >= KBStatus.kbClassified.ordinal();
    }

    @PortedFrom(file="Kernel.h", name="isKBRealised")
    public boolean isKBRealised() {
        return this.getStatus().ordinal() >= KBStatus.kbRealised.ordinal();
    }

    @PortedFrom(file="Kernel.h", name="writeReasoningResult")
    public void writeReasoningResult(long time) {
        this.getTBox().clearQueryConcept();
        this.getTBox().writeReasoningResult(time);
    }

    @PortedFrom(file="Kernel.h", name="checkFunctionality")
    private boolean checkFunctionality(Role R) {
        DLTree tmp = DLTreeFactory.createSNFExists(DLTreeFactory.createRole(R).copy(), DLTreeFactory.createSNFNot(this.getFreshFiller(R)));
        return !this.checkSatTree(tmp = DLTreeFactory.createSNFAnd(tmp, DLTreeFactory.createSNFExists(DLTreeFactory.createRole(R), this.getFreshFiller(R))));
    }

    @PortedFrom(file="Kernel.h", name="getFunctionality")
    private boolean getFunctionality(Role R) {
        if (!R.isFunctionalityKnown()) {
            R.setFunctional(this.checkFunctionality(R));
        }
        return R.isFunctional();
    }

    @PortedFrom(file="Kernel.h", name="checkTransitivity")
    private boolean checkTransitivity(DLTree R) {
        DLTree tmp = DLTreeFactory.createSNFExists(R.copy(), DLTreeFactory.createSNFNot(this.getTBox().getFreshConcept()));
        tmp = DLTreeFactory.createSNFExists(R.copy(), tmp);
        return !this.checkSatTree(tmp = DLTreeFactory.createSNFAnd(tmp, DLTreeFactory.createSNFForall(R, this.getTBox().getFreshConcept())));
    }

    @PortedFrom(file="Kernel.h", name="checkSymmetry")
    private boolean checkSymmetry(DLTree R) {
        DLTree tmp = DLTreeFactory.createSNFForall(R.copy(), DLTreeFactory.createSNFNot(this.getTBox().getFreshConcept()));
        tmp = DLTreeFactory.createSNFAnd(this.getTBox().getFreshConcept(), DLTreeFactory.createSNFExists(R, tmp));
        return !this.checkSatTree(tmp);
    }

    @PortedFrom(file="Kernel.h", name="checkReflexivity")
    private boolean checkReflexivity(DLTree R) {
        DLTree tmp = DLTreeFactory.createSNFForall(R, DLTreeFactory.createSNFNot(this.getTBox().getFreshConcept()));
        tmp = DLTreeFactory.createSNFAnd(this.getTBox().getFreshConcept(), tmp);
        return !this.checkSatTree(tmp);
    }

    @PortedFrom(file="Kernel.h", name="checkRoleSubsumption")
    @Nonnull
    private Boolean checkRoleSubsumption(Role R, Role S) {
        if (R.isDataRole() != S.isDataRole()) {
            return false;
        }
        DLTree tmp = DLTreeFactory.createSNFForall(DLTreeFactory.createRole(S), DLTreeFactory.createSNFNot(this.getFreshFiller(S)));
        tmp = DLTreeFactory.createSNFAnd(DLTreeFactory.createSNFExists(DLTreeFactory.createRole(R), this.getFreshFiller(R)), tmp);
        return !this.checkSatTree(tmp);
    }

    @PortedFrom(file="Kernel.h", name="getExpressionManager")
    public ExpressionCache getExpressionManager() {
        return this.ontology.getExpressionManager();
    }

    @PortedFrom(file="Kernel.h", name="newKB")
    private boolean newKB() {
        if (this.pTBox != null) {
            return true;
        }
        this.pTBox = new TBox(this.datatypeFactory, this.getOptions(), this.interrupted);
        this.pET = new ExpressionTranslator(this.pTBox);
        this.initCacheAndFlags();
        return false;
    }

    @PortedFrom(file="Kernel.h", name="releaseKB")
    private boolean releaseKB() {
        this.clearTBox();
        this.ontology.clear();
        this.reasoningFailed = false;
        return false;
    }

    @PortedFrom(file="Kernel.h", name="clearKB")
    public boolean clearKB() {
        if (this.pTBox == null) {
            return true;
        }
        return this.releaseKB() || this.newKB();
    }

    @PortedFrom(file="Kernel.h", name="isKBConsistent")
    public boolean isKBConsistent() {
        if (this.getStatus().ordinal() <= KBStatus.kbLoading.ordinal()) {
            this.processKB(KBStatus.kbCChecked);
        }
        return this.getTBox().isConsistent();
    }

    @PortedFrom(file="Kernel.h", name="preprocessKB")
    private void preprocessKB() {
        this.isKBConsistent();
    }

    @PortedFrom(file="Kernel.h", name="classifyKB")
    public void classifyKB() {
        if (!this.isKBClassified()) {
            this.processKB(KBStatus.kbClassified);
        }
        this.isKBConsistent();
    }

    @PortedFrom(file="Kernel.h", name="realiseKB")
    public void realiseKB() {
        if (!this.isKBRealised()) {
            this.processKB(KBStatus.kbRealised);
        }
        if (!this.isKBConsistent()) {
            throw new InconsistentOntologyException();
        }
    }

    @PortedFrom(file="Kernel.h", name="isFunctional")
    public boolean isFunctional(ObjectRoleExpression R) {
        this.preprocessKB();
        Role r = this.getRole(R, "Role expression expected in isFunctional()");
        if (r.isTop()) {
            return false;
        }
        if (r.isBottom()) {
            return true;
        }
        return this.getFunctionality(r);
    }

    @PortedFrom(file="Kernel.h", name="isFunctional")
    public boolean isFunctional(DataRoleExpression R) {
        this.preprocessKB();
        Role r = this.getRole(R, "Role expression expected in isFunctional()");
        if (r.isTop()) {
            return false;
        }
        if (r.isBottom()) {
            return true;
        }
        return this.getFunctionality(r);
    }

    @PortedFrom(file="Kernel.h", name="isInverseFunctional")
    public boolean isInverseFunctional(ObjectRoleExpression R) {
        this.preprocessKB();
        Role r = this.getRole(R, "Role expression expected in isInverseFunctional()").inverse();
        if (r.isTop()) {
            return false;
        }
        if (r.isBottom()) {
            return true;
        }
        return this.getFunctionality(r);
    }

    @PortedFrom(file="Kernel.h", name="isTransitive")
    public boolean isTransitive(ObjectRoleExpression R) {
        this.preprocessKB();
        Role r = this.getRole(R, "Role expression expected in isTransitive()");
        if (r.isTop()) {
            return true;
        }
        if (r.isBottom()) {
            return true;
        }
        if (!r.isTransitivityKnown()) {
            r.setTransitive(this.checkTransitivity(this.e(R)));
        }
        return r.isTransitive();
    }

    @PortedFrom(file="Kernel.h", name="isSymmetric")
    public boolean isSymmetric(ObjectRoleExpression R) {
        this.preprocessKB();
        Role r = this.getRole(R, "Role expression expected in isSymmetric()");
        if (r.isTop()) {
            return true;
        }
        if (r.isBottom()) {
            return true;
        }
        if (!r.isSymmetryKnown()) {
            r.setSymmetric(this.checkSymmetry(this.e(R)));
        }
        return r.isSymmetric();
    }

    @PortedFrom(file="Kernel.h", name="isAsymmetric")
    public boolean isAsymmetric(ObjectRoleExpression R) {
        this.preprocessKB();
        Role r = this.getRole(R, "Role expression expected in isAsymmetric()");
        if (r.isTop()) {
            return false;
        }
        if (r.isBottom()) {
            return true;
        }
        if (!r.isAsymmetryKnown()) {
            r.setAsymmetric(this.getTBox().isDisjointRoles(r, r.inverse()));
        }
        return r.isAsymmetric();
    }

    @PortedFrom(file="Kernel.h", name="isReflexive")
    public boolean isReflexive(ObjectRoleExpression R) {
        this.preprocessKB();
        Role r = this.getRole(R, "Role expression expected in isReflexive()");
        if (r.isTop()) {
            return true;
        }
        if (r.isBottom()) {
            return false;
        }
        if (!r.isReflexivityKnown()) {
            r.setReflexive(this.checkReflexivity(this.e(R)));
        }
        return r.isReflexive();
    }

    @PortedFrom(file="Kernel.h", name="isIrreflexive")
    public boolean isIrreflexive(ObjectRoleExpression R) {
        this.preprocessKB();
        Role r = this.getRole(R, "Role expression expected in isIrreflexive()");
        if (r.isTop()) {
            return false;
        }
        if (r.isBottom()) {
            return true;
        }
        if (!r.isIrreflexivityKnown()) {
            r.setIrreflexive(this.getTBox().isIrreflexive(r));
        }
        return r.isIrreflexive();
    }

    /*
     * WARNING - void declaration
     */
    @PortedFrom(file="Kernel.h", name="isDisjointRoles")
    public boolean isDisjointRoles(List<? extends RoleExpression> l) {
        int nTopRoles = 0;
        ArrayList<Role> Roles = new ArrayList<Role>(l.size());
        for (RoleExpression roleExpression : l) {
            Role role = this.getRole(roleExpression, "Role expression expected in isDisjointRoles()");
            if (role.isBottom()) continue;
            if (role.isTop()) {
                ++nTopRoles;
                continue;
            }
            Roles.add(role);
        }
        if (nTopRoles > 0) {
            return nTopRoles <= 1 && Roles.isEmpty();
        }
        for (int i = 0; i < Roles.size() - 1; ++i) {
            void var5_8;
            int n = i + 1;
            while (var5_8 < Roles.size()) {
                if (!this.getTBox().isDisjointRoles((Role)Roles.get(i), (Role)Roles.get((int)var5_8))) {
                    return false;
                }
                ++var5_8;
            }
        }
        return true;
    }

    @PortedFrom(file="Kernel.h", name="isDisjointRoles")
    public boolean isDisjointRoles(ObjectRoleExpression R, ObjectRoleExpression S) {
        this.preprocessKB();
        Role r = this.getRole(R, "Role expression expected in isDisjointRoles()");
        Role s = this.getRole(S, "Role expression expected in isDisjointRoles()");
        if (r.isTop() || s.isTop()) {
            return false;
        }
        if (r.isBottom() || s.isBottom()) {
            return true;
        }
        return this.getTBox().isDisjointRoles(r, s);
    }

    @PortedFrom(file="Kernel.h", name="isDisjointRoles")
    public boolean isDisjointRoles(DataRoleExpression R, DataRoleExpression S) {
        this.preprocessKB();
        Role r = this.getRole(R, "Role expression expected in isDisjointRoles()");
        Role s = this.getRole(S, "Role expression expected in isDisjointRoles()");
        if (r.isTop() || s.isTop()) {
            return false;
        }
        if (r.isBottom() || s.isBottom()) {
            return true;
        }
        return this.getTBox().isDisjointRoles(r, s);
    }

    @PortedFrom(file="Kernel.h", name="isSubRoles")
    public boolean isSubRoles(RoleExpression R, RoleExpression S) {
        this.preprocessKB();
        Role r = this.getRole(R, "Role expression expected in isSubRoles()");
        Role s = this.getRole(S, "Role expression expected in isSubRoles()");
        if (r.isBottom() || s.isTop()) {
            return true;
        }
        if (r.isTop() && s.isBottom()) {
            return false;
        }
        if (ExpressionManager.isEmptyRole(R) || ExpressionManager.isUniversalRole(S)) {
            return true;
        }
        if (ExpressionManager.isUniversalRole(R) && ExpressionManager.isEmptyRole(S)) {
            return false;
        }
        if (!r.isTop() && !s.isBottom() && r.lesserequal(s)) {
            return true;
        }
        return this.checkRoleSubsumption(r, s);
    }

    @PortedFrom(file="Kernel.h", name="isSatisfiable")
    public boolean isSatisfiable(ConceptExpression C) {
        this.preprocessKB();
        try {
            return this.checkSat(C);
        }
        catch (OWLRuntimeException crn) {
            if (C instanceof ConceptName) {
                return true;
            }
            throw crn;
        }
    }

    @PortedFrom(file="Kernel.h", name="isSubsumedBy")
    public boolean isSubsumedBy(ConceptExpression C, ConceptExpression D) {
        this.preprocessKB();
        if (ReasoningKernel.isNameOrConst(D) && ReasoningKernel.isNameOrConst(C)) {
            return this.checkSub(this.getTBox().getCI(this.e(C)), this.getTBox().getCI(this.e(D)));
        }
        DLTree nD = DLTreeFactory.createSNFNot(this.e(D));
        return !this.checkSatTree(DLTreeFactory.createSNFAnd(this.e(C), nD));
    }

    @PortedFrom(file="Kernel.h", name="isDisjoint")
    public boolean isDisjoint(ConceptExpression C, ConceptExpression D) {
        return !this.isSatisfiable(ExpressionManager.and(C, D));
    }

    @PortedFrom(file="Kernel.h", name="isEquivalent")
    public boolean isEquivalent(ConceptExpression C, ConceptExpression D) {
        if (C.equals(D)) {
            return true;
        }
        this.preprocessKB();
        if (this.isKBClassified() && ReasoningKernel.isNameOrConst(D) && ReasoningKernel.isNameOrConst(C)) {
            TaxonomyVertex cV = this.getTBox().getCI(this.e(C)).getTaxVertex();
            TaxonomyVertex dV = this.getTBox().getCI(this.e(D)).getTaxVertex();
            if (cV == null && dV == null) {
                return false;
            }
            if (cV == null || dV == null) {
                return false;
            }
            return cV.equals(dV);
        }
        return this.isSubsumedBy(C, D) && this.isSubsumedBy(D, C);
    }

    @PortedFrom(file="Kernel.h", name="getSupConcepts")
    public <T extends Expression> TaxonomyActor<T> getConcepts(ConceptExpression C, boolean direct, TaxonomyActor<T> actor, boolean supDirection) {
        this.classifyKB();
        this.setUpCache(C, CacheStatus.csClassified);
        actor.clear();
        this.getCTaxonomy().getRelativesInfo(this.cachedVertex, actor, false, direct, supDirection);
        return actor;
    }

    @PortedFrom(file="Kernel.h", name="getSubConcepts")
    public Actor getConcepts(ConceptExpression C, boolean direct, Actor actor, boolean supDirection) {
        this.classifyKB();
        this.setUpCache(C, CacheStatus.csClassified);
        actor.clear();
        Taxonomy tax = this.getCTaxonomy();
        tax.getRelativesInfo(this.cachedVertex, actor, false, direct, supDirection);
        return actor;
    }

    @PortedFrom(file="Kernel.h", name="getEquivalentConcepts")
    public <T extends Expression> TaxonomyActor<T> getEquivalentConcepts(ConceptExpression C, TaxonomyActor<T> actor) {
        this.classifyKB();
        this.setUpCache(C, CacheStatus.csClassified);
        actor.clear();
        actor.apply(this.cachedVertex);
        return actor;
    }

    @PortedFrom(file="Kernel.h", name="getDisjointConcepts")
    public <T extends Expression> TaxonomyActor<T> getDisjointConcepts(ConceptExpression C, TaxonomyActor<T> actor) {
        this.classifyKB();
        this.setUpCache(ExpressionManager.not(C), CacheStatus.csClassified);
        actor.clear();
        this.getCTaxonomy().getRelativesInfo(this.cachedVertex, actor, true, false, false);
        return actor;
    }

    @PortedFrom(file="Kernel.h", name="getSupRoles")
    public <T extends RoleExpression> TaxonomyActor<T> getRoles(RoleExpression r, boolean direct, TaxonomyActor<T> actor, boolean supDirection) {
        this.preprocessKB();
        Role R = this.getRole(r, "Role expression expected in getRoles()");
        actor.clear();
        this.getTaxonomy(R).getRelativesInfo(ReasoningKernel.getTaxVertex(R), actor, false, direct, supDirection);
        return actor;
    }

    @PortedFrom(file="Kernel.h", name="getEquivalentRoles")
    public <T extends RoleExpression> TaxonomyActor<T> getEquivalentRoles(RoleExpression r, TaxonomyActor<T> actor) {
        this.preprocessKB();
        Role R = this.getRole(r, "Role expression expected in getEquivalentRoles()");
        actor.clear();
        actor.apply(ReasoningKernel.getTaxVertex(R));
        return actor;
    }

    @PortedFrom(file="Kernel.h", name="getORoleDomain")
    public <T extends ConceptExpression> TaxonomyActor<T> getORoleDomain(ObjectRoleExpression r, boolean direct, TaxonomyActor<T> actor) {
        this.classifyKB();
        this.setUpCache(ExpressionManager.exists(r, ExpressionManager.top()), CacheStatus.csClassified);
        actor.clear();
        this.getCTaxonomy().getRelativesInfo(this.cachedVertex, actor, true, direct, true);
        return actor;
    }

    @PortedFrom(file="Kernel.h", name="getDRoleDomain")
    public <T extends ConceptExpression> TaxonomyActor<T> getDRoleDomain(DataRoleExpression r, boolean direct, TaxonomyActor<T> actor) {
        this.classifyKB();
        this.setUpCache(ExpressionManager.exists(r, ExpressionManager.dataTop()), CacheStatus.csClassified);
        actor.clear();
        this.getCTaxonomy().getRelativesInfo(this.cachedVertex, actor, true, direct, true);
        return actor;
    }

    @PortedFrom(file="Kernel.h", name="getRoleRange")
    private <T extends ConceptExpression> void getRoleRange(ObjectRoleExpression r, boolean direct, TaxonomyActor<T> actor) {
        this.getORoleDomain(this.getExpressionManager().inverse(r), direct, actor);
    }

    @PortedFrom(file="Kernel.h", name="getInstances")
    public TaxonomyActor<IndividualExpression> getInstances(ConceptExpression C, TaxonomyActor<IndividualExpression> actor, boolean direct) {
        if (direct) {
            this.getDirectInstances(C, actor);
        } else {
            this.getInstances(C, actor);
        }
        return actor;
    }

    @PortedFrom(file="Kernel.h", name="getDirectInstances")
    public void getDirectInstances(ConceptExpression C, Actor actor) {
        this.realiseKB();
        this.setUpCache(C, CacheStatus.csClassified);
        actor.clear();
        if (actor.apply(this.cachedVertex)) {
            return;
        }
        for (TaxonomyVertex p : this.cachedVertex.neigh(false)) {
            actor.apply(p);
        }
    }

    @PortedFrom(file="Kernel.h", name="getInstances")
    public void getInstances(ConceptExpression C, Actor actor) {
        this.realiseKB();
        this.setUpCache(C, CacheStatus.csClassified);
        actor.clear();
        this.getCTaxonomy().getRelativesInfo(this.cachedVertex, actor, true, false, false);
    }

    @PortedFrom(file="Kernel.h", name="getTypes")
    public <T extends Expression> TaxonomyActor<T> getTypes(IndividualName I, boolean direct, TaxonomyActor<T> actor) {
        this.realiseKB();
        this.setUpCache(this.getExpressionManager().oneOf(I), CacheStatus.csClassified);
        actor.clear();
        this.getCTaxonomy().getRelativesInfo(this.cachedVertex, actor, true, direct, true);
        return actor;
    }

    @PortedFrom(file="Kernel.h", name="getSameAs")
    public <T extends Expression> TaxonomyActor<T> getSameAs(IndividualName I, TaxonomyActor<T> actor) {
        this.realiseKB();
        return this.getEquivalentConcepts(this.getExpressionManager().oneOf(I), actor);
    }

    @PortedFrom(file="Kernel.h", name="isSameIndividuals")
    public boolean isSameIndividuals(IndividualExpression I, IndividualExpression J) {
        this.realiseKB();
        Individual i = this.getIndividual(I, "Only known individuals are allowed in the isSameAs()");
        Individual j = this.getIndividual(J, "Only known individuals are allowed in the isSameAs()");
        return this.getTBox().isSameIndividuals(i, j);
    }

    @PortedFrom(file="Kernel.h", name="buildCompletionTree")
    @Nonnull
    public DlCompletionTree buildCompletionTree(ConceptExpression C) {
        this.preprocessKB();
        this.setUpCache(C, CacheStatus.csSat);
        DlCompletionTree ret = this.getTBox().buildCompletionTree(this.cachedConcept);
        if (this.KE == null) {
            this.KE = new KnowledgeExplorer(this.getTBox(), this.getExpressionManager());
        }
        return ret;
    }

    @Original
    private KnowledgeExplorer getKnowledgeExplorer() {
        return this.KE;
    }

    @PortedFrom(file="Kernel.h", name="getDataRoles")
    public Set<DataRoleExpression> getDataRoles(DlCompletionTree node, boolean onlyDet) {
        return this.KE.getDataRoles(node, onlyDet);
    }

    @PortedFrom(file="Kernel.h", name="getObjectRoles")
    public Set<ObjectRoleExpression> getObjectRoles(DlCompletionTree node, boolean onlyDet, boolean needIncoming) {
        return this.KE.getObjectRoles(node, onlyDet, needIncoming);
    }

    @PortedFrom(file="Kernel.h", name="getNeighbours")
    public List<DlCompletionTree> getNeighbours(DlCompletionTree node, RoleExpression role) {
        return this.KE.getNeighbours(node, this.getRole(role, ROLE_EXPECTED));
    }

    @PortedFrom(file="Kernel.h", name="getLabel")
    public List<ConceptExpression> getObjectLabel(DlCompletionTree node, boolean onlyDet) {
        return this.KE.getObjectLabel(node, onlyDet);
    }

    @PortedFrom(file="Kernel.h", name="getLabel")
    public List<DataExpression> getDataLabel(DlCompletionTree node, boolean onlyDet) {
        return this.KE.getDataLabel(node, onlyDet);
    }

    @PortedFrom(file="Kernel.h", name="getBlocker")
    @Nonnull
    public DlCompletionTree getBlocker(DlCompletionTree node) {
        return this.KE.getBlocker(node);
    }

    @PortedFrom(file="Kernel.h", name="isInstance")
    public boolean isInstance(IndividualExpression I, ConceptExpression C) {
        this.realiseKB();
        this.getIndividual(I, "individual name expected in the isInstance()");
        return this.isSubsumedBy(this.getExpressionManager().oneOf(I), C);
    }

    public ReasoningKernel(JFactReasonerConfiguration conf, DatatypeFactory factory) {
        this.kernelOptions = conf;
        this.datatypeFactory = factory;
        this.pTBox = null;
        this.pET = null;
        this.cachedQuery = null;
        this.initCacheAndFlags();
    }

    @PortedFrom(file="Kernel.h", name="needForceReload")
    private boolean needForceReload() {
        if (this.pTBox == null) {
            return true;
        }
        if (!this.ontology.isChanged()) {
            return false;
        }
        return !this.kernelOptions.isUseIncrementalReasoning();
    }

    @PortedFrom(file="Incremental.cpp", name="doIncremental")
    public void doIncremental() {
        this.ModSyn = null;
        HashSet<NamedEntity> MPlus = new HashSet<NamedEntity>();
        HashSet<NamedEntity> MMinus = new HashSet<NamedEntity>();
        TSignature NewSig = this.ontology.getSignature();
        HashSet<NamedEntity> RemovedEntities = new HashSet<NamedEntity>(this.OntoSig.begin());
        RemovedEntities.removeAll(NewSig.begin());
        HashSet<NamedEntity> AddedEntities = new HashSet<NamedEntity>(NewSig.begin());
        AddedEntities.removeAll(this.OntoSig.begin());
        Taxonomy tax = this.getCTaxonomy();
        for (NamedEntity e : RemovedEntities) {
            if (!(e.getEntry() instanceof Concept)) continue;
            Concept C = (Concept)e.getEntry();
            C.getTaxVertex().remove();
            this.Name2Sig.remove(C.getEntity());
        }
        tax.deFinalise();
        for (NamedEntity e : AddedEntities) {
            if (!(e instanceof ConceptName)) continue;
            ConceptName cName = (ConceptName)e;
            this.e(cName);
            Concept concept = (Concept)cName.getEntry();
            this.setupSig(concept.getEntity(), this.ontology.getAxioms());
            TaxonomyVertex cur = tax.getCurrent();
            cur.clear();
            cur.setSample(concept, true);
            cur.addNeighbour(true, tax.getTopVertex());
            tax.finishCurrentNode();
        }
        this.OntoSig = NewSig;
        Timer t = new Timer();
        t.start();
        LocalityChecker lc = this.getModExtractor(false).getModularizer().getLocalityChecker();
        block2: for (Map.Entry entry : this.Name2Sig.entrySet()) {
            lc.setSignatureValue((TSignature)entry.getValue());
            for (AxiomInterface notProcessed : this.ontology.getAxioms()) {
                if (lc.local(notProcessed)) continue;
                MPlus.add((NamedEntity)entry.getKey());
                break;
            }
            for (AxiomInterface retracted : this.ontology.getRetracted()) {
                if (lc.local(retracted)) continue;
                MMinus.add((NamedEntity)entry.getKey());
                TaxonomyVertex v = ((ClassifiableEntry)((NamedEntity)entry.getKey()).getEntry()).getTaxVertex();
                if (!v.noNeighbours(true)) continue block2;
                v.addNeighbour(true, tax.getTopVertex());
                tax.getTopVertex().addNeighbour(false, v);
                continue block2;
            }
        }
        t.stop();
        HashSet<NamedEntity> toProcess = new HashSet<NamedEntity>(MPlus);
        toProcess.addAll(MMinus);
        while (!toProcess.isEmpty()) {
            this.buildSignature((NamedEntity)toProcess.iterator().next(), this.ontology.getAxioms(), toProcess);
        }
        tax.finalise();
        byte[] byArray = ReasoningKernel.save(this.pTBox);
        this.kernelOptions.setUseIncrementalReasoning(false);
        this.forceReload();
        this.pTBox.setNameSigMap(this.Name2Sig);
        this.pTBox.isConsistent();
        this.kernelOptions.setUseIncrementalReasoning(true);
        this.pTBox = ReasoningKernel.load(byArray);
        tax = this.getCTaxonomy();
        this.pTBox.reclassify(MPlus, MMinus);
        this.getOntology().setProcessed();
    }

    private static byte[] save(TBox tbox) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oout = new ObjectOutputStream(out);
            oout.writeObject(tbox);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return out.toByteArray();
    }

    private static TBox load(byte[] tbox) {
        try {
            return (TBox)new ObjectInputStream(new ByteArrayInputStream(tbox)).readObject();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @PortedFrom(file="Kernel.h", name="forceReload")
    private void forceReload() {
        this.clearTBox();
        this.newKB();
        for (NamedEntity e : this.ontology.getSignature().begin()) {
            e.setEntry(null);
        }
        OntologyLoader ontologyLoader = new OntologyLoader(this.getTBox());
        ontologyLoader.visitOntology(this.ontology);
        if (this.kernelOptions.isUseIncrementalReasoning()) {
            this.initIncremental();
        }
        this.ontology.setProcessed();
    }

    @PortedFrom(file="Incremental.cpp", name="setupSig")
    public void setupSig(NamedEntity entity, List<AxiomInterface> Module2) {
        this.moduleTimer.start();
        if (entity == null) {
            return;
        }
        this.moduleTimer.start();
        TSignature sig = new TSignature();
        sig.add(entity);
        this.getModExtractor(false).getModule(Module2, sig, ModuleType.M_BOT);
        this.Name2Sig.put(entity, new TSignature(this.getModExtractor(false).getModularizer().getSignature()));
        this.moduleTimer.stop();
    }

    @PortedFrom(file="Incremental.cpp", name="buildSignature")
    public void buildSignature(NamedEntity entity, List<AxiomInterface> Module2, Set<NamedEntity> toProcess) {
        toProcess.remove(entity);
        this.setupSig(entity, Module2);
        List<AxiomInterface> NewModule = this.getModExtractor(false).getModularizer().getModule();
        if (Module2.size() == NewModule.size()) {
            return;
        }
        TSignature ModSig = this.getModExtractor(false).getModularizer().getSignature();
        for (NamedEntity p : ModSig.begin()) {
            if (!toProcess.contains(p)) continue;
            this.buildSignature(p, NewModule, toProcess);
        }
    }

    @PortedFrom(file="Incremental.cpp", name="initIncremental")
    public void initIncremental() {
        this.Name2Sig.clear();
        HashSet<NamedEntity> toProcess = new HashSet<NamedEntity>();
        this.getModExtractor(false);
        for (Concept p : this.getTBox().getConcepts()) {
            toProcess.add(p.getEntity());
        }
        while (!toProcess.isEmpty()) {
            this.buildSignature((NamedEntity)toProcess.iterator().next(), this.ontology.getAxioms(), toProcess);
        }
        this.getTBox().setNameSigMap(this.Name2Sig);
        this.OntoSig = this.ontology.getSignature();
    }

    @PortedFrom(file="Kernel.h", name="processKB")
    private void processKB(KBStatus status) {
        assert (status.ordinal() >= KBStatus.kbCChecked.ordinal());
        if (this.reasoningFailed) {
            throw new ReasonerInternalException("Can't answer queries due to previous errors");
        }
        KBStatus curStatus = this.getStatus();
        if (curStatus.ordinal() >= status.ordinal()) {
            if (!this.isKBConsistent()) {
                throw new InconsistentOntologyException();
            }
            return;
        }
        if (curStatus == KBStatus.kbEmpty || curStatus == KBStatus.kbLoading) {
            this.reasoningFailed = true;
            if (!this.needForceReload()) {
                this.doIncremental();
                this.reasoningFailed = false;
                return;
            }
            this.forceReload();
            this.pTBox.isConsistent();
            this.reasoningFailed = false;
            if (status == KBStatus.kbCChecked) {
                return;
            }
        }
        if (!this.pTBox.isConsistent()) {
            return;
        }
        if (status == KBStatus.kbRealised) {
            this.pTBox.performRealisation();
        } else {
            this.pTBox.performClassification();
        }
    }

    @PortedFrom(file="Kernel.h", name="classify")
    private void classify(KBStatus status) {
        if (status != KBStatus.kbRealised) {
            if (!this.pTBox.isConsistent()) {
                return;
            }
            this.pTBox.performClassification();
            return;
        }
        this.realise();
    }

    @PortedFrom(file="Kernel.h", name="realiseKB")
    private void realise() {
        if (!this.pTBox.isConsistent()) {
            return;
        }
        this.pTBox.performRealisation();
    }

    @PortedFrom(file="Kernel.h", name="classifyQuery")
    private void classifyQuery(boolean named) {
        this.classifyKB();
        if (!named) {
            this.getTBox().classifyQueryConcept();
        }
        this.cachedVertex = this.cachedConcept.getTaxVertex();
        if (this.cachedVertex == null) {
            this.cachedVertex = this.getCTaxonomy().getFreshVertex(this.cachedConcept);
        }
    }

    @PortedFrom(file="Kernel.h", name="setUpCache")
    private void setUpCache(DLTree query, CacheStatus level) {
        assert (!this.ontology.isChanged());
        if (this.checkQueryCache(query)) {
            if (level.ordinal() <= this.cacheLevel.ordinal()) {
                return;
            }
            assert (level == CacheStatus.csClassified && this.cacheLevel != CacheStatus.csClassified);
            if (this.cacheLevel == CacheStatus.csSat) {
                this.classifyQuery(this.cachedQueryTree.isCN());
                return;
            }
        } else {
            this.setQueryCache(query);
        }
        this.cachedVertex = null;
        this.cacheLevel = level;
        this.cachedConcept = this.cachedQueryTree.isCN() ? this.getTBox().getCI(this.cachedQueryTree) : this.getTBox().createQueryConcept(this.cachedQueryTree);
        assert (this.cachedConcept != null);
        if (this.cachedConcept.getpName() == 0) {
            this.getTBox().preprocessQueryConcept(this.cachedConcept);
        }
        if (level == CacheStatus.csClassified) {
            this.classifyQuery(this.cachedQueryTree.isCN());
        }
    }

    @PortedFrom(file="Kernel.h", name="setUpCache")
    private void setUpCache(ConceptExpression query, CacheStatus level) {
        assert (!this.ontology.isChanged());
        if (this.checkQueryCache(query)) {
            if (level.ordinal() <= this.cacheLevel.ordinal()) {
                return;
            }
            assert (level == CacheStatus.csClassified && this.cacheLevel != CacheStatus.csClassified);
            if (this.cacheLevel == CacheStatus.csSat) {
                this.classifyQuery(ReasoningKernel.isNameOrConst(this.cachedQuery));
                return;
            }
        } else {
            this.setQueryCache(query);
        }
        this.cachedVertex = null;
        this.cacheLevel = level;
        this.cachedConcept = ReasoningKernel.isNameOrConst(this.cachedQuery) ? this.getTBox().getCI(this.e(this.cachedQuery)) : this.getTBox().createQueryConcept(this.e(this.cachedQuery));
        assert (this.cachedConcept != null);
        if (this.cachedConcept.getpName() == 0) {
            this.getTBox().preprocessQueryConcept(this.cachedConcept);
        }
        if (level == CacheStatus.csClassified) {
            this.classifyQuery(ReasoningKernel.isNameOrConst(this.cachedQuery));
        }
    }

    @PortedFrom(file="Kernel.cpp", name="isEq")
    protected boolean isEq(DlCompletionTree p, DlCompletionTree q) {
        return false;
    }

    @PortedFrom(file="Kernel.cpp", name="isLt")
    protected boolean isLt(DlCompletionTree p, DlCompletionTree q) {
        return false;
    }

    @PortedFrom(file="Kernel.cpp", name="checkDataRelation")
    private boolean checkDataRelation(DlCompletionTree vR, DlCompletionTree vS, int op) {
        switch (op) {
            case 0: {
                return this.isEq(vR, vS);
            }
            case 1: {
                return !this.isEq(vR, vS);
            }
            case 2: {
                return this.isLt(vR, vS);
            }
            case 3: {
                return this.isLt(vR, vS) || this.isEq(vR, vS);
            }
            case 4: {
                return this.isLt(vS, vR);
            }
            case 5: {
                return this.isLt(vS, vR) || this.isEq(vR, vS);
            }
        }
        throw new ReasonerInternalException("Illegal operation in checkIndividualValues()");
    }

    @PortedFrom(file="Kernel.cpp", name="getDataRelatedIndividuals")
    public Collection<IndividualName> getDataRelatedIndividuals(RoleExpression R, RoleExpression S, int op, Collection<IndividualExpression> individuals) {
        this.realiseKB();
        ArrayList<IndividualName> toReturn = new ArrayList<IndividualName>();
        Role r = this.getRole(R, "Role expression expected in the getIndividualsWith()");
        Role s = this.getRole(S, "Role expression expected in the getIndividualsWith()");
        block0: for (IndividualExpression q : individuals) {
            Individual ind = this.getIndividual(q, "individual name expected in getDataRelatedIndividuals()");
            DlCompletionTree vR = null;
            DlCompletionTree vS = null;
            for (DlCompletionTreeArc edge : ind.getNode().getNeighbour()) {
                if (edge.isNeighbour(r)) {
                    vR = edge.getArcEnd();
                } else if (edge.isNeighbour(s)) {
                    vS = edge.getArcEnd();
                }
                if (vR == null || vS == null || !this.checkDataRelation(vR, vS, op)) continue;
                if (!(q instanceof IndividualName)) continue block0;
                toReturn.add((IndividualName)q);
                continue block0;
            }
        }
        return toReturn;
    }

    @PortedFrom(file="Kernel.h", name="getAtomicDecompositionSize")
    public int getAtomicDecompositionSize(boolean useSemantics, ModuleType type) {
        if (this.AD == null) {
            this.AD = new AtomicDecomposer(this.getModExtractor(useSemantics).getModularizer());
        }
        return this.AD.getAOS(this.ontology, type).size();
    }

    @PortedFrom(file="Kernel.h", name="getAtomAxioms")
    public Set<AxiomInterface> getAtomAxioms(int index) {
        return this.AD.getAOS().get(index).getAtomAxioms();
    }

    @Original
    public List<AxiomInterface> getTautologies() {
        return this.AD.getTautologies();
    }

    @PortedFrom(file="Kernel.h", name="getAtomModule")
    public Set<AxiomInterface> getAtomModule(int index) {
        return this.AD.getAOS().get(index).getModule();
    }

    @PortedFrom(file="Kernel.h", name="getAtomDependents")
    public Set<TOntologyAtom> getAtomDependents(int index) {
        return this.AD.getAOS().get(index).getDepAtoms();
    }

    @PortedFrom(file="Kernel.cpp", name="getLocCheckNumber")
    public long getLocCheckNumber() {
        return this.AD.getLocChekNumber();
    }

    @PortedFrom(file="Kernel.h", name="checkSubChain")
    private boolean checkSubChain(Role R, List<ObjectRoleExpression> l) {
        DLTree tmp = DLTreeFactory.createSNFNot(this.getTBox().getFreshConcept());
        for (int i = l.size() - 1; i > -1; --i) {
            ObjectRoleExpression p = l.get(i);
            Role S = this.getRole(p, "Role expression expected in chain of isSubChain()");
            if (S.isBottom()) {
                return true;
            }
            tmp = DLTreeFactory.createSNFExists(DLTreeFactory.createRole(S), tmp);
        }
        return !this.checkSatTree(tmp = DLTreeFactory.createSNFAnd(tmp, DLTreeFactory.createSNFForall(DLTreeFactory.buildTree(new Lexeme(Token.RNAME, R)), this.getTBox().getFreshConcept())));
    }

    @PortedFrom(file="Kernel.h", name="isSubChain")
    public boolean isSubChain(ObjectRoleComplexExpression R, List<ObjectRoleExpression> l) {
        this.preprocessKB();
        Role r = this.getRole(R, "Role expression expected in isSubChain()");
        if (r.isTop()) {
            return true;
        }
        return this.checkSubChain(r, l);
    }

    @PortedFrom(file="Kernel.h", name="buildRelatedCache")
    private List<Individual> buildRelatedCache(Individual I, Role R) {
        if (R.isSynonym()) {
            return this.getRelated(I, ClassifiableEntry.resolveSynonym(R));
        }
        if (R.isDataRole() || R.isBottom()) {
            return new ArrayList<Individual>();
        }
        RIActor actor = new RIActor();
        ObjectRoleName InvR = R.getId() > 0 ? this.getExpressionManager().inverse(this.getExpressionManager().objectRole(R.getName())) : this.getExpressionManager().objectRole(R.inverse().getName());
        ConceptExpression query = R.isTop() ? ExpressionManager.top() : ExpressionManager.value(InvR, this.getExpressionManager().individual(I.getName()));
        this.getInstances(query, actor);
        return actor.getAcc();
    }

    @PortedFrom(file="Kernel.h", name="getRoleFillers")
    public List<Individual> getRoleFillers(IndividualExpression I, ObjectRoleExpression R) {
        this.realiseKB();
        return this.getRelated(this.getIndividual(I, "Individual name expected in the getRoleFillers()"), this.getRole(R, "Role expression expected in the getRoleFillers()"));
    }

    @PortedFrom(file="Kernel.h", name="isRelated")
    private boolean isRelated(IndividualExpression I, ObjectRoleExpression R, IndividualExpression J) {
        this.realiseKB();
        Individual i = this.getIndividual(I, "Individual name expected in the isRelated()");
        Role r = this.getRole(R, "Role expression expected in the isRelated()");
        if (r.isDataRole()) {
            return false;
        }
        Individual j = this.getIndividual(J, "Individual name expected in the isRelated()");
        List<Individual> vec = this.getRelated(i, r);
        for (Individual p : vec) {
            if (!j.equals(p)) continue;
            return true;
        }
        return false;
    }
}

