/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import uk.ac.manchester.cs.jfact.helpers.DLVertex;
import uk.ac.manchester.cs.jfact.helpers.Helper;
import uk.ac.manchester.cs.jfact.helpers.UnreachableSituationException;
import uk.ac.manchester.cs.jfact.kernel.DLDag;
import uk.ac.manchester.cs.jfact.kernel.ExpressionCache;
import uk.ac.manchester.cs.jfact.kernel.ExpressionManager;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.Expression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.RoleExpression;

@PortedFrom(file="tDag2Interface.h", name="TDag2Interface")
public class TDag2Interface
implements Serializable {
    private static final long serialVersionUID = 11000L;
    @PortedFrom(file="tDag2Interface.h", name="Dag")
    private final DLDag Dag;
    @PortedFrom(file="tDag2Interface.h", name="Manager")
    private final ExpressionCache cache;
    @PortedFrom(file="tDag2Interface.h", name="TransC")
    private final List<ConceptExpression> TransConcept = new ArrayList<ConceptExpression>();
    @PortedFrom(file="tDag2Interface.h", name="TransD")
    private final List<DataExpression> TransData = new ArrayList<DataExpression>();

    @PortedFrom(file="tDag2Interface.h", name="buildCExpr")
    public ConceptExpression buildCExpr(DLVertex v) {
        switch (v.getType()) {
            case dtTop: {
                return ExpressionManager.top();
            }
            case dtNConcept: 
            case dtPConcept: {
                return this.cache.concept(v.getConcept().getName());
            }
            case dtPSingleton: 
            case dtNSingleton: {
                return this.cache.oneOf(this.cache.individual(v.getConcept().getName()));
            }
            case dtAnd: 
            case dtCollection: {
                ArrayList<ConceptExpression> list = new ArrayList<ConceptExpression>();
                for (int p : v.begin()) {
                    list.add(this.getCExpr(p));
                }
                return ExpressionManager.and(list);
            }
            case dtForall: {
                if (v.getRole().isDataRole()) {
                    return ExpressionManager.forall(this.cache.dataRole(v.getRole().getName()), this.getDExpr(v.getConceptIndex()));
                }
                return ExpressionManager.forall(this.cache.objectRole(v.getRole().getName()), this.getCExpr(v.getConceptIndex()));
            }
            case dtLE: {
                if (v.getRole().isDataRole()) {
                    return ExpressionManager.maxCardinality(v.getNumberLE(), this.cache.dataRole(v.getRole().getName()), this.getDExpr(v.getConceptIndex()));
                }
                return ExpressionManager.maxCardinality(v.getNumberLE(), this.cache.objectRole(v.getRole().getName()), this.getCExpr(v.getConceptIndex()));
            }
            case dtIrr: {
                return ExpressionManager.not(ExpressionManager.selfReference(this.cache.objectRole(v.getRole().getName())));
            }
            case dtProj: 
            case dtNN: 
            case dtChoose: {
                return ExpressionManager.top();
            }
        }
        throw new UnreachableSituationException();
    }

    @PortedFrom(file="tDag2Interface.h", name="buildDExpr")
    public DataExpression buildDExpr(DLVertex v) {
        switch (v.getType()) {
            case dtTop: {
                return ExpressionManager.dataTop();
            }
            case dtDataType: 
            case dtDataValue: 
            case dtDataExpr: {
                return ExpressionManager.dataTop();
            }
            case dtAnd: 
            case dtCollection: {
                ArrayList<DataExpression> list = new ArrayList<DataExpression>();
                for (int p : v.begin()) {
                    list.add(this.getDExpr(p));
                }
                return ExpressionManager.dataAnd(list);
            }
        }
        throw new UnreachableSituationException();
    }

    public TDag2Interface(DLDag dag, ExpressionCache manager) {
        this.Dag = dag;
        this.cache = manager;
        Helper.resize(this.TransConcept, dag.size());
        Helper.resize(this.TransData, dag.size());
    }

    @Original
    public RoleExpression getDataRoleExpression(Role r) {
        return this.cache.dataRole(r.getName());
    }

    @Original
    public RoleExpression getObjectRoleExpression(Role r) {
        return this.cache.objectRole(r.getName());
    }

    @PortedFrom(file="tDag2Interface.h", name="ensureDagSize")
    public void ensureDagSize() {
        int ts;
        int ds = this.Dag.size();
        if (ds == (ts = this.TransConcept.size())) {
            return;
        }
        Helper.resize(this.TransConcept, ds);
        Helper.resize(this.TransData, ds);
    }

    @PortedFrom(file="tDag2Interface.h", name="getCExpr")
    public ConceptExpression getCExpr(int p) {
        if (p < 0) {
            return ExpressionManager.not(this.getCExpr(-p));
        }
        if (this.TransConcept.get(p) == null) {
            this.TransConcept.set(p, this.buildCExpr(this.Dag.get(p)));
        }
        return this.TransConcept.get(p);
    }

    @PortedFrom(file="tDag2Interface.h", name="getDExpr")
    public DataExpression getDExpr(int p) {
        if (p < 0) {
            return ExpressionManager.dataNot(this.getDExpr(-p));
        }
        DataExpression expression = this.TransData.get(p);
        if (expression == null) {
            expression = this.buildDExpr(this.Dag.get(p));
            this.TransData.set(p, expression);
        }
        return expression;
    }

    @PortedFrom(file="tDag2Interface.h", name="getExpr")
    public Expression getExpr(int p, boolean data) {
        if (data) {
            return this.getDExpr(p);
        }
        return this.getCExpr(p);
    }
}

