/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.jfact.helpers.LogAdapter;
import uk.ac.manchester.cs.jfact.helpers.Templates;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.options.JFactReasonerConfiguration;

@PortedFrom(file="taxVertex.h", name="TaxonomyVertex")
public class TaxonomyVertex
implements Serializable {
    private static final long serialVersionUID = 11000L;
    @PortedFrom(file="taxVertex.h", name="Links")
    private LinkedHashSet<TaxonomyVertex> linksParent = new LinkedHashSet();
    @PortedFrom(file="taxVertex.h", name="Links")
    private LinkedHashSet<TaxonomyVertex> linksChild = new LinkedHashSet();
    @PortedFrom(file="taxVertex.h", name="sample")
    private ClassifiableEntry sample = null;
    @PortedFrom(file="taxVertex.h", name="synonyms")
    private Set<ClassifiableEntry> synonyms = new LinkedHashSet<ClassifiableEntry>();
    @PortedFrom(file="taxVertex.h", name="checked")
    private long checked;
    @Original
    private long isValued;
    @PortedFrom(file="taxVertex.h", name="common")
    private int common;
    @PortedFrom(file="taxVertex.h", name="checkValue")
    private boolean checkValue;
    @PortedFrom(file="taxVertex.h", name="inUse")
    private boolean inUse = true;

    @PortedFrom(file="taxVertex.h", name="setVertexAsHost")
    public void setVertexAsHost(ClassifiableEntry entry) {
        entry.setTaxVertex(this);
    }

    @PortedFrom(file="taxVertex.h", name="setSample")
    public void setSample(ClassifiableEntry entry, boolean linkBack) {
        this.sample = entry;
        if (linkBack) {
            this.setVertexAsHost(entry);
        }
    }

    @PortedFrom(file="taxVertex.h", name="neigh")
    public Iterable<TaxonomyVertex> neigh(boolean upDirection) {
        return upDirection ? this.linksParent : this.linksChild;
    }

    @PortedFrom(file="taxVertex.h", name="isChecked")
    public boolean isChecked(long checkLab) {
        return checkLab == this.checked;
    }

    @PortedFrom(file="taxVertex.h", name="setChecked")
    public void setChecked(long checkLab) {
        this.checked = checkLab;
    }

    @PortedFrom(file="taxVertex.h", name="isValued")
    public boolean isValued(long valueLab) {
        return valueLab == this.isValued;
    }

    @PortedFrom(file="taxVertex.h", name="getValue")
    public boolean getValue() {
        return this.checkValue;
    }

    @PortedFrom(file="taxVertex.h", name="setValued")
    public boolean setValued(boolean val, long valueLab) {
        this.isValued = valueLab;
        this.checkValue = val;
        return val;
    }

    @PortedFrom(file="taxVertex.h", name="isCommon")
    public boolean isCommon() {
        return this.common != 0;
    }

    @PortedFrom(file="taxVertex.h", name="setCommon")
    public void setCommon() {
        ++this.common;
    }

    @PortedFrom(file="taxVertex.h", name="clearCommon")
    public void clearCommon() {
        this.common = 0;
    }

    @PortedFrom(file="taxVertex.h", name="correctCommon")
    public boolean correctCommon(int n) {
        if (this.common == n) {
            return true;
        }
        this.common = 0;
        return false;
    }

    @PortedFrom(file="taxVertex.h", name="initFlags")
    private void initFlags() {
        this.checked = 0L;
        this.isValued = 0L;
        this.common = 0;
    }

    @PortedFrom(file="taxVertex.h", name="begin_syn")
    public Set<ClassifiableEntry> synonyms() {
        return this.synonyms;
    }

    public TaxonomyVertex() {
        this.initFlags();
    }

    public TaxonomyVertex(ClassifiableEntry p) {
        this.initFlags();
        this.setSample(p, true);
    }

    @PortedFrom(file="taxVertex.h", name="addSynonym")
    public void addSynonym(ClassifiableEntry p) {
        this.synonyms.add(p);
        p.setTaxVertex(this);
    }

    @PortedFrom(file="taxVertex.h", name="clear")
    public void clear() {
        this.linksParent.clear();
        this.linksChild.clear();
        this.sample = null;
        this.initFlags();
    }

    @PortedFrom(file="taxVertex.h", name="getPrimer")
    public ClassifiableEntry getPrimer() {
        return this.sample;
    }

    @PortedFrom(file="taxVertex.h", name="addNeighbour")
    public void addNeighbour(boolean upDirection, TaxonomyVertex p) {
        OWLAPIPreconditions.checkNotNull((Object)p, (String)"p cannot be null");
        this.add(upDirection, p);
    }

    public void add(boolean direction, TaxonomyVertex t) {
        if (direction) {
            this.linksParent.add(t);
        } else {
            this.linksChild.add(t);
        }
    }

    @PortedFrom(file="taxVertex.h", name="noNeighbours")
    public boolean noNeighbours(boolean upDirection) {
        if (upDirection) {
            return this.linksParent.isEmpty();
        }
        return this.linksChild.isEmpty();
    }

    @PortedFrom(file="taxVertex.h", name="getSynonymNode")
    public TaxonomyVertex getSynonymNode() {
        for (TaxonomyVertex q : this.neigh(true)) {
            for (TaxonomyVertex r : this.neigh(false)) {
                if (!q.equals(r)) continue;
                return q;
            }
        }
        return null;
    }

    @PortedFrom(file="taxVertex.h", name="clearLinks")
    public void clearLinks(boolean upDirection) {
        if (upDirection) {
            this.linksParent.clear();
        } else {
            this.linksChild.clear();
        }
    }

    @PortedFrom(file="taxVertex.h", name="removeLink")
    public boolean removeLink(boolean upDirection, TaxonomyVertex p) {
        if (upDirection) {
            return this.linksParent.remove(p);
        }
        return this.linksChild.remove(p);
    }

    @PortedFrom(file="taxVertex.h", name="incorporate")
    public void incorporate(JFactReasonerConfiguration c) {
        for (TaxonomyVertex d : this.neigh(false)) {
            for (TaxonomyVertex u : this.neigh(true)) {
                if (!d.removeLink(true, u)) continue;
                u.removeLink(false, d);
            }
            d.removeLink(true, this);
            d.addNeighbour(true, this);
        }
        for (TaxonomyVertex u : this.neigh(true)) {
            u.addNeighbour(false, this);
        }
        if (c.isLoggingActive()) {
            LogAdapter logAdapter = c.getLog();
            logAdapter.printTemplate(Templates.INCORPORATE, this.sample.getName());
            logAdapter.print((Object)this.names(this.neigh(true)));
            logAdapter.print("} and down = {");
            logAdapter.print((Object)this.names(this.neigh(false)));
            logAdapter.print("}");
        }
    }

    Iterable<IRI> names(Iterable<TaxonomyVertex> l) {
        ArrayList<IRI> toReturn = new ArrayList<IRI>();
        for (TaxonomyVertex t : l) {
            toReturn.add(t.sample.getName());
        }
        return toReturn;
    }

    @PortedFrom(file="taxVertex.h", name="removeLinks")
    public void removeLinks(boolean upDirection) {
        for (TaxonomyVertex p : this.neigh(upDirection)) {
            p.removeLink(!upDirection, this);
        }
        this.clearLinks(upDirection);
    }

    @PortedFrom(file="taxVertex.h", name="remove")
    public void remove() {
        this.removeLinks(true);
        this.removeLinks(false);
        this.setInUse(false);
    }

    @PortedFrom(file="taxVertex.h", name="isInUse")
    public boolean isInUse() {
        return this.inUse;
    }

    @PortedFrom(file="taxVertex.h", name="setInUse")
    public void setInUse(boolean value) {
        this.inUse = value;
    }

    @PortedFrom(file="taxVertex.h", name="mergeIndepNode")
    public void mergeIndepNode(TaxonomyVertex node, Set<TaxonomyVertex> excludes, ClassifiableEntry curEntry) {
        if (!node.getPrimer().equals(curEntry)) {
            this.addSynonym(node.getPrimer());
        }
        for (ClassifiableEntry q : node.synonyms()) {
            this.addSynonym(q);
        }
        boolean upDirection = true;
        for (TaxonomyVertex p : node.neigh(upDirection)) {
            if (!excludes.contains(p)) {
                this.addNeighbour(upDirection, p);
            }
            p.removeLink(!upDirection, node);
        }
        upDirection = false;
        for (TaxonomyVertex p : node.neigh(upDirection)) {
            if (!excludes.contains(p)) {
                this.addNeighbour(upDirection, p);
            }
            p.removeLink(!upDirection, node);
        }
    }

    @PortedFrom(file="taxVertex.h", name="printSynonyms")
    public String printSynonyms() {
        assert (this.sample != null);
        StringBuilder o = new StringBuilder();
        if (this.synonyms.isEmpty()) {
            o.append('\"');
            o.append((CharSequence)this.sample.getName());
            o.append('\"');
        } else {
            o.append("(\"");
            o.append((CharSequence)this.sample.getName());
            for (ClassifiableEntry q : this.synonyms()) {
                o.append("\"=\"");
                o.append((CharSequence)q.getName());
            }
            o.append("\")");
        }
        return o.toString();
    }

    @PortedFrom(file="taxVertex.h", name="printNeighbours")
    private static String printNeighbours(Collection<TaxonomyVertex> list) {
        StringBuilder o = new StringBuilder();
        o.append(" {");
        o.append(list.size());
        o.append(':');
        TreeSet<TaxonomyVertex> sorted = new TreeSet<TaxonomyVertex>(new Comparator<TaxonomyVertex>(){

            @Override
            public int compare(TaxonomyVertex o1, TaxonomyVertex o2) {
                return o1.getPrimer().getName().compareTo((OWLObject)o2.getPrimer().getName());
            }
        });
        sorted.addAll(list);
        for (TaxonomyVertex p : sorted) {
            o.append(" \"");
            o.append((CharSequence)p.sample.getName());
            o.append('\"');
        }
        o.append('}');
        return o.toString();
    }

    public String toString() {
        return this.printSynonyms() + TaxonomyVertex.printNeighbours(this.linksParent) + TaxonomyVertex.printNeighbours(this.linksChild) + '\n';
    }
}

