/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.ac.manchester.cs.jfact.dep.DepSet;
import uk.ac.manchester.cs.jfact.helpers.FastSetSimple;
import uk.ac.manchester.cs.jfact.helpers.Helper;
import uk.ac.manchester.cs.jfact.helpers.SaveStack;
import uk.ac.manchester.cs.jfact.kernel.ConceptWDep;
import uk.ac.manchester.cs.jfact.kernel.DagTag;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTree;
import uk.ac.manchester.cs.jfact.kernel.ToDoPriorMatrix;

@PortedFrom(file="ToDoList.h", name="ToDoList")
public class ToDoList {
    @Original
    static int limit = 500;
    @Original
    protected TODOListSaveState[] states = new TODOListSaveState[limit];
    @Original
    protected int nextState = 0;
    @Original
    volatile boolean change = true;
    @Original
    protected boolean saveStateGenerationStarted = false;
    @PortedFrom(file="ToDoList.h", name="queueID")
    private ArrayQueue queueID = new ArrayQueue();
    @PortedFrom(file="ToDoList.h", name="queueNN")
    private QueueQueue queueNN = new QueueQueue();
    @PortedFrom(file="ToDoList.h", name="Wait")
    private List<ArrayQueue> waitQueue = new ArrayList<ArrayQueue>(7);
    @PortedFrom(file="ToDoList.h", name="SaveStack")
    private SaveStack<TODOListSaveState> saveStack = new SaveStack();
    @PortedFrom(file="ToDoList.h", name="Matrix")
    private ToDoPriorMatrix matrix = new ToDoPriorMatrix();
    @PortedFrom(file="ToDoList.h", name="noe")
    private int noe = 0;

    @Original
    public TODOListSaveState getInstance() {
        return new TODOListSaveState();
    }

    @Original
    public boolean isSaveStateGenerationStarted() {
        return this.saveStateGenerationStarted;
    }

    @Original
    public void startSaveStateGeneration() {
        this.saveStateGenerationStarted = true;
        Thread stateFiller = new Thread(){

            @Override
            public void run() {
                long last = System.currentTimeMillis();
                while (System.currentTimeMillis() - last < 60000L) {
                    for (int wait = 0; wait < 10000; ++wait) {
                        if (ToDoList.this.change) {
                            for (int i = 0; i < limit; ++i) {
                                if (ToDoList.this.states[i] != null) continue;
                                ToDoList.this.states[i] = new TODOListSaveState();
                            }
                            ToDoList.this.change = false;
                            last = System.currentTimeMillis();
                        }
                        try {
                            Thread.sleep(5L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
                ToDoList.this.saveStateGenerationStarted = false;
            }
        };
        stateFiller.setPriority(1);
        stateFiller.setDaemon(true);
        stateFiller.start();
    }

    @PortedFrom(file="ToDoList.h", name="saveState")
    public void saveState(TODOListSaveState tss) {
        tss.backupID_sp = this.queueID.sPointer;
        tss.backupID_ep = this.queueID.Wait.size();
        this.queueNN.save(tss.backupNN);
        for (int i = 6; i >= 0; --i) {
            this.waitQueue.get(i).save(tss.backup, i);
        }
        tss.noe = this.noe;
    }

    @PortedFrom(file="ToDoList.h", name="restoreState")
    public void restoreState(TODOListSaveState tss) {
        this.queueID.restore(tss.backupID_sp, tss.backupID_ep);
        this.queueNN.restore(tss.backupNN);
        for (int i = 6; i >= 0; --i) {
            this.waitQueue.get(i).restore(tss.backup[i][0], tss.backup[i][1]);
        }
        this.noe = tss.noe;
    }

    public ToDoList() {
        for (int i = 0; i < 7; ++i) {
            this.waitQueue.add(new ArrayQueue());
        }
    }

    @Original
    public void initPriorities(String Options) {
        this.matrix.initPriorities(Options, "IAOEFLG");
    }

    @PortedFrom(file="ToDoList.h", name="clear")
    public void clear() {
        this.queueID.clear();
        this.queueNN.clear();
        for (int i = 6; i >= 0; --i) {
            this.waitQueue.get(i).clear();
        }
        this.saveStack.clear();
        this.noe = 0;
    }

    public boolean isEmpty() {
        return this.noe == 0;
    }

    @PortedFrom(file="ToDoList.h", name="addEntry")
    public void addEntry(DlCompletionTree node, DagTag type, ConceptWDep C) {
        int index = this.matrix.getIndex(type, C.getConcept() > 0, node.isNominalNode());
        switch (index) {
            case 7: {
                return;
            }
            case 8: {
                this.queueID.add(node, C);
                break;
            }
            case 9: {
                this.queueNN.add(node, C);
                break;
            }
            default: {
                this.waitQueue.get(index).add(node, C);
            }
        }
        ++this.noe;
    }

    @PortedFrom(file="ToDoList.h", name="save")
    public void save() {
        TODOListSaveState state = this.getInstance();
        this.saveState(state);
        this.saveStack.push(state);
    }

    @PortedFrom(file="ToDoList.h", name="restore")
    public void restore(int level) {
        this.restoreState(this.saveStack.pop(level));
    }

    @PortedFrom(file="ToDoList.h", name="getNextEntry")
    public ToDoEntry getNextEntry() {
        assert (!this.isEmpty());
        --this.noe;
        if (!this.queueID.isEmpty()) {
            return this.queueID.get();
        }
        if (!this.queueNN.isEmpty()) {
            return this.queueNN.get();
        }
        for (int i = 0; i < 7; ++i) {
            ArrayQueue arrayQueue = this.waitQueue.get(i);
            if (arrayQueue.isEmpty()) continue;
            return arrayQueue.get();
        }
        return null;
    }

    public String toString() {
        StringBuilder l = new StringBuilder("Todolist{");
        l.append("\n");
        l.append(this.queueID);
        l.append("\n");
        for (int i = 0; i < 7; ++i) {
            l.append(this.waitQueue.get(i));
            l.append("\n");
        }
        l.append("\n");
        l.append("}");
        return l.toString();
    }

    static class TODOListSaveState {
        protected int backupID_sp;
        protected int backupID_ep;
        protected QueueQueueSaveState backupNN = new QueueQueueSaveState();
        protected int[][] backup = new int[7][2];
        @PortedFrom(file="ToDoList.h", name="noe")
        protected int noe;

        TODOListSaveState() {
        }

        public String toString() {
            return "" + this.noe + " " + this.backupID_sp + "," + this.backupID_ep + " " + this.backupNN + " " + Arrays.toString((Object[])this.backup);
        }
    }

    static class QueueQueue {
        private List<ToDoEntry> _Wait = new ArrayList<ToDoEntry>();
        private int sPointer = 0;
        private boolean queueBroken = false;
        int size = 0;

        QueueQueue() {
        }

        void add(DlCompletionTree Node2, ConceptWDep offset) {
            int n;
            ToDoEntry e = new ToDoEntry(Node2, offset);
            if (this.isEmpty() || this._Wait.get(this.size - 1).getNode().getNominalLevel() <= Node2.getNominalLevel()) {
                this._Wait.add(e);
                ++this.size;
                return;
            }
            for (n = this.size; n > this.sPointer && this._Wait.get(n - 1).getNode().getNominalLevel() > Node2.getNominalLevel(); --n) {
            }
            this._Wait.add(n, e);
            this.queueBroken = true;
            ++this.size;
        }

        @PortedFrom(file="ToDoList.h", name="clear")
        void clear() {
            this.sPointer = 0;
            this.queueBroken = false;
            this._Wait.clear();
            this.size = 0;
        }

        boolean isEmpty() {
            return this.sPointer == this.size;
        }

        ToDoEntry get() {
            return this._Wait.get(this.sPointer++);
        }

        @PortedFrom(file="ToDoList.h", name="save")
        void save(QueueQueueSaveState tss) {
            tss.queueBroken = this.queueBroken;
            tss.sp = this.sPointer;
            if (this.queueBroken) {
                tss.waitingQueue = new ArrayList<ToDoEntry>(this._Wait);
            } else {
                tss.ep = this.size;
            }
            this.queueBroken = false;
        }

        @PortedFrom(file="ToDoList.h", name="restore")
        void restore(QueueQueueSaveState tss) {
            this.queueBroken = tss.queueBroken;
            this.sPointer = tss.sp;
            if (this.queueBroken) {
                this._Wait = tss.waitingQueue;
                this.size = this._Wait.size();
            } else {
                Helper.resize(this._Wait, tss.ep);
                this.size = tss.ep;
            }
        }

        public String toString() {
            return "{" + (!this.isEmpty() ? this._Wait.get(this.sPointer) : "empty") + " sPointer: " + this.sPointer + " size: " + this.size + " Wait: " + this._Wait + "}";
        }
    }

    static class QueueQueueSaveState {
        protected List<ToDoEntry> waitingQueue;
        protected int sp;
        protected int ep;
        protected boolean queueBroken;

        QueueQueueSaveState() {
        }
    }

    static class ArrayQueue {
        List<ToDoEntry> Wait = new ArrayList<ToDoEntry>(50);
        int sPointer = 0;

        ArrayQueue() {
        }

        public void add(DlCompletionTree node, ConceptWDep offset) {
            this.Wait.add(new ToDoEntry(node, offset));
        }

        @PortedFrom(file="ToDoList.h", name="clear")
        public void clear() {
            this.sPointer = 0;
            this.Wait.clear();
        }

        @PortedFrom(file="ToDoList.h", name="empty")
        public boolean isEmpty() {
            return this.sPointer == this.Wait.size();
        }

        public ToDoEntry get() {
            return this.Wait.get(this.sPointer++);
        }

        @PortedFrom(file="ToDoList.h", name="save")
        public void save(int[][] tss, int pos) {
            tss[pos][0] = this.sPointer;
            tss[pos][1] = this.Wait.size();
        }

        @PortedFrom(file="ToDoList.h", name="restore")
        public void restore(int[][] tss, int pos) {
            this.sPointer = tss[pos][0];
            Helper.resize(this.Wait, tss[pos][1]);
        }

        @PortedFrom(file="ToDoList.h", name="restore")
        public void restore(int sp, int ep) {
            this.sPointer = sp;
            Helper.resize(this.Wait, ep);
        }

        public String toString() {
            StringBuilder l = new StringBuilder();
            l.append("ArrayQueue{");
            l.append(this.sPointer);
            l.append(",");
            for (ToDoEntry t : this.Wait) {
                l.append(t);
                l.append(" ");
            }
            l.append("}");
            return l.toString();
        }
    }

    public static class ToDoEntry {
        private DlCompletionTree node;
        private int concept;
        private FastSetSimple delegate;

        ToDoEntry(DlCompletionTree n, ConceptWDep off) {
            this.node = n;
            this.concept = off.getConcept();
            this.delegate = off.getDep().getDelegate();
        }

        protected DlCompletionTree getNode() {
            return this.node;
        }

        protected int getOffsetConcept() {
            return this.concept;
        }

        protected FastSetSimple getOffsetDepSet() {
            return this.delegate;
        }

        public String toString() {
            return "Node(" + this.node.getId() + "), offset(" + new ConceptWDep(this.concept, DepSet.create((FastSetSimple)this.delegate)) + ")";
        }
    }
}

