/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel.actors;

import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.ExpressionCache;
import uk.ac.manchester.cs.jfact.kernel.TaxonomyVertex;
import uk.ac.manchester.cs.jfact.kernel.actors.Actor;
import uk.ac.manchester.cs.jfact.kernel.actors.Policy;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.Expression;

@PortedFrom(file="JNIActor.h", name="TaxonomyActor")
public class TaxonomyActor<T extends Expression>
implements Actor,
Serializable {
    private static final long serialVersionUID = 11000L;
    private final Policy policy;
    private final ExpressionCache cache;
    @PortedFrom(file="JNIActor.h", name="acc")
    private final List<List<T>> acc = new ArrayList<List<T>>();
    @PortedFrom(file="JNIActor.h", name="plain")
    private final List<T> plain = new ArrayList<T>();
    @PortedFrom(file="JNIActor.h", name="syn")
    private final List<T> syn = new ArrayList<T>();

    @Override
    public boolean applicable(TaxonomyVertex v) {
        if (this.policy.applicable(v.getPrimer())) {
            return true;
        }
        for (ClassifiableEntry p : v.synonyms()) {
            if (!this.policy.applicable(p)) continue;
            return true;
        }
        return false;
    }

    @PortedFrom(file="JNIActor.h", name="tryEntry")
    protected void tryEntry(ClassifiableEntry p) {
        if (p.isSystem()) {
            return;
        }
        if (this.policy.applicable(p)) {
            this.syn.add(this.asT(p));
        }
    }

    protected T asT(ClassifiableEntry p) {
        return (T)this.policy.buildTree(this.cache, p);
    }

    @PortedFrom(file="JNIActor.h", name="TaxonomyActor")
    public TaxonomyActor(ExpressionCache em, Policy p) {
        this.cache = em;
        this.policy = p;
    }

    @Override
    @PortedFrom(file="JNIActor.h", name="clear")
    public void clear() {
        this.acc.clear();
        this.plain.clear();
    }

    @PortedFrom(file="JNIActor.h", name="getSynonyms")
    public Collection<T> getSynonyms() {
        return this.acc.isEmpty() ? this.syn : this.acc.get(0);
    }

    @PortedFrom(file="JNIActor.h", name="getElements")
    public List<Collection<T>> getElements() {
        ArrayList<Collection<T>> toReturn = new ArrayList<Collection<T>>();
        if (this.policy.needPlain()) {
            toReturn.add(this.plain);
        } else {
            for (int i = 0; i < this.acc.size(); ++i) {
                toReturn.add(this.acc.get(i));
            }
        }
        return toReturn;
    }

    @Override
    @PortedFrom(file="JNIActor.h", name="apply")
    public boolean apply(TaxonomyVertex v) {
        this.syn.clear();
        this.tryEntry(v.getPrimer());
        for (ClassifiableEntry p : v.synonyms()) {
            this.tryEntry(p);
        }
        if (this.syn.isEmpty()) {
            return false;
        }
        if (this.policy.needPlain()) {
            this.plain.addAll(this.syn);
        } else {
            this.acc.add(new ArrayList<T>(this.syn));
        }
        return true;
    }

    @Override
    public void removePastBoundaries(Collection<TaxonomyVertex> pastBoundary) {
        ArrayList<T> entries = new ArrayList<T>();
        for (TaxonomyVertex taxonomyVertex : pastBoundary) {
            entries.add(this.asT(taxonomyVertex.getPrimer()));
            for (TaxonomyVertex t1 = taxonomyVertex.getSynonymNode(); t1 != null; t1 = t1.getSynonymNode()) {
                entries.add(this.asT(t1.getPrimer()));
            }
        }
        this.plain.removeAll(entries);
        for (List list : this.acc) {
            list.removeAll(entries);
        }
    }
}

