/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel.modelcaches;

import conformance.PortedFrom;
import java.util.BitSet;
import java.util.List;
import uk.ac.manchester.cs.jfact.helpers.DLVertex;
import uk.ac.manchester.cs.jfact.helpers.FastSet;
import uk.ac.manchester.cs.jfact.helpers.FastSetFactory;
import uk.ac.manchester.cs.jfact.helpers.LogAdapter;
import uk.ac.manchester.cs.jfact.helpers.UnreachableSituationException;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.ConceptWDep;
import uk.ac.manchester.cs.jfact.kernel.DLDag;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTree;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTreeArc;
import uk.ac.manchester.cs.jfact.kernel.RAStateTransitions;
import uk.ac.manchester.cs.jfact.kernel.RATransition;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheInterface;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheSingleton;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheState;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheType;
import uk.ac.manchester.cs.jfact.kernel.options.JFactReasonerConfiguration;

@PortedFrom(file="modelCacheIan.h", name="modelCacheIan")
public class ModelCacheIan
extends ModelCacheInterface {
    private static final long serialVersionUID = 11000L;
    @PortedFrom(file="modelCacheIan.h", name="posDConcepts")
    private final BitSet posDConcepts = new BitSet();
    @PortedFrom(file="modelCacheIan.h", name="posNConcepts")
    private final BitSet posNConcepts = new BitSet();
    @PortedFrom(file="modelCacheIan.h", name="negDConcepts")
    private final BitSet negDConcepts = new BitSet();
    @PortedFrom(file="modelCacheIan.h", name="negNConcepts")
    private final BitSet negNConcepts = new BitSet();
    @PortedFrom(file="modelCacheIan.h", name="extraDConcepts")
    private final FastSet extraDConcepts = FastSetFactory.create();
    @PortedFrom(file="modelCacheIan.h", name="extraNConcepts")
    private final FastSet extraNConcepts = FastSetFactory.create();
    @PortedFrom(file="modelCacheIan.h", name="existsRoles")
    private final FastSet existsRoles = FastSetFactory.create();
    @PortedFrom(file="modelCacheIan.h", name="forallRoles")
    private final FastSet forallRoles = FastSetFactory.create();
    @PortedFrom(file="modelCacheIan.h", name="funcRoles")
    private final FastSet funcRoles = FastSetFactory.create();
    @PortedFrom(file="modelCacheIan.h", name="curState")
    private ModelCacheState curState = ModelCacheState.csValid;
    private final int nC;
    private final int nR;
    private final JFactReasonerConfiguration simpleRules;

    @PortedFrom(file="modelCacheIan.h", name="processLabelInterval")
    private void processLabelInterval(DLDag DLHeap, List<ConceptWDep> start) {
        for (int i = 0; i < start.size(); ++i) {
            ConceptWDep p = start.get(i);
            int bp = p.getConcept();
            this.processConcept(DLHeap.get(bp), bp > 0, p.getDep().isEmpty());
        }
    }

    @PortedFrom(file="modelCacheIan.h", name="initCacheByLabel")
    private void initCacheByLabel(DLDag DLHeap, DlCompletionTree pCT) {
        this.processLabelInterval(DLHeap, pCT.beginl_sc());
        this.processLabelInterval(DLHeap, pCT.beginl_cc());
    }

    public ModelCacheIan(DLDag heap, DlCompletionTree p, boolean flagNominals, int nC, int nR, JFactReasonerConfiguration simpleRules) {
        this(flagNominals, nC, nR, simpleRules);
        this.initCacheByLabel(heap, p);
        this.initRolesFromArcs(p);
    }

    public ModelCacheIan(boolean flagNominals, int nC, int nR, JFactReasonerConfiguration simpleRules) {
        super(flagNominals);
        this.simpleRules = simpleRules;
        this.nC = nC;
        this.nR = nR;
    }

    @Override
    @PortedFrom(file="modelCacheIan.h", name="getState")
    public ModelCacheState getState() {
        return this.curState;
    }

    @PortedFrom(file="modelCacheIan.h", name="getDConcepts")
    private BitSet getDConcepts(boolean pos) {
        return pos ? this.posDConcepts : this.negDConcepts;
    }

    @PortedFrom(file="modelCacheIan.h", name="getNConcepts")
    private BitSet getNConcepts(boolean pos) {
        return pos ? this.posNConcepts : this.negNConcepts;
    }

    @PortedFrom(file="modelCacheIan.h", name="getExtra")
    private FastSet getExtra(boolean det) {
        return det ? this.extraDConcepts : this.extraNConcepts;
    }

    @PortedFrom(file="modelCacheIan.h", name="initRolesFromArcs")
    public void initRolesFromArcs(DlCompletionTree pCT) {
        List<DlCompletionTreeArc> list = pCT.getNeighbour();
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).isIBlocked()) continue;
            this.addExistsRole(list.get(i).getRole());
        }
        this.curState = ModelCacheState.csValid;
    }

    @Override
    @PortedFrom(file="modelCacheIan.h", name="getCacheType")
    public ModelCacheType getCacheType() {
        return ModelCacheType.mctIan;
    }

    @Override
    @PortedFrom(file="modelCacheIan.h", name="shallowCache")
    public boolean shallowCache() {
        return this.existsRoles.isEmpty();
    }

    @PortedFrom(file="modelCacheIan.h", name="clear")
    public void clear() {
        this.posDConcepts.clear();
        this.posNConcepts.clear();
        this.negDConcepts.clear();
        this.negNConcepts.clear();
        if (this.simpleRules.isRKG_USE_SIMPLE_RULES()) {
            this.extraDConcepts.clear();
            this.extraNConcepts.clear();
        }
        this.existsRoles.clear();
        this.forallRoles.clear();
        this.funcRoles.clear();
        this.curState = ModelCacheState.csValid;
    }

    @PortedFrom(file="modelCacheIan.h", name="processConcept")
    public void processConcept(DLVertex cur, boolean pos, boolean det) {
        switch (cur.getType()) {
            case dtTop: 
            case dtDataType: 
            case dtDataValue: 
            case dtDataExpr: {
                throw new UnreachableSituationException(cur.toString() + " Top datatype property, datatype, data value or data expression used in an unexpected position");
            }
            case dtNConcept: 
            case dtPConcept: 
            case dtNSingleton: 
            case dtPSingleton: {
                int toAdd = ((ClassifiableEntry)cur.getConcept()).getIndex();
                (det ? this.getDConcepts(pos) : this.getNConcepts(pos)).set(toAdd);
                break;
            }
            case dtIrr: 
            case dtForall: 
            case dtLE: {
                if (cur.getRole().isTop()) {
                    (pos ? this.forallRoles : this.existsRoles).completeSet(this.nR);
                    break;
                }
                if (!pos) break;
                if (cur.getRole().isSimple()) {
                    this.forallRoles.add(cur.getRole().getIndex());
                    break;
                }
                this.processAutomaton(cur);
                break;
            }
        }
    }

    @PortedFrom(file="modelCacheIan.h", name="processAutomaton")
    public void processAutomaton(DLVertex cur) {
        RAStateTransitions RST = cur.getRole().getAutomaton().get(cur.getState());
        List<RATransition> begin = RST.begin();
        for (int i = 0; i < begin.size(); ++i) {
            for (Role r : begin.get(i).begin()) {
                this.forallRoles.add(r.getIndex());
            }
        }
    }

    @PortedFrom(file="modelCacheIan.h", name="addRoleToCache")
    private void addRoleToCache(Role R) {
        this.existsRoles.add(R.getIndex());
        if (R.isTopFunc()) {
            this.funcRoles.add(R.getIndex());
        }
    }

    @PortedFrom(file="modelCacheIan.h", name="addExistsRole")
    private void addExistsRole(Role R) {
        this.addRoleToCache(R);
        List<Role> list = R.getAncestor();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            this.addRoleToCache(list.get(i));
        }
    }

    @Override
    @PortedFrom(file="modelCacheIan.h", name="canMerge")
    public ModelCacheState canMerge(ModelCacheInterface p) {
        if (this.hasNominalClash(p)) {
            return ModelCacheState.csFailed;
        }
        if (p.getState() != ModelCacheState.csValid || this.curState != ModelCacheState.csValid) {
            return ModelCacheIan.mergeStatus(p.getState(), this.curState);
        }
        switch (p.getCacheType()) {
            case mctConst: {
                return ModelCacheState.csValid;
            }
            case mctSingleton: {
                int Singleton = ((ModelCacheSingleton)p).getValue();
                return this.isMergableSingleton(Math.abs(Singleton), Singleton > 0);
            }
            case mctIan: {
                return this.isMergableIan((ModelCacheIan)p);
            }
        }
        return ModelCacheState.csUnknown;
    }

    @PortedFrom(file="modelCacheIan.h", name="isMergableSingleton")
    public ModelCacheState isMergableSingleton(int Singleton, boolean pos) {
        assert (Singleton != 0);
        if (this.getDConcepts(!pos).get(Singleton)) {
            return ModelCacheState.csInvalid;
        }
        if (this.getNConcepts(!pos).get(Singleton)) {
            return ModelCacheState.csFailed;
        }
        return ModelCacheState.csValid;
    }

    @PortedFrom(file="modelCacheIan.h", name="isMergableIan")
    public ModelCacheState isMergableIan(ModelCacheIan q) {
        if (this.posDConcepts.intersects(q.negDConcepts) || q.posDConcepts.intersects(this.negDConcepts)) {
            return ModelCacheState.csInvalid;
        }
        if (this.existsRoles.intersect(q.forallRoles) || q.existsRoles.intersect(this.forallRoles) || this.funcRoles.intersect(q.funcRoles) || this.posDConcepts.intersects(q.negNConcepts) || this.posNConcepts.intersects(q.negDConcepts) || this.posNConcepts.intersects(q.negNConcepts) || q.posDConcepts.intersects(this.negNConcepts) || q.posNConcepts.intersects(this.negDConcepts) || q.posNConcepts.intersects(this.negNConcepts)) {
            return ModelCacheState.csFailed;
        }
        if (this.simpleRules.isRKG_USE_SIMPLE_RULES() && this.getExtra(true).intersect(q.getExtra(true))) {
            return ModelCacheState.csInvalid;
        }
        if (this.simpleRules.isRKG_USE_SIMPLE_RULES() && (this.getExtra(true).intersect(q.getExtra(false)) || this.getExtra(false).intersect(q.getExtra(true)) || this.getExtra(false).intersect(q.getExtra(false)))) {
            return ModelCacheState.csFailed;
        }
        return ModelCacheState.csValid;
    }

    @PortedFrom(file="modelCacheIan.h", name="merge")
    public ModelCacheState merge(ModelCacheInterface p) {
        assert (p != null);
        if (this.hasNominalClash(p)) {
            this.curState = ModelCacheState.csFailed;
            return this.curState;
        }
        switch (p.getCacheType()) {
            case mctConst: {
                this.curState = ModelCacheIan.mergeStatus(this.curState, p.getState());
                break;
            }
            case mctSingleton: {
                int Singleton = ((ModelCacheSingleton)p).getValue();
                this.mergeSingleton(Math.abs(Singleton), Singleton > 0);
                break;
            }
            case mctIan: {
                this.mergeIan((ModelCacheIan)p);
                break;
            }
            default: {
                throw new UnreachableSituationException();
            }
        }
        this.updateNominalStatus(p);
        return this.curState;
    }

    @PortedFrom(file="modelCacheIan.h", name="mergeSingleton")
    private void mergeSingleton(int Singleton, boolean pos) {
        ModelCacheState newState = this.isMergableSingleton(Singleton, pos);
        if (newState != ModelCacheState.csValid) {
            this.curState = ModelCacheIan.mergeStatus(this.curState, newState);
        } else {
            this.getDConcepts(pos).set(Singleton);
        }
    }

    @PortedFrom(file="modelCacheIan.h", name="mergeIan")
    private void mergeIan(ModelCacheIan p) {
        this.curState = this.isMergableIan(p);
        this.posDConcepts.or(p.posDConcepts);
        this.posNConcepts.or(p.posNConcepts);
        this.negDConcepts.or(p.negDConcepts);
        this.negNConcepts.or(p.negNConcepts);
        if (this.simpleRules.isRKG_USE_SIMPLE_RULES()) {
            this.extraDConcepts.addAll(p.extraDConcepts);
            this.extraNConcepts.addAll(p.extraNConcepts);
        }
        this.existsRoles.addAll(p.existsRoles);
        this.forallRoles.addAll(p.forallRoles);
        this.funcRoles.addAll(p.funcRoles);
    }

    @Override
    @PortedFrom(file="modelCacheIan.h", name="logCacheEntry")
    public void logCacheEntry(int level, LogAdapter l) {
        l.print("\nIan cache: posDConcepts = {", this.posDConcepts, "}, posNConcepts = {", this.posNConcepts, "}, negDConcepts = {", this.negDConcepts, "}, negNConcepts = {", this.negNConcepts, "}, existsRoles = {", this.existsRoles, "}, forallRoles = {", this.forallRoles, "}, funcRoles = {", this.funcRoles, "}");
    }

    @PortedFrom(file="modelCacheInterface.h", name="mergeStatus")
    private static ModelCacheState mergeStatus(ModelCacheState s1, ModelCacheState s2) {
        if (s1 == ModelCacheState.csInvalid || s2 == ModelCacheState.csInvalid) {
            return ModelCacheState.csInvalid;
        }
        if (s1 == ModelCacheState.csFailed || s2 == ModelCacheState.csFailed) {
            return ModelCacheState.csFailed;
        }
        if (s1 == ModelCacheState.csUnknown || s2 == ModelCacheState.csUnknown) {
            return ModelCacheState.csUnknown;
        }
        return ModelCacheState.csValid;
    }
}

