/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.split;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.Concept;
import uk.ac.manchester.cs.jfact.kernel.ConceptWDep;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTree;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTreeArc;
import uk.ac.manchester.cs.jfact.kernel.ExpressionCache;
import uk.ac.manchester.cs.jfact.kernel.Individual;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.TBox;
import uk.ac.manchester.cs.jfact.kernel.TDag2Interface;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptName;
import uk.ac.manchester.cs.jfact.kernel.dl.IndividualName;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataRoleExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.Expression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.NamedEntity;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleExpression;

@PortedFrom(file="KnowledgeExplorer.h", name="KnowledgeExplorer")
public class KnowledgeExplorer
implements Serializable {
    private static final long serialVersionUID = 11000L;
    @PortedFrom(file="KnowledgeExplorer.h", name="Cs")
    private final Multimap<NamedEntity, Concept> Cs = LinkedHashMultimap.create();
    @PortedFrom(file="KnowledgeExplorer.h", name="Is")
    private final Multimap<NamedEntity, Individual> Is = LinkedHashMultimap.create();
    @PortedFrom(file="KnowledgeExplorer.h", name="ORs")
    private final Multimap<NamedEntity, Role> ORs = LinkedHashMultimap.create();
    @PortedFrom(file="KnowledgeExplorer.h", name="DRs")
    private final Multimap<NamedEntity, Role> DRs = LinkedHashMultimap.create();
    @PortedFrom(file="KnowledgeExplorer.h", name="D2I")
    private final TDag2Interface D2I;
    @PortedFrom(file="KnowledgeExplorer.h", name="Nodes")
    private final List<DlCompletionTree> Nodes = new ArrayList<DlCompletionTree>();
    @PortedFrom(file="KnowledgeExplorer.h", name="Concepts")
    private final List<Expression> Concepts = new ArrayList<Expression>();

    @PortedFrom(file="KnowledgeExplorer.h", name="addE")
    private static <E extends ClassifiableEntry> void addE(Multimap<E, E> map, E entry) {
        map.put(entry, entry);
        if (entry.isSynonym()) {
            map.put((Object)entry.getSynonym(), entry);
        }
    }

    public KnowledgeExplorer(TBox box, ExpressionCache pEM) {
        this.D2I = new TDag2Interface(box.getDag(), pEM);
        for (Concept c : box.getConcepts()) {
            this.Cs.put((Object)c.getEntity(), (Object)c);
            if (!c.isSynonym()) continue;
            this.Cs.put((Object)c.getSynonym().getEntity(), (Object)c);
        }
        for (Individual i : box.i_begin()) {
            this.Is.put((Object)i.getEntity(), (Object)i);
            if (!i.isSynonym()) continue;
            this.Is.put((Object)i.getSynonym().getEntity(), (Object)i);
        }
        for (Role R : box.getORM().getRoles()) {
            this.ORs.put((Object)R.getEntity(), (Object)R);
            if (R.isSynonym()) {
                this.ORs.put((Object)R.getSynonym().getEntity(), (Object)R);
            }
            this.ORs.putAll((Object)R.getEntity(), R.getAncestor());
        }
        for (Role R : box.getDRM().getRoles()) {
            this.DRs.put((Object)R.getEntity(), (Object)R);
            if (R.isSynonym()) {
                this.DRs.put((Object)R.getSynonym().getEntity(), (Object)R);
            }
            this.DRs.putAll((Object)R.getEntity(), R.getAncestor());
        }
    }

    @PortedFrom(file="KnowledgeExplorer.h", name="addC")
    private void addC(Expression e) {
        if (e instanceof ConceptName) {
            ConceptName C = (ConceptName)e;
            for (Concept p : this.Cs.get((Object)C)) {
                if (p == null) {
                    System.err.println("Null found while processing class " + C.getName());
                    continue;
                }
                this.Concepts.add(this.D2I.getCExpr(p.getId()));
            }
            return;
        }
        if (e instanceof IndividualName) {
            IndividualName I = (IndividualName)e;
            for (Individual p : this.Is.get((Object)I)) {
                if (p == null) {
                    System.err.println("Null found while processing individual " + I.getName());
                    continue;
                }
                this.Concepts.add(this.D2I.getCExpr(p.getId()));
            }
            return;
        }
        this.Concepts.add(e);
    }

    @PortedFrom(file="KnowledgeExplorer.h", name="getDataRoles")
    public Set<DataRoleExpression> getDataRoles(DlCompletionTree node, boolean onlyDet) {
        HashSet<DataRoleExpression> roles = new HashSet<DataRoleExpression>();
        for (DlCompletionTreeArc p : node.getNeighbour()) {
            if (p.isIBlocked() || !p.getArcEnd().isDataNode() || onlyDet && !p.getDep().isEmpty()) continue;
            for (Role r : this.DRs.get((Object)p.getRole().getEntity())) {
                roles.add((DataRoleExpression)this.D2I.getDataRoleExpression(r));
            }
        }
        return roles;
    }

    @PortedFrom(file="KnowledgeExplorer.h", name="getObjectRoles")
    public Set<ObjectRoleExpression> getObjectRoles(DlCompletionTree node, boolean onlyDet, boolean needIncoming) {
        HashSet<ObjectRoleExpression> roles = new HashSet<ObjectRoleExpression>();
        for (DlCompletionTreeArc p : node.getNeighbour()) {
            if (p.isIBlocked() || p.getArcEnd().isDataNode() || onlyDet && !p.getDep().isEmpty() || !needIncoming && !p.isSuccEdge()) continue;
            for (Role r : this.ORs.get((Object)p.getRole().getEntity())) {
                roles.add((ObjectRoleExpression)this.D2I.getObjectRoleExpression(r));
            }
        }
        return roles;
    }

    @PortedFrom(file="KnowledgeExplorer.h", name="getNeighbours")
    public List<DlCompletionTree> getNeighbours(DlCompletionTree node, Role R) {
        this.Nodes.clear();
        for (DlCompletionTreeArc p : node.getNeighbour()) {
            if (p.isIBlocked() || !p.isNeighbour(R)) continue;
            this.Nodes.add(p.getArcEnd());
        }
        return this.Nodes;
    }

    @PortedFrom(file="KnowledgeExplorer.h", name="getLabel")
    public List<ConceptExpression> getObjectLabel(DlCompletionTree node, boolean onlyDet) {
        this.D2I.ensureDagSize();
        assert (!node.isDataNode());
        this.Concepts.clear();
        for (ConceptWDep p : node.beginl_sc()) {
            if (onlyDet && !p.getDep().isEmpty()) continue;
            this.addC(this.D2I.getExpr(p.getConcept(), false));
        }
        for (ConceptWDep p : node.beginl_cc()) {
            if (onlyDet && !p.getDep().isEmpty()) continue;
            this.addC(this.D2I.getExpr(p.getConcept(), false));
        }
        ArrayList<ConceptExpression> toReturn = new ArrayList<ConceptExpression>();
        for (Expression e : this.Concepts) {
            if (!(e instanceof ConceptExpression)) continue;
            toReturn.add((ConceptExpression)e);
        }
        return toReturn;
    }

    @PortedFrom(file="KnowledgeExplorer.h", name="getLabel")
    public List<DataExpression> getDataLabel(DlCompletionTree node, boolean onlyDet) {
        this.D2I.ensureDagSize();
        assert (node.isDataNode());
        this.Concepts.clear();
        for (ConceptWDep p : node.beginl_sc()) {
            if (onlyDet && !p.getDep().isEmpty()) continue;
            this.addC(this.D2I.getExpr(p.getConcept(), true));
        }
        for (ConceptWDep p : node.beginl_cc()) {
            if (onlyDet && !p.getDep().isEmpty()) continue;
            this.addC(this.D2I.getExpr(p.getConcept(), true));
        }
        ArrayList<DataExpression> toReturn = new ArrayList<DataExpression>();
        for (Expression e : this.Concepts) {
            if (!(e instanceof DataExpression)) continue;
            toReturn.add((DataExpression)e);
        }
        return toReturn;
    }

    @PortedFrom(file="KnowledgeExplorer.h", name="getBlocker")
    @Nonnull
    public DlCompletionTree getBlocker(DlCompletionTree node) {
        return node.getBlocker();
    }
}

