/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.split;

import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeExpression;
import uk.ac.manchester.cs.jfact.datatypes.Literal;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptAnd;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptBottom;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataValue;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptNot;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectSelf;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectValue;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptOneOf;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptOr;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptTop;
import uk.ac.manchester.cs.jfact.kernel.dl.DataAnd;
import uk.ac.manchester.cs.jfact.kernel.dl.DataBottom;
import uk.ac.manchester.cs.jfact.kernel.dl.DataNot;
import uk.ac.manchester.cs.jfact.kernel.dl.DataOneOf;
import uk.ac.manchester.cs.jfact.kernel.dl.DataOr;
import uk.ac.manchester.cs.jfact.kernel.dl.DataRoleBottom;
import uk.ac.manchester.cs.jfact.kernel.dl.DataRoleTop;
import uk.ac.manchester.cs.jfact.kernel.dl.DataTop;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleBottom;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleChain;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleInverse;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleTop;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.Expression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.NAryExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.NamedEntity;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.RoleExpression;
import uk.ac.manchester.cs.jfact.split.CardinalityEvaluatorBase;
import uk.ac.manchester.cs.jfact.split.TSignature;

class UpperBoundComplementEvaluator
extends CardinalityEvaluatorBase {
    private static final long serialVersionUID = 11000L;

    protected int getNoneValue() {
        return -1;
    }

    protected int getAllValue() {
        return 0;
    }

    @Override
    protected int getEntityValue(NamedEntity entity) {
        return this.topCLocal() && this.sig.nc(entity) ? this.getAllValue() : this.getNoneValue();
    }

    @Override
    protected int getForallValue(RoleExpression R, Expression C) {
        if (this.isBotEquivalent(R) || this.getUpperBoundComplement(C) == 0) {
            return this.getAllValue();
        }
        return this.getNoneValue();
    }

    @Override
    protected int getMinValue(int m, RoleExpression R, Expression C) {
        if (m == 0) {
            return this.getAllValue();
        }
        if (!this.isTopEquivalent(R)) {
            return this.getNoneValue();
        }
        return this.getLowerBoundDirect(C) >= m ? this.getAllValue() : this.getNoneValue();
    }

    @Override
    protected int getMaxValue(int m, RoleExpression R, Expression C) {
        if (this.isBotEquivalent(R)) {
            return this.getAllValue();
        }
        int lbC = this.getUpperBoundDirect(C);
        if (lbC != this.getNoneValue() && lbC <= m) {
            return this.getAllValue();
        }
        return this.getNoneValue();
    }

    @Override
    protected int getExactValue(int m, RoleExpression R, Expression C) {
        return Math.min(this.getMinValue(m, R, C), this.getMaxValue(m, R, C));
    }

    protected <C extends Expression> int getAndValue(NAryExpression<C> expr) {
        int sum = 0;
        for (Expression p : expr.getArguments()) {
            int n = this.getUpperBoundComplement(p);
            if (n == this.getNoneValue()) {
                return this.getNoneValue();
            }
            sum += n;
        }
        return sum;
    }

    protected <C extends Expression> int getOrValue(NAryExpression<C> expr) {
        int max = this.getNoneValue();
        for (Expression p : expr.getArguments()) {
            max = Math.max(max, this.getUpperBoundComplement(p));
        }
        return max;
    }

    public UpperBoundComplementEvaluator(TSignature s) {
        super(s);
    }

    @Override
    public void visit(ConceptTop c) {
        this.value = this.getAllValue();
    }

    @Override
    public void visit(ConceptBottom c) {
        this.value = this.getNoneValue();
    }

    @Override
    public void visit(ConceptNot expr) {
        this.value = this.getUpperBoundDirect(expr.getConcept());
    }

    @Override
    public void visit(ConceptAnd expr) {
        this.value = this.getAndValue(expr);
    }

    @Override
    public void visit(ConceptOr expr) {
        this.value = this.getOrValue(expr);
    }

    @Override
    public void visit(ConceptOneOf<?> c) {
        this.value = this.getNoneValue();
    }

    @Override
    public void visit(ConceptObjectSelf expr) {
        this.value = this.isTopEquivalent(expr.getOR()) ? this.getAllValue() : this.getNoneValue();
    }

    @Override
    public void visit(ConceptObjectValue expr) {
        this.value = this.isTopEquivalent(expr.getOR()) ? this.getAllValue() : this.getNoneValue();
    }

    @Override
    public void visit(ConceptDataValue expr) {
        this.value = this.isTopEquivalent(expr.getDataRoleExpression()) ? this.getAllValue() : this.getNoneValue();
    }

    @Override
    public void visit(ObjectRoleTop c) {
        this.value = this.getAllValue();
    }

    @Override
    public void visit(ObjectRoleBottom c) {
        this.value = this.getNoneValue();
    }

    @Override
    public void visit(ObjectRoleInverse expr) {
        this.value = this.getUpperBoundComplement(expr.getOR());
    }

    @Override
    public void visit(ObjectRoleChain expr) {
        for (ObjectRoleExpression p : expr.getArguments()) {
            if (this.isTopEquivalent(p)) continue;
            this.value = this.getNoneValue();
            return;
        }
        this.value = this.getAllValue();
    }

    @Override
    public void visit(DataRoleTop c) {
        this.value = this.getAllValue();
    }

    @Override
    public void visit(DataRoleBottom c) {
        this.value = this.getNoneValue();
    }

    @Override
    public void visit(DataTop c) {
        this.value = this.getAllValue();
    }

    @Override
    public void visit(DataBottom c) {
        this.value = this.getNoneValue();
    }

    @Override
    public void visit(Datatype<?> c) {
        this.value = this.getNoneValue();
    }

    @Override
    public void visit(DatatypeExpression<?> c) {
        this.value = this.getNoneValue();
    }

    @Override
    public void visit(Literal<?> c) {
        this.value = this.getNoneValue();
    }

    @Override
    public void visit(DataNot expr) {
        this.value = this.getUpperBoundDirect(expr.getExpr());
    }

    @Override
    public void visit(DataAnd expr) {
        this.value = this.getAndValue(expr);
    }

    @Override
    public void visit(DataOr expr) {
        this.value = this.getOrValue(expr);
    }

    @Override
    public void visit(DataOneOf c) {
        this.value = this.getNoneValue();
    }
}

