/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import gnu.trove.map.hash.THashMap;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.io.RDFLiteral;
import org.semanticweb.owlapi.io.RDFNode;
import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.io.RDFResourceBlankNode;
import org.semanticweb.owlapi.io.RDFResourceIRI;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class RDFTriple
implements Serializable,
Comparable<RDFTriple> {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final RDFResource subject;
    @Nonnull
    private final RDFResourceIRI predicate;
    @Nonnull
    private final RDFNode object;
    private static final List<IRI> ORDERED_URIS = Arrays.asList(OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.RDFS_LABEL.getIRI(), OWLRDFVocabulary.OWL_DEPRECATED.getIRI(), OWLRDFVocabulary.RDFS_COMMENT.getIRI(), OWLRDFVocabulary.RDFS_IS_DEFINED_BY.getIRI(), OWLRDFVocabulary.RDF_FIRST.getIRI(), OWLRDFVocabulary.RDF_REST.getIRI(), OWLRDFVocabulary.OWL_EQUIVALENT_CLASS.getIRI(), OWLRDFVocabulary.OWL_EQUIVALENT_PROPERTY.getIRI(), OWLRDFVocabulary.RDFS_SUBCLASS_OF.getIRI(), OWLRDFVocabulary.RDFS_SUB_PROPERTY_OF.getIRI(), OWLRDFVocabulary.RDFS_DOMAIN.getIRI(), OWLRDFVocabulary.RDFS_RANGE.getIRI(), OWLRDFVocabulary.OWL_DISJOINT_WITH.getIRI(), OWLRDFVocabulary.OWL_ON_PROPERTY.getIRI(), OWLRDFVocabulary.OWL_DATA_RANGE.getIRI(), OWLRDFVocabulary.OWL_ON_CLASS.getIRI(), OWLRDFVocabulary.OWL_ANNOTATED_SOURCE.getIRI(), OWLRDFVocabulary.OWL_ANNOTATED_PROPERTY.getIRI(), OWLRDFVocabulary.OWL_ANNOTATED_TARGET.getIRI());
    static final THashMap<IRI, Integer> specialPredicateRanks = new THashMap();

    public RDFTriple(@Nonnull RDFResource subject, @Nonnull RDFResourceIRI predicate, @Nonnull RDFNode object) {
        this.subject = OWLAPIPreconditions.checkNotNull(subject, "subject cannot be null");
        this.predicate = OWLAPIPreconditions.checkNotNull(predicate, "predicate cannot be null");
        this.object = OWLAPIPreconditions.checkNotNull(object, "object cannot be null");
    }

    public RDFTriple(@Nonnull IRI subject, boolean subjectAnon, @Nonnull IRI predicate, @Nonnull IRI object, boolean objectAnon) {
        this(RDFTriple.getResource(subject, subjectAnon), new RDFResourceIRI(predicate), RDFTriple.getResource(object, objectAnon));
    }

    @Nonnull
    private static RDFResource getResource(@Nonnull IRI iri, boolean anon) {
        if (anon) {
            return new RDFResourceBlankNode(iri);
        }
        return new RDFResourceIRI(iri);
    }

    public RDFTriple(@Nonnull IRI subject, boolean subjectAnon, @Nonnull IRI predicate, @Nonnull OWLLiteral object) {
        this(RDFTriple.getResource(subject, subjectAnon), new RDFResourceIRI(predicate), new RDFLiteral(object));
    }

    @Nonnull
    public RDFResource getSubject() {
        return this.subject;
    }

    @Nonnull
    public RDFResourceIRI getPredicate() {
        return this.predicate;
    }

    @Nonnull
    public RDFNode getObject() {
        return this.object;
    }

    public int hashCode() {
        return this.subject.hashCode() * 37 + this.predicate.hashCode() * 17 + this.object.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RDFTriple)) {
            return false;
        }
        RDFTriple other = (RDFTriple)obj;
        return this.subject.equals(other.subject) && this.predicate.equals(other.predicate) && this.object.equals(other.object);
    }

    public String toString() {
        return String.format("%s %s %s.", this.subject, this.predicate, this.object);
    }

    @Override
    public int compareTo(RDFTriple o) {
        int diff = RDFTriple.comparePredicates(this.predicate, o.predicate);
        if (diff == 0) {
            diff = this.subject.compareTo(o.subject);
        }
        if (diff == 0) {
            diff = this.object.compareTo(o.object);
        }
        return diff;
    }

    private static int comparePredicates(RDFResourceIRI predicate, RDFResourceIRI otherPredicate) {
        IRI predicateIRI = predicate.getIRI();
        Integer specialPredicateRank = (Integer)specialPredicateRanks.get((Object)predicateIRI);
        IRI otherPredicateIRI = otherPredicate.getIRI();
        Integer otherSpecialPredicateRank = (Integer)specialPredicateRanks.get((Object)otherPredicateIRI);
        if (specialPredicateRank != null) {
            if (otherSpecialPredicateRank != null) {
                return specialPredicateRank - otherSpecialPredicateRank;
            }
            return -1;
        }
        if (otherSpecialPredicateRank != null) {
            return 1;
        }
        return predicateIRI.compareTo(otherPredicateIRI);
    }

    static {
        int nextId = 1;
        for (int i = 0; i < ORDERED_URIS.size(); ++i) {
            specialPredicateRanks.put((Object)ORDERED_URIS.get(i), (Object)nextId++);
        }
        for (OWLRDFVocabulary vocabulary : OWLRDFVocabulary.values()) {
            IRI iri = vocabulary.getIRI();
            if (specialPredicateRanks.containsKey((Object)iri)) continue;
            specialPredicateRanks.put((Object)iri, (Object)nextId++);
        }
    }
}

