/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.dlsyntax.renderer;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.dlsyntax.renderer.DLSyntaxObjectRenderer;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.util.AbstractOWLStorer;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public abstract class DLSyntaxStorerBase
extends AbstractOWLStorer {
    private static final long serialVersionUID = 40000L;

    @Override
    protected void storeOntology(@Nonnull OWLOntology ontology, Writer writer, OWLDocumentFormat format) {
        OWLAPIPreconditions.checkNotNull(ontology, "ontology cannot be null");
        PrintWriter printWriter = new PrintWriter(OWLAPIPreconditions.checkNotNull(writer, "writer cannot be null"));
        this.beginWritingOntology(ontology, printWriter);
        for (OWLObjectProperty oWLObjectProperty : new TreeSet<OWLObjectProperty>(ontology.getObjectPropertiesInSignature())) {
            assert (oWLObjectProperty != null);
            this.write(ontology, oWLObjectProperty, ontology.getAxioms((OWLObjectPropertyExpression)oWLObjectProperty, Imports.EXCLUDED), printWriter);
        }
        for (OWLDataProperty oWLDataProperty : new TreeSet<OWLDataProperty>(ontology.getDataPropertiesInSignature())) {
            assert (oWLDataProperty != null);
            this.write(ontology, oWLDataProperty, ontology.getAxioms(oWLDataProperty, Imports.EXCLUDED), printWriter);
        }
        for (OWLClass oWLClass : new TreeSet<OWLClass>(ontology.getClassesInSignature())) {
            assert (oWLClass != null);
            this.write(ontology, oWLClass, ontology.getAxioms(oWLClass, Imports.EXCLUDED), printWriter);
        }
        for (OWLNamedIndividual oWLNamedIndividual : new TreeSet<OWLNamedIndividual>(ontology.getIndividualsInSignature())) {
            assert (oWLNamedIndividual != null);
            this.write(ontology, oWLNamedIndividual, ontology.getAxioms((OWLIndividual)oWLNamedIndividual, Imports.EXCLUDED), printWriter);
        }
        this.beginWritingGeneralAxioms(ontology.getGeneralClassAxioms(), printWriter);
        for (OWLAxiom oWLAxiom : ontology.getGeneralClassAxioms()) {
            assert (oWLAxiom != null);
            this.beginWritingAxiom(oWLAxiom, printWriter);
            this.writeAxiom(null, oWLAxiom, printWriter);
            this.endWritingAxiom(oWLAxiom, printWriter);
        }
        this.endWritingGeneralAxioms(ontology.getGeneralClassAxioms(), printWriter);
        this.endWritingOntology(ontology, printWriter);
        printWriter.flush();
    }

    private void write(@Nonnull OWLOntology ont, @Nonnull OWLEntity entity, @Nonnull Set<? extends OWLAxiom> axioms, @Nonnull PrintWriter writer) {
        this.beginWritingAxioms(entity, axioms, writer);
        for (OWLAxiom oWLAxiom : new TreeSet<OWLAxiom>(axioms)) {
            assert (oWLAxiom != null);
            this.beginWritingAxiom(oWLAxiom, writer);
            this.writeAxiom(entity, oWLAxiom, writer);
            this.endWritingAxiom(oWLAxiom, writer);
        }
        TreeSet<OWLAxiom> usages = new TreeSet<OWLAxiom>(ont.getReferencingAxioms((OWLPrimitive)entity, Imports.EXCLUDED));
        usages.removeAll(axioms);
        this.beginWritingUsage(entity, usages, writer);
        for (OWLAxiom usage : usages) {
            assert (usage != null);
            if (axioms.contains(usage)) continue;
            this.beginWritingAxiom(usage, writer);
            this.writeAxiom(entity, usage, writer);
            this.endWritingAxiom(usage, writer);
        }
        this.endWritingUsage(entity, usages, writer);
        this.endWritingAxioms(entity, axioms, writer);
    }

    protected void writeAxiom(@Nullable OWLEntity subject, @Nonnull OWLAxiom axiom, @Nonnull PrintWriter writer) {
        writer.write(this.getRendering(subject, axiom));
    }

    @Nonnull
    protected String getRendering(@Nullable OWLEntity subject, @Nonnull OWLAxiom axiom) {
        DLSyntaxObjectRenderer ren = new DLSyntaxObjectRenderer();
        return ren.render(axiom);
    }

    protected void beginWritingOntology(@Nonnull OWLOntology ontology, @Nonnull PrintWriter writer) {
    }

    protected void endWritingOntology(@Nonnull OWLOntology ontology, @Nonnull PrintWriter writer) {
    }

    protected void beginWritingAxiom(@Nonnull OWLAxiom axiom, @Nonnull PrintWriter writer) {
    }

    protected void endWritingAxiom(@Nonnull OWLAxiom axiom, @Nonnull PrintWriter writer) {
    }

    protected void beginWritingAxioms(@Nonnull OWLEntity subject, @Nonnull Set<? extends OWLAxiom> axioms, @Nonnull PrintWriter writer) {
    }

    protected void endWritingAxioms(@Nonnull OWLEntity subject, @Nonnull Set<? extends OWLAxiom> axioms, @Nonnull PrintWriter writer) {
    }

    protected void beginWritingUsage(@Nonnull OWLEntity subject, @Nonnull Set<? extends OWLAxiom> axioms, @Nonnull PrintWriter writer) {
    }

    protected void endWritingUsage(@Nonnull OWLEntity subject, @Nonnull Set<? extends OWLAxiom> axioms, @Nonnull PrintWriter writer) {
    }

    protected void beginWritingGeneralAxioms(@Nonnull Set<? extends OWLAxiom> axioms, @Nonnull PrintWriter writer) {
    }

    protected void endWritingGeneralAxioms(@Nonnull Set<? extends OWLAxiom> axioms, @Nonnull PrintWriter writer) {
    }
}

