/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.UnsupportedOptionsException;
import org.tukaani.xz.XZOutputStream;

public class XZStreamDocumentTarget
implements OWLOntologyDocumentTarget,
AutoCloseable {
    private final OutputStream outputStream;
    private XZOutputStream xzOutputStream;
    private FilterOptions[] filterOptions;

    public XZStreamDocumentTarget(OutputStream os, FilterOptions ... filterOptions) {
        this.outputStream = os;
        if (filterOptions.length == 0) {
            filterOptions = new FilterOptions[]{new LZMA2Options()};
        }
        this.filterOptions = filterOptions;
    }

    public XZStreamDocumentTarget(OutputStream os, int presetLevel) throws UnsupportedOptionsException {
        this(os, new LZMA2Options(presetLevel));
    }

    @Override
    public boolean isWriterAvailable() {
        return this.isOutputStreamAvailable();
    }

    @Override
    @Nonnull
    public Writer getWriter() {
        if (!this.isWriterAvailable()) {
            throw new UnsupportedOperationException("writer not available; check with isWriterAvailable() first.");
        }
        return new OutputStreamWriter(this.getOutputStream());
    }

    @Override
    public boolean isOutputStreamAvailable() {
        return true;
    }

    @Override
    @Nonnull
    public OutputStream getOutputStream() {
        if (this.xzOutputStream == null) {
            try {
                this.xzOutputStream = new XZOutputStream(this.outputStream, this.filterOptions);
            }
            catch (IOException e) {
                throw new OWLRuntimeException(e);
            }
        }
        return OWLAPIPreconditions.verifyNotNull(this.xzOutputStream);
    }

    @Override
    public boolean isDocumentIRIAvailable() {
        return false;
    }

    @Override
    @Nonnull
    public IRI getDocumentIRI() {
        throw new UnsupportedOperationException("iri not available; check with isDocumentIRIAvailable() first");
    }

    @Override
    public void close() throws Exception {
        XZOutputStream xzOutputStream = this.xzOutputStream;
        this.xzOutputStream = null;
        Closeables.close((Closeable)xzOutputStream, (boolean)false);
    }
}

