/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.manchestersyntax.renderer;

import com.google.common.base.Optional;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.io.OWLRendererException;
import org.semanticweb.owlapi.manchestersyntax.parser.ManchesterOWLSyntax;
import org.semanticweb.owlapi.manchestersyntax.renderer.ManchesterOWLSyntaxObjectRenderer;
import org.semanticweb.owlapi.manchestersyntax.renderer.ManchesterOWLSyntaxPrefixNameShortFormProvider;
import org.semanticweb.owlapi.manchestersyntax.renderer.RendererEvent;
import org.semanticweb.owlapi.manchestersyntax.renderer.RendererListener;
import org.semanticweb.owlapi.manchestersyntax.renderer.RenderingDirector;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAxiomFilter;
import org.semanticweb.owlapi.util.OWLObjectComparator;
import org.semanticweb.owlapi.util.OntologyIRIShortFormProvider;
import org.semanticweb.owlapi.util.ShortFormProvider;

public class ManchesterOWLSyntaxFrameRenderer
extends ManchesterOWLSyntaxObjectRenderer
implements OWLEntityVisitor {
    private final Set<OWLOntology> ontologies;
    private OntologyIRIShortFormProvider shortFormProvider = new OntologyIRIShortFormProvider();
    @Nonnull
    private final Set<AxiomType<?>> filteredAxiomTypes = ManchesterOWLSyntaxFrameRenderer.filtered();
    private boolean renderExtensions = false;
    @Nonnull
    private final List<RendererListener> listeners = new ArrayList<RendererListener>();
    private OWLAxiomFilter axiomFilter = new OWLAxiomFilter(){

        @Override
        public boolean passes(OWLAxiom axiom) {
            return true;
        }
    };
    private RenderingDirector renderingDirector = new DefaultRenderingDirector();
    @Nonnull
    private final OWLObjectComparator owlObjectComparator;
    private RendererEvent event;

    private static Set<AxiomType<?>> filtered() {
        HashSet set = new HashSet();
        set.add(AxiomType.SWRL_RULE);
        return set;
    }

    public ManchesterOWLSyntaxFrameRenderer(@Nonnull OWLOntology ontology, @Nonnull Writer writer, @Nonnull ShortFormProvider entityShortFormProvider) {
        this(CollectionFactory.createSet(ontology), writer, entityShortFormProvider);
    }

    public ManchesterOWLSyntaxFrameRenderer(@Nonnull Set<OWLOntology> ontologies, Writer writer, @Nonnull ShortFormProvider entityShortFormProvider) {
        super(writer, entityShortFormProvider);
        this.ontologies = new LinkedHashSet<OWLOntology>(ontologies);
        this.owlObjectComparator = new OWLObjectComparator(entityShortFormProvider);
    }

    public void setRenderingDirector(RenderingDirector renderingDirector) {
        this.renderingDirector = renderingDirector;
    }

    public void setOntologyIRIShortFormProvider(OntologyIRIShortFormProvider shortFormProvider) {
        this.shortFormProvider = shortFormProvider;
    }

    public void addRendererListener(RendererListener listener) {
        this.listeners.add(listener);
    }

    public void removeRendererListener(RendererListener listener) {
        this.listeners.remove(listener);
    }

    public void setAxiomFilter(OWLAxiomFilter axiomFilter) {
        this.axiomFilter = axiomFilter;
    }

    public void clearFilteredAxiomTypes() {
        this.filteredAxiomTypes.clear();
    }

    public void addFilteredAxiomType(AxiomType<?> axiomType) {
        this.filteredAxiomTypes.add(axiomType);
    }

    public void setRenderExtensions(boolean renderExtensions) {
        this.renderExtensions = renderExtensions;
    }

    public void writeOntology() throws OWLRendererException {
        SectionMap<Object, OWLAxiom> map;
        if (this.ontologies.size() != 1) {
            throw new OWLRuntimeException("Can only render one ontology");
        }
        OWLOntology ontology = this.ontologies.iterator().next();
        assert (ontology != null);
        this.writePrefixMap();
        this.writeNewLine();
        this.writeOntologyHeader(ontology);
        for (OWLAnnotationProperty oWLAnnotationProperty : ontology.getAnnotationPropertiesInSignature(Imports.EXCLUDED)) {
            assert (oWLAnnotationProperty != null);
            this.write(oWLAnnotationProperty);
        }
        for (OWLDatatype oWLDatatype : ontology.getDatatypesInSignature()) {
            assert (oWLDatatype != null);
            this.write(oWLDatatype);
        }
        for (OWLObjectProperty oWLObjectProperty : ontology.getObjectPropertiesInSignature()) {
            assert (oWLObjectProperty != null);
            this.write(oWLObjectProperty);
            OWLObjectPropertyExpression invProp = oWLObjectProperty.getInverseProperty();
            if (ontology.getAxioms(invProp, Imports.EXCLUDED).isEmpty()) continue;
            this.write(invProp);
        }
        for (OWLDataProperty oWLDataProperty : ontology.getDataPropertiesInSignature()) {
            assert (oWLDataProperty != null);
            this.write(oWLDataProperty);
        }
        for (OWLClass oWLClass : ontology.getClassesInSignature()) {
            assert (oWLClass != null);
            this.write(oWLClass);
        }
        for (OWLNamedIndividual oWLNamedIndividual : ontology.getIndividualsInSignature()) {
            assert (oWLNamedIndividual != null);
            this.write(oWLNamedIndividual);
        }
        for (OWLAnonymousIndividual oWLAnonymousIndividual : ontology.getReferencedAnonymousIndividuals(Imports.EXCLUDED)) {
            assert (oWLAnonymousIndividual != null);
            this.write(oWLAnonymousIndividual);
        }
        this.event = new RendererEvent(this, ontology);
        for (OWLDisjointClassesAxiom oWLDisjointClassesAxiom : ontology.getAxioms(AxiomType.DISJOINT_CLASSES)) {
            if (oWLDisjointClassesAxiom.getClassExpressions().size() <= 2) continue;
            map = new SectionMap<Object, OWLAxiom>();
            map.put(oWLDisjointClassesAxiom.getClassExpressions(), oWLDisjointClassesAxiom);
            this.writeSection(ManchesterOWLSyntax.DISJOINT_CLASSES, map, ",", false, ontology);
        }
        for (OWLEquivalentClassesAxiom oWLEquivalentClassesAxiom : ontology.getAxioms(AxiomType.EQUIVALENT_CLASSES)) {
            if (oWLEquivalentClassesAxiom.getClassExpressions().size() <= 2) continue;
            map = new SectionMap();
            map.put(oWLEquivalentClassesAxiom.getClassExpressions(), oWLEquivalentClassesAxiom);
            this.writeSection(ManchesterOWLSyntax.EQUIVALENT_CLASSES, map, ",", false, ontology);
        }
        for (OWLDisjointObjectPropertiesAxiom oWLDisjointObjectPropertiesAxiom : ontology.getAxioms(AxiomType.DISJOINT_OBJECT_PROPERTIES)) {
            if (oWLDisjointObjectPropertiesAxiom.getProperties().size() <= 2) continue;
            map = new SectionMap();
            map.put(oWLDisjointObjectPropertiesAxiom.getProperties(), oWLDisjointObjectPropertiesAxiom);
            this.writeSection(ManchesterOWLSyntax.DISJOINT_PROPERTIES, map, ",", false, ontology);
        }
        for (OWLEquivalentObjectPropertiesAxiom oWLEquivalentObjectPropertiesAxiom : ontology.getAxioms(AxiomType.EQUIVALENT_OBJECT_PROPERTIES)) {
            if (oWLEquivalentObjectPropertiesAxiom.getProperties().size() <= 2) continue;
            map = new SectionMap();
            map.put(oWLEquivalentObjectPropertiesAxiom.getProperties(), oWLEquivalentObjectPropertiesAxiom);
            this.writeSection(ManchesterOWLSyntax.EQUIVALENT_PROPERTIES, map, ",", false, ontology);
        }
        for (OWLDisjointDataPropertiesAxiom oWLDisjointDataPropertiesAxiom : ontology.getAxioms(AxiomType.DISJOINT_DATA_PROPERTIES)) {
            if (oWLDisjointDataPropertiesAxiom.getProperties().size() <= 2) continue;
            map = new SectionMap();
            map.put(oWLDisjointDataPropertiesAxiom.getProperties(), oWLDisjointDataPropertiesAxiom);
            this.writeSection(ManchesterOWLSyntax.DISJOINT_PROPERTIES, map, ",", false, ontology);
        }
        for (OWLEquivalentDataPropertiesAxiom oWLEquivalentDataPropertiesAxiom : ontology.getAxioms(AxiomType.EQUIVALENT_DATA_PROPERTIES)) {
            if (oWLEquivalentDataPropertiesAxiom.getProperties().size() <= 2) continue;
            map = new SectionMap();
            map.put(oWLEquivalentDataPropertiesAxiom.getProperties(), oWLEquivalentDataPropertiesAxiom);
            this.writeSection(ManchesterOWLSyntax.EQUIVALENT_PROPERTIES, map, ",", false, ontology);
        }
        for (OWLDifferentIndividualsAxiom oWLDifferentIndividualsAxiom : ontology.getAxioms(AxiomType.DIFFERENT_INDIVIDUALS)) {
            if (oWLDifferentIndividualsAxiom.getIndividuals().size() <= 2) continue;
            map = new SectionMap();
            map.put(oWLDifferentIndividualsAxiom.getIndividuals(), oWLDifferentIndividualsAxiom);
            this.writeSection(ManchesterOWLSyntax.DIFFERENT_INDIVIDUALS, map, ",", false, ontology);
        }
        for (SWRLRule sWRLRule : ontology.getAxioms(AxiomType.SWRL_RULE)) {
            Set<SWRLRule> singleton = Collections.singleton(sWRLRule);
            this.writeSection(ManchesterOWLSyntax.RULE, singleton, ", ", false, new OWLOntology[0]);
        }
        this.flush();
    }

    public void writeOntologyHeader(@Nonnull OWLOntology ontology) {
        this.event = new RendererEvent(this, ontology);
        this.fireFrameRenderingPrepared(ManchesterOWLSyntax.ONTOLOGY.toString());
        this.write(ManchesterOWLSyntax.ONTOLOGY.toString());
        this.write(":");
        this.writeSpace();
        if (!ontology.isAnonymous()) {
            int indent = this.getIndent();
            this.writeFullURI(((IRI)ontology.getOntologyID().getOntologyIRI().get()).toString());
            this.writeNewLine();
            this.pushTab(indent);
            Optional<IRI> versionIRI = ontology.getOntologyID().getVersionIRI();
            if (versionIRI.isPresent()) {
                this.writeFullURI(((IRI)versionIRI.get()).toString());
            }
            this.popTab();
        }
        this.fireFrameRenderingStarted(ManchesterOWLSyntax.ONTOLOGY.toString());
        this.writeNewLine();
        for (OWLImportsDeclaration decl : ontology.getImportsDeclarations()) {
            this.fireSectionItemPrepared(ManchesterOWLSyntax.IMPORT.toString());
            this.write(ManchesterOWLSyntax.IMPORT.toString());
            this.write(":");
            this.writeSpace();
            this.fireSectionRenderingStarted(ManchesterOWLSyntax.IMPORT.toString());
            this.writeFullURI(decl.getIRI().toString());
            this.writeNewLine();
            this.fireSectionRenderingFinished(ManchesterOWLSyntax.IMPORT.toString());
        }
        this.writeNewLine();
        this.writeSection(ManchesterOWLSyntax.ANNOTATIONS, ontology.getAnnotations(), ",", true, new OWLOntology[0]);
        this.fireFrameRenderingFinished(ManchesterOWLSyntax.ONTOLOGY.toString());
    }

    public void writePrefixMap() {
        ShortFormProvider sfp = this.getShortFormProvider();
        if (!(sfp instanceof ManchesterOWLSyntaxPrefixNameShortFormProvider)) {
            return;
        }
        ManchesterOWLSyntaxPrefixNameShortFormProvider prov = (ManchesterOWLSyntaxPrefixNameShortFormProvider)sfp;
        Map<String, String> prefixMap = prov.getPrefixName2PrefixMap();
        for (Map.Entry<String, String> e : prefixMap.entrySet()) {
            this.write(ManchesterOWLSyntax.PREFIX.toString());
            this.write(": ");
            this.write(e.getKey());
            this.write(" ");
            this.writeFullURI(e.getValue());
            this.writeNewLine();
        }
        if (!prefixMap.isEmpty()) {
            this.writeNewLine();
            this.writeNewLine();
        }
    }

    public void writeFullURI(String uri) {
        this.write("<");
        this.write(uri);
        this.write(">");
    }

    public boolean isFiltered(AxiomType<?> axiomType) {
        return this.filteredAxiomTypes.contains(axiomType);
    }

    public boolean isDisplayed(@Nullable OWLAxiom axiom) {
        if (axiom == null) {
            return false;
        }
        return this.axiomFilter.passes(axiom);
    }

    public Set<OWLAxiom> writeFrame(@Nonnull OWLEntity entity) {
        if (entity.isOWLClass()) {
            return this.write(entity.asOWLClass());
        }
        if (entity.isOWLObjectProperty()) {
            return this.write(entity.asOWLObjectProperty());
        }
        if (entity.isOWLDataProperty()) {
            return this.write(entity.asOWLDataProperty());
        }
        if (entity.isOWLNamedIndividual()) {
            return this.write(entity.asOWLNamedIndividual());
        }
        if (entity.isOWLAnnotationProperty()) {
            return this.write(entity.asOWLAnnotationProperty());
        }
        if (entity.isOWLDatatype()) {
            return this.write(entity.asOWLDatatype());
        }
        return CollectionFactory.emptySet();
    }

    @Nonnull
    public Set<OWLAxiom> write(@Nonnull OWLClass cls) {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.CLASS, cls));
        if (!this.isFiltered(AxiomType.EQUIVALENT_CLASSES)) {
            for (OWLOntology ontology : this.ontologies) {
                SectionMap<Object, OWLAxiom> equivalentClasses = new SectionMap<Object, OWLAxiom>();
                for (OWLEquivalentClassesAxiom oWLEquivalentClassesAxiom : ontology.getEquivalentClassesAxioms(cls)) {
                    if (oWLEquivalentClassesAxiom.getClassExpressions().size() != 2 || !this.isDisplayed(oWLEquivalentClassesAxiom)) continue;
                    for (OWLClassExpression equivCls : oWLEquivalentClassesAxiom.getClassExpressionsMinus(cls)) {
                        equivalentClasses.put(equivCls, oWLEquivalentClassesAxiom);
                    }
                    axioms.add(oWLEquivalentClassesAxiom);
                }
                equivalentClasses.remove(cls);
                this.writeSection(ManchesterOWLSyntax.EQUIVALENT_TO, equivalentClasses, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.SUBCLASS_OF)) {
            for (OWLOntology ontology : this.ontologies) {
                SectionMap<Object, OWLAxiom> superclasses = new SectionMap<Object, OWLAxiom>();
                for (OWLSubClassOfAxiom oWLSubClassOfAxiom : ontology.getSubClassAxiomsForSubClass(cls)) {
                    if (!this.isDisplayed(oWLSubClassOfAxiom)) continue;
                    superclasses.put(oWLSubClassOfAxiom.getSuperClass(), oWLSubClassOfAxiom);
                    axioms.add(oWLSubClassOfAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.SUBCLASS_OF, superclasses, ",", true, ontology);
            }
            if (this.renderExtensions) {
                for (OWLOntology ont : this.ontologies) {
                    SectionMap subClasses = new SectionMap();
                    for (OWLSubClassOfAxiom oWLSubClassOfAxiom : ont.getSubClassAxiomsForSuperClass(cls)) {
                        if (!this.isDisplayed(oWLSubClassOfAxiom)) continue;
                        subClasses.put(oWLSubClassOfAxiom.getSubClass(), oWLSubClassOfAxiom);
                        axioms.add(oWLSubClassOfAxiom);
                    }
                    this.writeSection(ManchesterOWLSyntax.SUPERCLASS_OF, subClasses, ",", true, ont);
                }
            }
        }
        if (!this.isFiltered(AxiomType.DISJOINT_UNION)) {
            for (OWLOntology ontology : this.ontologies) {
                for (OWLDisjointUnionAxiom oWLDisjointUnionAxiom : ontology.getDisjointUnionAxioms(cls)) {
                    if (!this.isDisplayed(oWLDisjointUnionAxiom)) continue;
                    Collection<OWLClassExpression> collection = this.sortedCollection(oWLDisjointUnionAxiom.getClassExpressions());
                    axioms.add(oWLDisjointUnionAxiom);
                    this.writeSection(ManchesterOWLSyntax.DISJOINT_UNION_OF, collection, ", ", false, ontology);
                }
            }
        }
        if (!this.isFiltered(AxiomType.DISJOINT_CLASSES)) {
            for (OWLOntology ontology : this.ontologies) {
                SectionMap disjointClasses = new SectionMap();
                for (OWLDisjointClassesAxiom oWLDisjointClassesAxiom : ontology.getDisjointClassesAxioms(cls)) {
                    if (!this.isDisplayed(oWLDisjointClassesAxiom)) continue;
                    if (oWLDisjointClassesAxiom.getClassExpressions().size() == 2) {
                        OWLClassExpression disjointWith = oWLDisjointClassesAxiom.getClassExpressionsMinus(cls).iterator().next();
                        disjointClasses.put(disjointWith, oWLDisjointClassesAxiom);
                    }
                    axioms.add(oWLDisjointClassesAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.DISJOINT_WITH, disjointClasses, ", ", false, ontology);
                if (!this.renderExtensions) continue;
                for (OWLDisjointClassesAxiom oWLDisjointClassesAxiom : ontology.getDisjointClassesAxioms(cls)) {
                    if (!this.isDisplayed(oWLDisjointClassesAxiom) || oWLDisjointClassesAxiom.getClassExpressions().size() <= 2) continue;
                    Collection<OWLClassExpression> allDisjointClasses = this.sortedCollection(oWLDisjointClassesAxiom.getClassExpressions());
                    axioms.add(oWLDisjointClassesAxiom);
                    this.writeSection(ManchesterOWLSyntax.DISJOINT_CLASSES, allDisjointClasses, ", ", false, ontology);
                }
            }
        }
        if (!this.isFiltered(AxiomType.HAS_KEY)) {
            for (OWLOntology ontology : this.ontologies) {
                for (OWLHasKeyAxiom oWLHasKeyAxiom : ontology.getHasKeyAxioms(cls)) {
                    if (!this.isDisplayed(oWLHasKeyAxiom)) continue;
                    SectionMap<Object, OWLAxiom> sectionMap = new SectionMap<Object, OWLAxiom>();
                    sectionMap.put(oWLHasKeyAxiom.getPropertyExpressions(), oWLHasKeyAxiom);
                    this.writeSection(ManchesterOWLSyntax.HAS_KEY, sectionMap, ", ", true, ontology);
                }
            }
        }
        if (!this.isFiltered(AxiomType.CLASS_ASSERTION)) {
            for (OWLOntology ontology : this.ontologies) {
                SectionMap<Object, OWLAxiom> individuals = new SectionMap<Object, OWLAxiom>();
                for (OWLClassAssertionAxiom oWLClassAssertionAxiom : ontology.getClassAssertionAxioms(cls)) {
                    if (!this.isDisplayed(oWLClassAssertionAxiom) || !this.renderExtensions && !oWLClassAssertionAxiom.getIndividual().isAnonymous()) continue;
                    individuals.put(oWLClassAssertionAxiom.getIndividual(), oWLClassAssertionAxiom);
                    axioms.add(oWLClassAssertionAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.INDIVIDUALS, individuals, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.SWRL_RULE)) {
            for (OWLOntology ontology : this.ontologies) {
                HashSet rules = new HashSet();
                block17: for (SWRLRule sWRLRule : ontology.getAxioms(AxiomType.SWRL_RULE)) {
                    if (!this.isDisplayed(sWRLRule)) continue;
                    for (SWRLAtom atom : sWRLRule.getHead()) {
                        if (!atom.getPredicate().equals(cls)) continue;
                        this.writeSection(ManchesterOWLSyntax.RULE, rules, ", ", true, ontology);
                        continue block17;
                    }
                }
            }
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.CLASS.toString());
        return axioms;
    }

    protected void writeEntitySectionEnd(String type) {
        this.fireFrameRenderingFinished(type);
        this.popTab();
        this.writeNewLine();
    }

    @Nonnull
    public Set<OWLAxiom> write(@Nonnull OWLObjectPropertyExpression property) {
        SectionMap<Object, OWLAxiom> expressions;
        Set<OWLObjectPropertyExpression> props;
        Collection<OWLObjectPropertyExpression> properties;
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.OBJECT_PROPERTY, property));
        if (!this.isFiltered(AxiomType.SUB_OBJECT_PROPERTY)) {
            for (OWLOntology ontology : this.ontologies) {
                properties = new SectionMap<Object, OWLAxiom>();
                for (OWLSubObjectPropertyOfAxiom oWLSubObjectPropertyOfAxiom : ontology.getObjectSubPropertyAxiomsForSubProperty(property)) {
                    if (!this.isDisplayed(oWLSubObjectPropertyOfAxiom)) continue;
                    ((SectionMap)((Object)properties)).put(oWLSubObjectPropertyOfAxiom.getSuperProperty(), oWLSubObjectPropertyOfAxiom);
                    axioms.add(oWLSubObjectPropertyOfAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.SUB_PROPERTY_OF, (SectionMap<Object, OWLAxiom>)((Object)properties), ",", true, ontology);
            }
            if (this.renderExtensions) {
                for (OWLOntology ontology : this.ontologies) {
                    properties = new SectionMap();
                    for (OWLSubObjectPropertyOfAxiom oWLSubObjectPropertyOfAxiom : ontology.getObjectSubPropertyAxiomsForSuperProperty(property)) {
                        if (!this.isDisplayed(oWLSubObjectPropertyOfAxiom)) continue;
                        ((SectionMap)((Object)properties)).put(oWLSubObjectPropertyOfAxiom.getSubProperty(), oWLSubObjectPropertyOfAxiom);
                        axioms.add(oWLSubObjectPropertyOfAxiom);
                    }
                    this.writeSection(ManchesterOWLSyntax.SUPER_PROPERTY_OF, (SectionMap<Object, OWLAxiom>)((Object)properties), ",", true, ontology);
                }
            }
        }
        if (!this.isFiltered(AxiomType.EQUIVALENT_OBJECT_PROPERTIES)) {
            for (OWLOntology ontology : this.ontologies) {
                properties = new SectionMap();
                for (OWLEquivalentObjectPropertiesAxiom oWLEquivalentObjectPropertiesAxiom : ontology.getEquivalentObjectPropertiesAxioms(property)) {
                    if (!this.isDisplayed(oWLEquivalentObjectPropertiesAxiom) || oWLEquivalentObjectPropertiesAxiom.getProperties().size() != 2) continue;
                    props = oWLEquivalentObjectPropertiesAxiom.getPropertiesMinus(property);
                    ((SectionMap)((Object)properties)).put(props.iterator().next(), oWLEquivalentObjectPropertiesAxiom);
                    axioms.add(oWLEquivalentObjectPropertiesAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.EQUIVALENT_TO, (SectionMap<Object, OWLAxiom>)((Object)properties), ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.DISJOINT_OBJECT_PROPERTIES)) {
            for (OWLOntology ontology : this.ontologies) {
                properties = new SectionMap();
                for (OWLDisjointObjectPropertiesAxiom oWLDisjointObjectPropertiesAxiom : ontology.getDisjointObjectPropertiesAxioms(property)) {
                    if (oWLDisjointObjectPropertiesAxiom.getProperties().size() != 2 || !this.isDisplayed(oWLDisjointObjectPropertiesAxiom)) continue;
                    props = oWLDisjointObjectPropertiesAxiom.getPropertiesMinus(property);
                    ((SectionMap)((Object)properties)).put(props.iterator().next(), oWLDisjointObjectPropertiesAxiom);
                    axioms.add(oWLDisjointObjectPropertiesAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.DISJOINT_WITH, (SectionMap<Object, OWLAxiom>)((Object)properties), ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.SUB_PROPERTY_CHAIN_OF)) {
            for (OWLOntology ontology : this.ontologies) {
                for (OWLSubPropertyChainOfAxiom ax : ontology.getAxioms(AxiomType.SUB_PROPERTY_CHAIN_OF)) {
                    if (!ax.getSuperProperty().equals(property) || !this.isDisplayed(ax)) continue;
                    SectionMap<Object, OWLAxiom> sectionMap = new SectionMap<Object, OWLAxiom>();
                    sectionMap.put(ax.getPropertyChain(), ax);
                    this.writeSection(ManchesterOWLSyntax.SUB_PROPERTY_CHAIN, sectionMap, " o ", false, ontology);
                    axioms.add(ax);
                }
            }
        }
        for (OWLOntology ontology : this.ontologies) {
            SectionMap<Object, OWLAxiom> characteristics = new SectionMap<Object, OWLAxiom>();
            if (!this.isFiltered(AxiomType.FUNCTIONAL_OBJECT_PROPERTY)) {
                for (OWLFunctionalObjectPropertyAxiom oWLFunctionalObjectPropertyAxiom : ontology.getFunctionalObjectPropertyAxioms(property)) {
                    if (!this.isDisplayed(oWLFunctionalObjectPropertyAxiom)) continue;
                    characteristics.put(ManchesterOWLSyntax.FUNCTIONAL.toString(), oWLFunctionalObjectPropertyAxiom);
                    axioms.add(oWLFunctionalObjectPropertyAxiom);
                }
            }
            if (!this.isFiltered(AxiomType.INVERSE_FUNCTIONAL_OBJECT_PROPERTY)) {
                for (OWLAxiom oWLAxiom : ontology.getInverseFunctionalObjectPropertyAxioms(property)) {
                    if (!this.isDisplayed(oWLAxiom)) continue;
                    characteristics.put(ManchesterOWLSyntax.INVERSE_FUNCTIONAL.toString(), oWLAxiom);
                    axioms.add(oWLAxiom);
                }
            }
            if (!this.isFiltered(AxiomType.SYMMETRIC_OBJECT_PROPERTY)) {
                for (OWLAxiom oWLAxiom : ontology.getSymmetricObjectPropertyAxioms(property)) {
                    if (!this.isDisplayed(oWLAxiom)) continue;
                    characteristics.put(ManchesterOWLSyntax.SYMMETRIC.toString(), oWLAxiom);
                    axioms.add(oWLAxiom);
                }
            }
            if (!this.isFiltered(AxiomType.TRANSITIVE_OBJECT_PROPERTY)) {
                for (OWLAxiom oWLAxiom : ontology.getTransitiveObjectPropertyAxioms(property)) {
                    if (!this.isDisplayed(oWLAxiom)) continue;
                    characteristics.put(ManchesterOWLSyntax.TRANSITIVE.toString(), oWLAxiom);
                    axioms.add(oWLAxiom);
                }
            }
            if (!this.isFiltered(AxiomType.REFLEXIVE_OBJECT_PROPERTY)) {
                for (OWLAxiom oWLAxiom : ontology.getReflexiveObjectPropertyAxioms(property)) {
                    if (!this.isDisplayed(oWLAxiom)) continue;
                    characteristics.put(ManchesterOWLSyntax.REFLEXIVE.toString(), oWLAxiom);
                    axioms.add(oWLAxiom);
                }
            }
            if (!this.isFiltered(AxiomType.IRREFLEXIVE_OBJECT_PROPERTY)) {
                for (OWLAxiom oWLAxiom : ontology.getIrreflexiveObjectPropertyAxioms(property)) {
                    if (!this.isDisplayed(oWLAxiom)) continue;
                    characteristics.put(ManchesterOWLSyntax.IRREFLEXIVE.toString(), oWLAxiom);
                    axioms.add(oWLAxiom);
                }
            }
            if (!this.isFiltered(AxiomType.ASYMMETRIC_OBJECT_PROPERTY)) {
                for (OWLAxiom oWLAxiom : ontology.getAsymmetricObjectPropertyAxioms(property)) {
                    if (!this.isDisplayed(oWLAxiom)) continue;
                    characteristics.put(ManchesterOWLSyntax.ASYMMETRIC.toString(), oWLAxiom);
                    axioms.add(oWLAxiom);
                }
            }
            this.writeSection(ManchesterOWLSyntax.CHARACTERISTICS, characteristics, ",", true, ontology);
        }
        if (!this.isFiltered(AxiomType.OBJECT_PROPERTY_DOMAIN)) {
            for (OWLOntology ontology : this.ontologies) {
                expressions = new SectionMap<Object, OWLAxiom>();
                for (OWLObjectPropertyDomainAxiom oWLObjectPropertyDomainAxiom : ontology.getObjectPropertyDomainAxioms(property)) {
                    if (!this.isDisplayed(oWLObjectPropertyDomainAxiom)) continue;
                    expressions.put(oWLObjectPropertyDomainAxiom.getDomain(), oWLObjectPropertyDomainAxiom);
                    axioms.add(oWLObjectPropertyDomainAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.DOMAIN, expressions, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.OBJECT_PROPERTY_RANGE)) {
            for (OWLOntology ontology : this.ontologies) {
                expressions = new SectionMap();
                for (OWLObjectPropertyRangeAxiom oWLObjectPropertyRangeAxiom : ontology.getObjectPropertyRangeAxioms(property)) {
                    if (!this.isDisplayed(oWLObjectPropertyRangeAxiom)) continue;
                    expressions.put(oWLObjectPropertyRangeAxiom.getRange(), oWLObjectPropertyRangeAxiom);
                    axioms.add(oWLObjectPropertyRangeAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.RANGE, expressions, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.INVERSE_OBJECT_PROPERTIES)) {
            for (OWLOntology ontology : this.ontologies) {
                properties = this.sortedCollection();
                for (OWLInverseObjectPropertiesAxiom oWLInverseObjectPropertiesAxiom : ontology.getInverseObjectPropertyAxioms(property)) {
                    if (!this.isDisplayed(oWLInverseObjectPropertiesAxiom)) continue;
                    if (oWLInverseObjectPropertiesAxiom.getFirstProperty().equals(property)) {
                        properties.add(oWLInverseObjectPropertiesAxiom.getSecondProperty());
                    } else {
                        properties.add(oWLInverseObjectPropertiesAxiom.getFirstProperty());
                    }
                    axioms.add(oWLInverseObjectPropertiesAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.INVERSE_OF, properties, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.SWRL_RULE)) {
            for (OWLOntology ontology : this.ontologies) {
                HashSet<SWRLRule> rules = new HashSet<SWRLRule>();
                block25: for (SWRLRule sWRLRule : ontology.getAxioms(AxiomType.SWRL_RULE)) {
                    if (!this.isDisplayed(sWRLRule)) continue;
                    for (SWRLAtom atom : sWRLRule.getHead()) {
                        if (!atom.getPredicate().equals(property)) continue;
                        rules.add(sWRLRule);
                        this.writeSection(ManchesterOWLSyntax.RULE, rules, ",", true, ontology);
                        continue block25;
                    }
                }
            }
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.OBJECT_PROPERTY.toString());
        return axioms;
    }

    @Nonnull
    public Set<OWLAxiom> write(@Nonnull OWLDataProperty property) {
        SectionMap<Object, OWLAxiom> props;
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.DATA_PROPERTY, property));
        if (!this.isFiltered(AxiomType.FUNCTIONAL_DATA_PROPERTY)) {
            for (OWLOntology ontology : this.ontologies) {
                SectionMap<Object, OWLAxiom> characteristics = new SectionMap<Object, OWLAxiom>();
                for (OWLAxiom oWLAxiom : ontology.getFunctionalDataPropertyAxioms(property)) {
                    if (!this.isDisplayed(oWLAxiom)) continue;
                    characteristics.put(ManchesterOWLSyntax.FUNCTIONAL.toString(), oWLAxiom);
                    axioms.add(oWLAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.CHARACTERISTICS, characteristics, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.DATA_PROPERTY_DOMAIN)) {
            for (OWLOntology ontology : this.ontologies) {
                SectionMap<Object, OWLAxiom> domains = new SectionMap<Object, OWLAxiom>();
                for (OWLDataPropertyDomainAxiom oWLDataPropertyDomainAxiom : ontology.getDataPropertyDomainAxioms(property)) {
                    if (!this.isDisplayed(oWLDataPropertyDomainAxiom)) continue;
                    domains.put(oWLDataPropertyDomainAxiom.getDomain(), oWLDataPropertyDomainAxiom);
                    axioms.add(oWLDataPropertyDomainAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.DOMAIN, domains, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.DATA_PROPERTY_RANGE)) {
            for (OWLOntology ontology : this.ontologies) {
                SectionMap<Object, OWLAxiom> ranges = new SectionMap<Object, OWLAxiom>();
                for (OWLDataPropertyRangeAxiom oWLDataPropertyRangeAxiom : ontology.getDataPropertyRangeAxioms(property)) {
                    if (!this.isDisplayed(oWLDataPropertyRangeAxiom)) continue;
                    ranges.put(oWLDataPropertyRangeAxiom.getRange(), oWLDataPropertyRangeAxiom);
                    axioms.add(oWLDataPropertyRangeAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.RANGE, ranges, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.SUB_DATA_PROPERTY)) {
            for (OWLOntology ontology : this.ontologies) {
                SectionMap<Object, OWLAxiom> supers = new SectionMap<Object, OWLAxiom>();
                for (OWLSubDataPropertyOfAxiom oWLSubDataPropertyOfAxiom : ontology.getDataSubPropertyAxiomsForSubProperty(property)) {
                    if (!this.isDisplayed(oWLSubDataPropertyOfAxiom)) continue;
                    supers.put(oWLSubDataPropertyOfAxiom.getSuperProperty(), oWLSubDataPropertyOfAxiom);
                    axioms.add(oWLSubDataPropertyOfAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.SUB_PROPERTY_OF, supers, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.EQUIVALENT_DATA_PROPERTIES)) {
            for (OWLOntology ontology : this.ontologies) {
                props = new SectionMap<Object, OWLAxiom>();
                for (OWLEquivalentDataPropertiesAxiom oWLEquivalentDataPropertiesAxiom : ontology.getEquivalentDataPropertiesAxioms(property)) {
                    if (!this.isDisplayed(oWLEquivalentDataPropertiesAxiom) || oWLEquivalentDataPropertiesAxiom.getProperties().size() != 2) continue;
                    props.put(oWLEquivalentDataPropertiesAxiom.getPropertiesMinus(property).iterator().next(), oWLEquivalentDataPropertiesAxiom);
                    axioms.add(oWLEquivalentDataPropertiesAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.EQUIVALENT_TO, props, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.DISJOINT_DATA_PROPERTIES)) {
            for (OWLOntology ontology : this.ontologies) {
                props = new SectionMap();
                for (OWLDisjointDataPropertiesAxiom oWLDisjointDataPropertiesAxiom : ontology.getDisjointDataPropertiesAxioms(property)) {
                    if (oWLDisjointDataPropertiesAxiom.getProperties().size() != 2 || !this.isDisplayed(oWLDisjointDataPropertiesAxiom)) continue;
                    props.put(oWLDisjointDataPropertiesAxiom.getPropertiesMinus(property).iterator().next(), oWLDisjointDataPropertiesAxiom);
                    axioms.add(oWLDisjointDataPropertiesAxiom);
                }
                props.remove(property);
                this.writeSection(ManchesterOWLSyntax.DISJOINT_WITH, props, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.SWRL_RULE)) {
            for (OWLOntology ontology : this.ontologies) {
                HashSet rules = new HashSet();
                block13: for (SWRLRule sWRLRule : ontology.getAxioms(AxiomType.SWRL_RULE)) {
                    if (!this.isDisplayed(sWRLRule)) continue;
                    for (SWRLAtom atom : sWRLRule.getHead()) {
                        if (!atom.getPredicate().equals(property)) continue;
                        this.writeSection(ManchesterOWLSyntax.RULE, rules, "", true, ontology);
                        continue block13;
                    }
                }
            }
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.DATA_PROPERTY.toString());
        return axioms;
    }

    @Nonnull
    public Set<OWLAxiom> write(@Nonnull OWLIndividual individual) {
        Collection<OWLIndividual> inds;
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.INDIVIDUAL, individual));
        if (!this.isFiltered(AxiomType.CLASS_ASSERTION)) {
            for (OWLOntology ontology : this.ontologies) {
                SectionMap<Object, OWLAxiom> expressions = new SectionMap<Object, OWLAxiom>();
                for (OWLClassAssertionAxiom oWLClassAssertionAxiom : ontology.getClassAssertionAxioms(individual)) {
                    if (!this.isDisplayed(oWLClassAssertionAxiom)) continue;
                    expressions.put(oWLClassAssertionAxiom.getClassExpression(), oWLClassAssertionAxiom);
                    axioms.add(oWLClassAssertionAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.TYPES, expressions, ",", true, ontology);
            }
        }
        for (OWLOntology ontology : this.ontologies) {
            ArrayList<OWLPropertyAssertionAxiom<OWLObjectPropertyExpression, OWLIndividual>> assertions = new ArrayList<OWLPropertyAssertionAxiom<OWLObjectPropertyExpression, OWLIndividual>>();
            assertions.addAll(ontology.getObjectPropertyAssertionAxioms(individual));
            assertions.addAll(ontology.getNegativeObjectPropertyAssertionAxioms(individual));
            assertions.addAll(ontology.getDataPropertyAssertionAxioms(individual));
            assertions.addAll(ontology.getNegativeDataPropertyAssertionAxioms(individual));
            if (assertions.isEmpty()) continue;
            this.fireSectionRenderingPrepared(ManchesterOWLSyntax.FACTS.toString());
            this.writeSection(ManchesterOWLSyntax.FACTS);
            this.writeSpace();
            this.writeOntologiesList(ontology);
            this.incrementTab(1);
            this.writeNewLine();
            this.fireSectionRenderingStarted(ManchesterOWLSyntax.FACTS.toString());
            Iterator<OWLSameIndividualAxiom> it = assertions.iterator();
            while (it.hasNext()) {
                OWLPropertyAssertionAxiom oWLPropertyAssertionAxiom = (OWLPropertyAssertionAxiom)((Object)it.next());
                this.fireSectionItemPrepared(ManchesterOWLSyntax.FACTS.toString());
                Set<OWLAnnotation> annos = oWLPropertyAssertionAxiom.getAnnotations();
                if (!annos.isEmpty()) {
                    this.writeAnnotations(annos);
                    this.pushTab(this.getIndent() + 1);
                }
                if (oWLPropertyAssertionAxiom instanceof OWLNegativeDataPropertyAssertionAxiom || oWLPropertyAssertionAxiom instanceof OWLNegativeObjectPropertyAssertionAxiom) {
                    this.write(ManchesterOWLSyntax.NOT);
                    this.writeSpace();
                }
                oWLPropertyAssertionAxiom.getProperty().accept(this);
                this.writeSpace();
                this.writeSpace();
                oWLPropertyAssertionAxiom.getObject().accept(this);
                if (!annos.isEmpty()) {
                    this.popTab();
                }
                this.fireSectionItemFinished(ManchesterOWLSyntax.FACTS.toString());
                if (!it.hasNext()) continue;
                this.write(",");
                this.writeNewLine();
            }
            this.popTab();
            this.writeNewLine();
            this.writeNewLine();
        }
        if (!this.isFiltered(AxiomType.SAME_INDIVIDUAL)) {
            for (OWLOntology ontology : this.ontologies) {
                inds = this.sortedCollection();
                for (OWLSameIndividualAxiom oWLSameIndividualAxiom : ontology.getSameIndividualAxioms(individual)) {
                    if (!this.isDisplayed(oWLSameIndividualAxiom)) continue;
                    inds.addAll(oWLSameIndividualAxiom.getIndividuals());
                    axioms.add(oWLSameIndividualAxiom);
                }
                inds.remove(individual);
                this.writeSection(ManchesterOWLSyntax.SAME_AS, inds, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.DIFFERENT_INDIVIDUALS)) {
            for (OWLOntology ontology : this.ontologies) {
                inds = this.sortedCollection();
                Collection<OWLDifferentIndividualsAxiom> nary = this.sortedCollection();
                for (OWLDifferentIndividualsAxiom ax : ontology.getDifferentIndividualAxioms(individual)) {
                    if (ax.getIndividuals().size() == 2 && this.isDisplayed(ax)) {
                        inds.addAll(ax.getIndividuals());
                        axioms.add(ax);
                        continue;
                    }
                    nary.add(ax);
                }
                inds.remove(individual);
                this.writeSection(ManchesterOWLSyntax.DIFFERENT_FROM, inds, ",", true, ontology);
                if (!this.renderExtensions) continue;
                for (OWLDifferentIndividualsAxiom ax : nary) {
                    this.writeSection(ManchesterOWLSyntax.DIFFERENT_INDIVIDUALS, ax.getIndividuals(), ", ", false, ontology);
                }
            }
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.INDIVIDUAL.toString());
        return axioms;
    }

    @Nonnull
    public Set<OWLAxiom> write(@Nonnull OWLDatatype datatype) {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.DATATYPE, datatype));
        if (!this.isFiltered(AxiomType.DATATYPE_DEFINITION)) {
            for (OWLOntology ontology : this.ontologies) {
                Collection<OWLDataRange> dataRanges = this.sortedCollection();
                for (OWLDatatypeDefinitionAxiom ax : ontology.getDatatypeDefinitions(datatype)) {
                    if (!this.isDisplayed(ax)) continue;
                    axioms.add(ax);
                    dataRanges.add(ax.getDataRange());
                }
                this.writeSection(ManchesterOWLSyntax.EQUIVALENT_TO, dataRanges, ",", true, ontology);
            }
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.DATATYPE.toString());
        return axioms;
    }

    @Nonnull
    public Set<OWLAxiom> write(@Nonnull SWRLRule rule) {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>(1);
        for (OWLOntology ontology : this.ontologies) {
            if (!ontology.containsAxiom(rule)) continue;
            this.writeSection(ManchesterOWLSyntax.RULE, CollectionFactory.createSet(rule), "", true, ontology);
            axioms.add(rule);
        }
        return axioms;
    }

    @Nonnull
    public Set<OWLAxiom> write(@Nonnull OWLAnnotationProperty property) {
        Collection<IRI> iris;
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.ANNOTATION_PROPERTY, property));
        if (!this.isFiltered(AxiomType.SUB_ANNOTATION_PROPERTY_OF)) {
            for (OWLOntology ont : this.ontologies) {
                Collection<OWLAnnotationProperty> props = this.sortedCollection();
                for (OWLSubAnnotationPropertyOfAxiom oWLSubAnnotationPropertyOfAxiom : ont.getSubAnnotationPropertyOfAxioms(property)) {
                    if (!this.isDisplayed(oWLSubAnnotationPropertyOfAxiom)) continue;
                    props.add(oWLSubAnnotationPropertyOfAxiom.getSuperProperty());
                }
                this.writeSection(ManchesterOWLSyntax.SUB_PROPERTY_OF, props, ",", true, ont);
            }
        }
        if (!this.isFiltered(AxiomType.ANNOTATION_PROPERTY_DOMAIN)) {
            for (OWLOntology ont : this.ontologies) {
                iris = this.sortedCollection();
                for (OWLAnnotationPropertyDomainAxiom oWLAnnotationPropertyDomainAxiom : ont.getAnnotationPropertyDomainAxioms(property)) {
                    if (!this.isDisplayed(oWLAnnotationPropertyDomainAxiom)) continue;
                    iris.add(oWLAnnotationPropertyDomainAxiom.getDomain());
                }
                this.writeSection(ManchesterOWLSyntax.DOMAIN, iris, ",", true, ont);
            }
        }
        if (!this.isFiltered(AxiomType.ANNOTATION_PROPERTY_RANGE)) {
            for (OWLOntology ont : this.ontologies) {
                iris = this.sortedCollection();
                for (OWLAnnotationPropertyRangeAxiom oWLAnnotationPropertyRangeAxiom : ont.getAnnotationPropertyRangeAxioms(property)) {
                    if (!this.isDisplayed(oWLAnnotationPropertyRangeAxiom)) continue;
                    iris.add(oWLAnnotationPropertyRangeAxiom.getRange());
                }
                this.writeSection(ManchesterOWLSyntax.RANGE, iris, ",", true, ont);
            }
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.ANNOTATION_PROPERTY.toString());
        return axioms;
    }

    private Set<OWLAnnotationAssertionAxiom> writeEntityStart(@Nonnull ManchesterOWLSyntax keyword, @Nonnull OWLObject entity) {
        this.event = new RendererEvent(this, entity);
        String kw = keyword.toString();
        this.fireFrameRenderingPrepared(kw);
        this.writeSection(keyword);
        entity.accept(this);
        this.fireFrameRenderingStarted(kw);
        this.writeNewLine();
        this.incrementTab(4);
        this.writeNewLine();
        if (entity instanceof OWLEntity) {
            return this.writeAnnotations(((OWLEntity)entity).getIRI());
        }
        if (entity instanceof OWLAnonymousIndividual) {
            return this.writeAnnotations((OWLAnonymousIndividual)entity);
        }
        return CollectionFactory.emptySet();
    }

    @Nonnull
    public Set<OWLAnnotationAssertionAxiom> writeAnnotations(@Nonnull OWLAnnotationSubject subject) {
        HashSet<OWLAnnotationAssertionAxiom> axioms = new HashSet<OWLAnnotationAssertionAxiom>();
        if (!this.isFiltered(AxiomType.ANNOTATION_ASSERTION)) {
            for (OWLOntology ontology : this.ontologies) {
                SectionMap<Object, OWLAxiom> sectionMap = new SectionMap<Object, OWLAxiom>();
                for (OWLAnnotationAssertionAxiom ax : ontology.getAnnotationAssertionAxioms(subject)) {
                    if (!this.isDisplayed(ax)) continue;
                    axioms.add(ax);
                    sectionMap.put(ax.getAnnotation(), ax);
                }
                this.writeSection(ManchesterOWLSyntax.ANNOTATIONS, sectionMap, ",", true, ontology);
            }
        }
        return axioms;
    }

    public void writeSection(@Nonnull ManchesterOWLSyntax keyword) {
        this.write("", keyword, "");
        this.write(":");
        this.writeSpace();
    }

    private void writeSection(@Nonnull ManchesterOWLSyntax keyword, @Nonnull SectionMap<Object, OWLAxiom> content, String delimeter, boolean newline, OWLOntology ... ontologiesList) {
        String sec = keyword.toString();
        if (content.isNotEmpty() || this.renderingDirector.renderEmptyFrameSection(keyword, ontologiesList)) {
            this.fireSectionRenderingPrepared(sec);
            this.writeSection(keyword);
            this.writeOntologiesList(ontologiesList);
            this.incrementTab(4);
            this.writeNewLine();
            this.fireSectionRenderingStarted(sec);
            Iterator<Object> it = content.getSectionObjects().iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                Set<Set<OWLAnnotation>> annotationSets = content.getAnnotationsForSectionObject(obj);
                Iterator annosSetIt = annotationSets.iterator();
                while (annosSetIt.hasNext()) {
                    Set annos = (Set)annosSetIt.next();
                    this.fireSectionItemPrepared(sec);
                    if (!annos.isEmpty()) {
                        this.incrementTab(4);
                        this.writeNewLine();
                        this.write(ManchesterOWLSyntax.ANNOTATIONS.toString());
                        this.write(": ");
                        this.pushTab(this.getIndent() + 1);
                        Iterator annoIt = annos.iterator();
                        while (annoIt.hasNext()) {
                            ((OWLAnnotation)annoIt.next()).accept(this);
                            if (!annoIt.hasNext()) continue;
                            this.write(", ");
                            this.writeNewLine();
                        }
                        this.popTab();
                        this.popTab();
                        this.writeNewLine();
                    }
                    if (obj instanceof OWLObject) {
                        ((OWLObject)obj).accept(this);
                    } else if (obj instanceof Collection) {
                        Iterator listIt = ((Collection)obj).iterator();
                        while (listIt.hasNext()) {
                            Object o = listIt.next();
                            if (o instanceof OWLObject) {
                                ((OWLObject)o).accept(this);
                            } else {
                                this.write(o.toString());
                            }
                            if (!listIt.hasNext()) continue;
                            this.write(delimeter);
                            if (!newline) continue;
                            this.writeNewLine();
                        }
                    } else {
                        this.write(obj.toString());
                    }
                    if (!annosSetIt.hasNext()) continue;
                    this.write(",");
                    this.writeNewLine();
                }
                if (it.hasNext()) {
                    this.write(delimeter);
                    this.fireSectionItemFinished(sec);
                    if (!newline) continue;
                    this.writeNewLine();
                    continue;
                }
                this.fireSectionItemFinished(sec);
            }
            this.fireSectionRenderingFinished(sec);
            this.popTab();
            this.writeNewLine();
            this.writeNewLine();
        }
    }

    public void writeSection(@Nonnull ManchesterOWLSyntax keyword, @Nonnull Collection<?> content, String delimiter, boolean newline, OWLOntology ... ontologiesList) {
        String sec = keyword.toString();
        if (!content.isEmpty() || this.renderingDirector.renderEmptyFrameSection(keyword, ontologiesList)) {
            this.fireSectionRenderingPrepared(sec);
            this.writeSection(keyword);
            this.writeOntologiesList(ontologiesList);
            this.incrementTab(4);
            this.writeNewLine();
            this.fireSectionRenderingStarted(sec);
            Iterator<?> it = content.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                this.fireSectionItemPrepared(sec);
                if (obj instanceof OWLObject) {
                    ((OWLObject)obj).accept(this);
                } else {
                    this.write(obj.toString());
                }
                if (it.hasNext()) {
                    this.write(delimiter);
                    this.fireSectionItemFinished(sec);
                    if (!newline) continue;
                    this.writeNewLine();
                    continue;
                }
                this.fireSectionItemFinished(sec);
            }
            this.fireSectionRenderingFinished(sec);
            this.popTab();
            this.writeNewLine();
            this.writeNewLine();
        }
    }

    public void writeComment(String comment, boolean placeOnNewline) {
        this.writeComment("#", comment, placeOnNewline);
    }

    public void writeComment(String commentDelim, String comment, boolean placeOnNewline) {
        if (placeOnNewline) {
            this.writeNewLine();
        }
        this.write(commentDelim);
        this.write(comment);
        this.writeNewLine();
    }

    private void writeOntologiesList(OWLOntology ... ontologiesList) {
        if (!this.renderExtensions) {
            return;
        }
        if (ontologiesList.length == 0) {
            return;
        }
        this.write("[in ");
        int count = 0;
        for (OWLOntology ont : ontologiesList) {
            this.write(this.shortFormProvider.getShortForm(ont));
            if (++count >= ontologiesList.length) continue;
            this.write(", ");
        }
        this.write("]");
    }

    private void fireFrameRenderingPrepared(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.frameRenderingPrepared(section, this.event);
        }
    }

    private void fireFrameRenderingStarted(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.frameRenderingStarted(section, this.event);
        }
    }

    private void fireFrameRenderingFinished(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.frameRenderingFinished(section, this.event);
        }
    }

    private void fireSectionRenderingPrepared(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.sectionRenderingPrepared(section, this.event);
        }
    }

    private void fireSectionRenderingStarted(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.sectionRenderingStarted(section, this.event);
        }
    }

    private void fireSectionRenderingFinished(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.sectionRenderingFinished(section, this.event);
        }
    }

    private void fireSectionItemPrepared(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.sectionItemPrepared(section, this.event);
        }
    }

    private void fireSectionItemFinished(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.sectionItemFinished(section, this.event);
        }
    }

    @Nonnull
    private <E extends OWLObject> Collection<E> sortedCollection() {
        return new TreeSet<OWLObject>(this.owlObjectComparator);
    }

    @Nonnull
    private <E extends OWLObject> Collection<E> sortedCollection(@Nonnull Collection<? extends E> fromCollection) {
        Collection<? extends E> set = this.sortedCollection();
        set.addAll(fromCollection);
        return set;
    }

    private static class DefaultRenderingDirector
    implements RenderingDirector {
        DefaultRenderingDirector() {
        }

        @Override
        public boolean renderEmptyFrameSection(ManchesterOWLSyntax frameSectionKeyword, OWLOntology ... ontologies) {
            return false;
        }
    }

    static class SectionMap<O, V extends OWLAxiom> {
        @Nonnull
        private final Map<O, Set<V>> object2Axioms = new LinkedHashMap<O, Set<V>>();

        SectionMap() {
        }

        public boolean isNotEmpty() {
            return !this.object2Axioms.isEmpty();
        }

        public void put(O o, V forAxiom) {
            Set<V> axioms = this.object2Axioms.get(o);
            if (axioms == null) {
                axioms = new LinkedHashSet<V>();
                this.object2Axioms.put(o, axioms);
            }
            axioms.add(forAxiom);
        }

        public void remove(O o) {
            this.object2Axioms.remove(o);
        }

        @Nonnull
        public Collection<O> getSectionObjects() {
            return this.object2Axioms.keySet();
        }

        @Nonnull
        public Set<Set<OWLAnnotation>> getAnnotationsForSectionObject(Object sectionObject) {
            Collection axioms = this.object2Axioms.get(sectionObject);
            if (axioms == null) {
                return new HashSet<Set<OWLAnnotation>>();
            }
            HashSet<Set<OWLAnnotation>> annos = new HashSet<Set<OWLAnnotation>>();
            for (OWLAxiom ax : axioms) {
                annos.add(ax.getAnnotations());
            }
            return annos;
        }
    }
}

