/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import com.google.common.base.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.change.SetOntologyIDData;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeVisitor;
import org.semanticweb.owlapi.model.OWLOntologyChangeVisitorEx;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class SetOntologyID
extends OWLOntologyChange {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final OWLOntologyID ontologyID;
    @Nonnull
    private final OWLOntologyID newOntologyID;

    public SetOntologyID(@Nonnull OWLOntology ont, @Nonnull OWLOntologyID ontologyID) {
        super(ont);
        this.ontologyID = OWLAPIPreconditions.checkNotNull(ont.getOntologyID(), "ontology id cannot be null");
        this.newOntologyID = OWLAPIPreconditions.checkNotNull(ontologyID, "ontology id cannot be null");
    }

    public SetOntologyID(@Nonnull OWLOntology ont, @Nonnull IRI ontologyIRI) {
        this(ont, new OWLOntologyID((Optional<IRI>)Optional.of((Object)ontologyIRI), (Optional<IRI>)Optional.absent()));
    }

    @Override
    public SetOntologyIDData getChangeData() {
        return new SetOntologyIDData(this.newOntologyID);
    }

    @Override
    public Set<OWLEntity> getSignature() {
        return CollectionFactory.getCopyOnRequestSetFromImmutableCollection(CollectionFactory.emptySet());
    }

    @Override
    public boolean isImportChange() {
        return false;
    }

    @Override
    public boolean isAxiomChange() {
        return false;
    }

    @Override
    public boolean isAddAxiom() {
        return false;
    }

    @Override
    public OWLAxiom getAxiom() {
        throw new UnsupportedOperationException("This is an ontology id change, not an axiom change: " + this);
    }

    @Nonnull
    public OWLOntologyID getOriginalOntologyID() {
        return this.ontologyID;
    }

    @Nonnull
    public OWLOntologyID getNewOntologyID() {
        return this.newOntologyID;
    }

    @Override
    public void accept(OWLOntologyChangeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLOntologyChangeVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return String.format("SetOntologyID(%s OntologyID(%s))", this.newOntologyID, this.ontologyID);
    }

    public int hashCode() {
        return 57 + this.ontologyID.hashCode() + this.newOntologyID.hashCode() * 3;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SetOntologyID)) {
            return false;
        }
        SetOntologyID change = (SetOntologyID)obj;
        return change.ontologyID.equals(this.ontologyID) && change.newOntologyID.equals(this.newOntologyID);
    }
}

