/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLMutableOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeVisitorEx;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.RemoveImport;
import org.semanticweb.owlapi.model.RemoveOntologyAnnotation;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.model.parameters.ChangeApplied;
import uk.ac.manchester.cs.owl.owlapi.OWLImmutableOntologyImpl;

public class OWLOntologyImpl
extends OWLImmutableOntologyImpl
implements OWLMutableOntology,
Serializable {
    private static final long serialVersionUID = 40000L;

    public OWLOntologyImpl(@Nonnull OWLOntologyManager manager, @Nonnull OWLOntologyID ontologyID) {
        super(manager, ontologyID);
    }

    @Override
    public ChangeApplied applyChange(@Nonnull OWLOntologyChange change) {
        OWLOntologyChangeFilter changeFilter = new OWLOntologyChangeFilter();
        return change.accept(changeFilter);
    }

    @Override
    @Nonnull
    public List<OWLOntologyChange> applyChanges(@Nonnull List<? extends OWLOntologyChange> changes) {
        ArrayList<OWLOntologyChange> appliedChanges = new ArrayList<OWLOntologyChange>();
        OWLOntologyChangeFilter changeFilter = new OWLOntologyChangeFilter();
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (oWLOntologyChange.accept(changeFilter) != ChangeApplied.SUCCESSFULLY) continue;
            appliedChanges.add(oWLOntologyChange);
        }
        return appliedChanges;
    }

    @Override
    public ChangeApplied addAxiom(OWLAxiom axiom) {
        return this.getOWLOntologyManager().addAxiom(this, axiom);
    }

    @Override
    public List<OWLOntologyChange> addAxioms(Set<? extends OWLAxiom> axioms) {
        return this.getOWLOntologyManager().addAxioms(this, axioms);
    }

    protected class OWLOntologyChangeFilter
    implements OWLOntologyChangeVisitorEx<ChangeApplied>,
    Serializable {
        private static final long serialVersionUID = 40000L;

        protected OWLOntologyChangeFilter() {
        }

        @Override
        public ChangeApplied visit(@Nonnull RemoveAxiom change) {
            if (OWLOntologyImpl.this.ints.removeAxiom(change.getAxiom())) {
                return ChangeApplied.SUCCESSFULLY;
            }
            return ChangeApplied.UNSUCCESSFULLY;
        }

        @Override
        public ChangeApplied visit(@Nonnull SetOntologyID change) {
            OWLOntologyID id = change.getNewOntologyID();
            if (!id.equals(OWLOntologyImpl.this.ontologyID)) {
                OWLOntologyImpl.this.ontologyID = id;
                return ChangeApplied.SUCCESSFULLY;
            }
            return ChangeApplied.UNSUCCESSFULLY;
        }

        @Override
        public ChangeApplied visit(@Nonnull AddAxiom change) {
            if (OWLOntologyImpl.this.ints.addAxiom(change.getAxiom())) {
                return ChangeApplied.SUCCESSFULLY;
            }
            return ChangeApplied.UNSUCCESSFULLY;
        }

        @Override
        public ChangeApplied visit(@Nonnull AddImport change) {
            if (OWLOntologyImpl.this.ints.addImportsDeclaration(change.getImportDeclaration())) {
                return ChangeApplied.SUCCESSFULLY;
            }
            return ChangeApplied.UNSUCCESSFULLY;
        }

        @Override
        public ChangeApplied visit(@Nonnull RemoveImport change) {
            if (OWLOntologyImpl.this.ints.removeImportsDeclaration(change.getImportDeclaration())) {
                return ChangeApplied.SUCCESSFULLY;
            }
            return ChangeApplied.UNSUCCESSFULLY;
        }

        @Override
        public ChangeApplied visit(@Nonnull AddOntologyAnnotation change) {
            if (OWLOntologyImpl.this.ints.addOntologyAnnotation(change.getAnnotation())) {
                return ChangeApplied.SUCCESSFULLY;
            }
            return ChangeApplied.UNSUCCESSFULLY;
        }

        @Override
        public ChangeApplied visit(@Nonnull RemoveOntologyAnnotation change) {
            if (OWLOntologyImpl.this.ints.removeOntologyAnnotation(change.getAnnotation())) {
                return ChangeApplied.SUCCESSFULLY;
            }
            return ChangeApplied.UNSUCCESSFULLY;
        }
    }
}

