/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.file;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.activemq.artemis.jdbc.store.file.JDBCSequentialFileFactoryDriver;
import org.apache.activemq.artemis.jdbc.store.file.PostgresSequentialSequentialFileDriver;
import org.apache.activemq.artemis.jdbc.store.sql.PropertySQLProvider;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;

class JDBCFileUtils {
    JDBCFileUtils() {
    }

    static JDBCSequentialFileFactoryDriver getDBFileDriver(String driverClass, String jdbcConnectionUrl, SQLProvider provider) throws SQLException {
        JDBCSequentialFileFactoryDriver dbDriver = PropertySQLProvider.Factory.SQLDialect.POSTGRESQL.equals((Object)PropertySQLProvider.Factory.identifyDialect(driverClass)) ? new PostgresSequentialSequentialFileDriver() : new JDBCSequentialFileFactoryDriver();
        dbDriver.setSqlProvider(provider);
        dbDriver.setJdbcConnectionUrl(jdbcConnectionUrl);
        dbDriver.setJdbcDriverClass(driverClass);
        return dbDriver;
    }

    static JDBCSequentialFileFactoryDriver getDBFileDriver(DataSource dataSource, SQLProvider provider) throws SQLException {
        JDBCSequentialFileFactoryDriver dbDriver = PropertySQLProvider.Factory.SQLDialect.POSTGRESQL.equals((Object)PropertySQLProvider.Factory.investigateDialect(dataSource.getConnection())) ? new PostgresSequentialSequentialFileDriver(dataSource, provider) : new JDBCSequentialFileFactoryDriver(dataSource, provider);
        return dbDriver;
    }

    static JDBCSequentialFileFactoryDriver getDBFileDriver(Connection connection, SQLProvider provider) throws SQLException {
        JDBCSequentialFileFactoryDriver dbDriver;
        if (PropertySQLProvider.Factory.SQLDialect.POSTGRESQL.equals((Object)PropertySQLProvider.Factory.investigateDialect(connection))) {
            dbDriver = new PostgresSequentialSequentialFileDriver(connection, provider);
            dbDriver.setConnection(connection);
        } else {
            dbDriver = new JDBCSequentialFileFactoryDriver(connection, provider);
        }
        return dbDriver;
    }
}

