/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.KTableKTableAbstractJoin;
import org.apache.kafka.streams.kstream.internals.KTableKTableJoinValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;

class KTableKTableJoin<K, R, V1, V2>
extends KTableKTableAbstractJoin<K, R, V1, V2> {
    private final KeyValueMapper<K, V1, K> keyValueMapper = new KeyValueMapper<K, V1, K>(){

        @Override
        public K apply(K key, V1 value) {
            return key;
        }
    };

    KTableKTableJoin(KTableImpl<K, ?, V1> table1, KTableImpl<K, ?, V2> table2, ValueJoiner<? super V1, ? super V2, ? extends R> joiner) {
        super(table1, table2, joiner);
    }

    @Override
    public Processor<K, Change<V1>> get() {
        return new KTableKTableJoinProcessor(this.valueGetterSupplier2.get());
    }

    @Override
    public KTableValueGetterSupplier<K, R> view() {
        return new KTableKTableAbstractJoinValueGetterSupplier(this.valueGetterSupplier1, this.valueGetterSupplier2);
    }

    private class KTableKTableJoinProcessor
    extends AbstractProcessor<K, Change<V1>> {
        private final KTableValueGetter<K, V2> valueGetter;

        public KTableKTableJoinProcessor(KTableValueGetter<K, V2> valueGetter) {
            this.valueGetter = valueGetter;
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            this.valueGetter.init(context);
        }

        @Override
        public void process(K key, Change<V1> change) {
            if (key == null) {
                return;
            }
            Object newValue = null;
            Object oldValue = null;
            Object value2 = this.valueGetter.get(key);
            if (value2 == null) {
                return;
            }
            if (change.newValue != null) {
                newValue = KTableKTableJoin.this.joiner.apply(change.newValue, value2);
            }
            if (KTableKTableJoin.this.sendOldValues && change.oldValue != null) {
                oldValue = KTableKTableJoin.this.joiner.apply(change.oldValue, value2);
            }
            this.context().forward(key, new Change<Object>(newValue, oldValue));
        }
    }

    private class KTableKTableAbstractJoinValueGetterSupplier
    extends org.apache.kafka.streams.kstream.internals.KTableKTableAbstractJoinValueGetterSupplier<K, R, V1, V2> {
        public KTableKTableAbstractJoinValueGetterSupplier(KTableValueGetterSupplier<K, V1> valueGetterSupplier1, KTableValueGetterSupplier<K, V2> valueGetterSupplier2) {
            super(valueGetterSupplier1, valueGetterSupplier2);
        }

        @Override
        public KTableValueGetter<K, R> get() {
            return new KTableKTableJoinValueGetter(this.valueGetterSupplier1.get(), this.valueGetterSupplier2.get(), KTableKTableJoin.this.joiner, KTableKTableJoin.this.keyValueMapper);
        }
    }
}

