/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.accurev;

import java.util.Date;
import org.apache.maven.scm.provider.accurev.AccuRev;

public class AccuRevVersion {
    private String basisStream;
    private String timeSpec;

    public AccuRevVersion(String basisStream, String tran) {
        this.basisStream = basisStream;
        this.timeSpec = tran;
    }

    public String getBasisStream() {
        return this.basisStream;
    }

    public String getTimeSpec() {
        return this.timeSpec;
    }

    public AccuRevVersion(String basis, Date startDate) {
        this(basis, AccuRev.ACCUREV_TIME_SPEC.format(startDate));
    }

    public AccuRevVersion(String basis, long transactionId) {
        this(basis, Long.toString(transactionId));
    }

    public boolean isNow() {
        return this.timeSpec == null || "highest".equalsIgnoreCase(this.timeSpec) || "now".equalsIgnoreCase(this.timeSpec);
    }

    public String toString() {
        return String.format("AccuRevVersion: stream = %s, transaction= %s", this.basisStream, this.timeSpec);
    }
}

