/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.shared.compress.archivers.zip;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.maven.surefire.shared.compress.archivers.zip.NioZipEncoding;
import org.apache.maven.surefire.shared.compress.archivers.zip.ZipEncoding;
import org.apache.maven.surefire.shared.compress.utils.Charsets;

public abstract class ZipEncodingHelper {
    static final ZipEncoding ZIP_ENCODING_UTF_8 = ZipEncodingHelper.getZipEncoding("UTF-8");

    public static ZipEncoding getZipEncoding(String name) {
        Charset cs = Charset.defaultCharset();
        try {
            cs = Charsets.toCharset(name);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            // empty catch block
        }
        boolean useReplacement = ZipEncodingHelper.isUTF8(cs.name());
        return new NioZipEncoding(cs, useReplacement);
    }

    static ByteBuffer growBufferBy(ByteBuffer buffer, int increment) {
        buffer.limit(buffer.position());
        buffer.rewind();
        ByteBuffer on = ByteBuffer.allocate(buffer.capacity() + increment);
        on.put(buffer);
        return on;
    }

    static boolean isUTF8(String charsetName) {
        String actual;
        String string = actual = charsetName != null ? charsetName : Charset.defaultCharset().name();
        if (StandardCharsets.UTF_8.name().equalsIgnoreCase(actual)) {
            return true;
        }
        return StandardCharsets.UTF_8.aliases().stream().anyMatch(alias -> alias.equalsIgnoreCase(actual));
    }
}

