/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.shared.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.codehaus.plexus.util.StringUtils;
import org.cyberneko.html.HTMLConfiguration;
import org.cyberneko.html.filters.DefaultFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlFileListParser {
    public static List<String> parseFileList(String baseurl, InputStream stream) throws TransferFailedException {
        try {
            URI baseURI = new URI(baseurl);
            Parser handler = new Parser(baseURI);
            HTMLConfiguration parser = new HTMLConfiguration();
            parser.setDocumentHandler((XMLDocumentHandler)handler);
            parser.setFeature("http://cyberneko.org/html/features/augmentations", true);
            parser.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"upper");
            parser.setProperty("http://cyberneko.org/html/properties/names/attrs", (Object)"upper");
            parser.parse(new XMLInputSource(null, baseurl, baseURI.toString(), stream, "UTF-8"));
            return new ArrayList<String>(handler.getLinks());
        }
        catch (URISyntaxException e) {
            throw new TransferFailedException("Unable to parse as URI: " + baseurl, (Throwable)e);
        }
        catch (IOException e) {
            throw new TransferFailedException("I/O error: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Parser
    extends DefaultFilter {
        private static final Pattern APACHE_INDEX_SKIP = Pattern.compile("\\?[CDMNS]=.*");
        private static final Pattern URLS_WITH_PATHS = Pattern.compile("/[^/]*/");
        private static final Pattern URLS_TO_PARENT = Pattern.compile("\\.\\./");
        private static final Pattern MAILTO_URLS = Pattern.compile("mailto:.*");
        private static final Pattern[] SKIPS = new Pattern[]{APACHE_INDEX_SKIP, URLS_WITH_PATHS, URLS_TO_PARENT, MAILTO_URLS};
        private Set<String> links = new HashSet<String>();
        private URI baseURI;

        public Parser(URI baseURI) {
            this.baseURI = baseURI.normalize();
        }

        public Set<String> getLinks() {
            return this.links;
        }

        public void startElement(QName element, XMLAttributes attrs, Augmentations augs) {
            String link;
            String href;
            if ("A".equals(element.rawname) && (href = attrs.getValue("HREF")) != null && Parser.isAcceptableLink(link = Parser.cleanLink(this.baseURI, href))) {
                this.links.add(link);
            }
        }

        private static String cleanLink(URI baseURI, String link) {
            if (StringUtils.isEmpty((String)link)) {
                return "";
            }
            String ret = link;
            try {
                URI linkuri = new URI(ret);
                URI relativeURI = baseURI.relativize(linkuri).normalize();
                ret = relativeURI.toASCIIString();
                if (ret.startsWith(baseURI.getPath())) {
                    ret = ret.substring(baseURI.getPath().length());
                }
                ret = URLDecoder.decode(ret, "UTF-8");
            }
            catch (URISyntaxException e) {
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return ret;
        }

        private static boolean isAcceptableLink(String link) {
            if (StringUtils.isEmpty((String)link)) {
                return false;
            }
            for (int i = 0; i < SKIPS.length; ++i) {
                if (!SKIPS[i].matcher(link).find()) continue;
                return false;
            }
            return true;
        }
    }
}

