/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.mysql.visitor;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.autogen.MySQLStatementBaseVisitor;
import org.apache.shardingsphere.sql.parser.autogen.MySQLStatementParser;
import org.apache.shardingsphere.sql.parser.sql.constant.AggregationType;
import org.apache.shardingsphere.sql.parser.sql.constant.OrderDirection;
import org.apache.shardingsphere.sql.parser.sql.predicate.PredicateBuilder;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.complex.CommonExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.subquery.SubqueryExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.AggregationDistinctProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.order.OrderBySegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.order.item.ExpressionOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.order.item.IndexOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.order.item.OrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.PredicateSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.value.PredicateBetweenRightValue;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.value.PredicateBracketValue;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.value.PredicateCompareRightValue;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.value.PredicateInRightValue;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.value.PredicateLeftBracketValue;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.value.PredicateRightBracketValue;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.value.PredicateRightValue;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.DataTypeLengthSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.DataTypeSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.util.SQLUtil;
import org.apache.shardingsphere.sql.parser.sql.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.sql.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.sql.value.keyword.KeywordValue;
import org.apache.shardingsphere.sql.parser.sql.value.literal.impl.BooleanLiteralValue;
import org.apache.shardingsphere.sql.parser.sql.value.literal.impl.NumberLiteralValue;
import org.apache.shardingsphere.sql.parser.sql.value.literal.impl.OtherLiteralValue;
import org.apache.shardingsphere.sql.parser.sql.value.literal.impl.StringLiteralValue;
import org.apache.shardingsphere.sql.parser.sql.value.parametermarker.ParameterMarkerValue;

public abstract class MySQLVisitor
extends MySQLStatementBaseVisitor<ASTNode> {
    private int currentParameterIndex;

    @Override
    public final ASTNode visitParameterMarker(MySQLStatementParser.ParameterMarkerContext ctx) {
        return new ParameterMarkerValue(Integer.valueOf(this.currentParameterIndex++));
    }

    @Override
    public final ASTNode visitLiterals(MySQLStatementParser.LiteralsContext ctx) {
        if (null != ctx.stringLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.stringLiterals());
        }
        if (null != ctx.numberLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.numberLiterals());
        }
        if (null != ctx.dateTimeLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.dateTimeLiterals());
        }
        if (null != ctx.hexadecimalLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.hexadecimalLiterals());
        }
        if (null != ctx.bitValueLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.bitValueLiterals());
        }
        if (null != ctx.booleanLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.booleanLiterals());
        }
        if (null != ctx.nullValueLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.nullValueLiterals());
        }
        throw new IllegalStateException("Literals must have string, number, dateTime, hex, bit, boolean or null.");
    }

    @Override
    public final ASTNode visitStringLiterals(MySQLStatementParser.StringLiteralsContext ctx) {
        return new StringLiteralValue(ctx.getText());
    }

    @Override
    public final ASTNode visitNumberLiterals(MySQLStatementParser.NumberLiteralsContext ctx) {
        return new NumberLiteralValue(ctx.getText());
    }

    @Override
    public final ASTNode visitDateTimeLiterals(MySQLStatementParser.DateTimeLiteralsContext ctx) {
        return new OtherLiteralValue(ctx.getText());
    }

    @Override
    public final ASTNode visitHexadecimalLiterals(MySQLStatementParser.HexadecimalLiteralsContext ctx) {
        return new OtherLiteralValue(ctx.getText());
    }

    @Override
    public final ASTNode visitBitValueLiterals(MySQLStatementParser.BitValueLiteralsContext ctx) {
        return new OtherLiteralValue(ctx.getText());
    }

    @Override
    public final ASTNode visitBooleanLiterals(MySQLStatementParser.BooleanLiteralsContext ctx) {
        return new BooleanLiteralValue(ctx.getText());
    }

    @Override
    public final ASTNode visitNullValueLiterals(MySQLStatementParser.NullValueLiteralsContext ctx) {
        return new OtherLiteralValue(ctx.getText());
    }

    @Override
    public final ASTNode visitIdentifier(MySQLStatementParser.IdentifierContext ctx) {
        MySQLStatementParser.UnreservedWordContext unreservedWord = ctx.unreservedWord();
        return null != unreservedWord ? (ASTNode)this.visit((ParseTree)unreservedWord) : new IdentifierValue(ctx.getText());
    }

    @Override
    public final ASTNode visitUnreservedWord(MySQLStatementParser.UnreservedWordContext ctx) {
        return new IdentifierValue(ctx.getText());
    }

    @Override
    public final ASTNode visitSchemaName(MySQLStatementParser.SchemaNameContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.identifier());
    }

    @Override
    public final ASTNode visitTableName(MySQLStatementParser.TableNameContext ctx) {
        SimpleTableSegment result = new SimpleTableSegment(new TableNameSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.name())));
        MySQLStatementParser.OwnerContext owner = ctx.owner();
        if (null != owner) {
            result.setOwner(new OwnerSegment(owner.getStart().getStartIndex(), owner.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)owner.identifier())));
        }
        return result;
    }

    @Override
    public final ASTNode visitColumnName(MySQLStatementParser.ColumnNameContext ctx) {
        ColumnSegment result = new ColumnSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.name()));
        MySQLStatementParser.OwnerContext owner = ctx.owner();
        if (null != owner) {
            result.setOwner(new OwnerSegment(owner.getStart().getStartIndex(), owner.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)owner.identifier())));
        }
        return result;
    }

    @Override
    public final ASTNode visitIndexName(MySQLStatementParser.IndexNameContext ctx) {
        return new IndexSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier()));
    }

    @Override
    public final ASTNode visitTableNames(MySQLStatementParser.TableNamesContext ctx) {
        CollectionValue result = new CollectionValue();
        for (MySQLStatementParser.TableNameContext each : ctx.tableName()) {
            result.getValue().add((SimpleTableSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public final ASTNode visitColumnNames(MySQLStatementParser.ColumnNamesContext ctx) {
        CollectionValue result = new CollectionValue();
        for (MySQLStatementParser.ColumnNameContext each : ctx.columnName()) {
            result.getValue().add((ColumnSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public final ASTNode visitExpr(MySQLStatementParser.ExprContext ctx) {
        if (null != ctx.booleanPrimary()) {
            return (ASTNode)this.visit((ParseTree)ctx.booleanPrimary());
        }
        if (null != ctx.logicalOperator()) {
            return new PredicateBuilder((ASTNode)this.visit((ParseTree)ctx.expr(0)), (ASTNode)this.visit((ParseTree)ctx.expr(1)), ctx.logicalOperator().getText()).mergePredicate();
        }
        return (ASTNode)this.visit((ParseTree)ctx.expr().get(0));
    }

    @Override
    public final ASTNode visitBooleanPrimary(MySQLStatementParser.BooleanPrimaryContext ctx) {
        if (null != ctx.comparisonOperator() || null != ctx.SAFE_EQ_()) {
            return this.createCompareSegment(ctx);
        }
        if (null != ctx.predicate()) {
            return (ASTNode)this.visit((ParseTree)ctx.predicate());
        }
        if (null != ctx.subquery()) {
            return new SubquerySegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (SelectStatement)this.visit((ParseTree)ctx.subquery()));
        }
        return new CommonExpressionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getText());
    }

    private ASTNode createCompareSegment(MySQLStatementParser.BooleanPrimaryContext ctx) {
        ASTNode leftValue = (ASTNode)this.visit((ParseTree)ctx.booleanPrimary());
        if (!(leftValue instanceof ColumnSegment)) {
            return leftValue;
        }
        PredicateRightValue rightValue = (PredicateRightValue)this.createPredicateRightValue(ctx);
        return new PredicateSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ColumnSegment)leftValue, rightValue);
    }

    private ASTNode createPredicateRightValue(MySQLStatementParser.BooleanPrimaryContext ctx) {
        if (null != ctx.subquery()) {
            new SubquerySegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (SelectStatement)this.visit((ParseTree)ctx.subquery()));
        }
        ASTNode rightValue = (ASTNode)this.visit((ParseTree)ctx.predicate());
        return this.createPredicateRightValue(ctx, rightValue);
    }

    private ASTNode createPredicateRightValue(MySQLStatementParser.BooleanPrimaryContext ctx, ASTNode rightValue) {
        if (rightValue instanceof ColumnSegment) {
            return rightValue;
        }
        return rightValue instanceof SubquerySegment ? new PredicateCompareRightValue(ctx.comparisonOperator().getText(), (ExpressionSegment)new SubqueryExpressionSegment((SubquerySegment)rightValue)) : new PredicateCompareRightValue(ctx.comparisonOperator().getText(), (ExpressionSegment)rightValue);
    }

    @Override
    public final ASTNode visitPredicate(MySQLStatementParser.PredicateContext ctx) {
        if (null != ctx.IN() && null == ctx.NOT()) {
            return this.createInSegment(ctx);
        }
        if (null != ctx.BETWEEN() && null == ctx.NOT()) {
            return this.createBetweenSegment(ctx);
        }
        if (1 == ctx.children.size()) {
            return (ASTNode)this.visit((ParseTree)ctx.bitExpr(0));
        }
        return this.visitRemainPredicate(ctx);
    }

    private PredicateSegment createInSegment(MySQLStatementParser.PredicateContext ctx) {
        ColumnSegment column = (ColumnSegment)this.visit((ParseTree)ctx.bitExpr(0));
        PredicateBracketValue predicateBracketValue = this.createBracketValue(ctx);
        return new PredicateSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), column, (PredicateRightValue)new PredicateInRightValue(predicateBracketValue, this.getExpressionSegments(ctx)));
    }

    private Collection<ExpressionSegment> getExpressionSegments(MySQLStatementParser.PredicateContext ctx) {
        LinkedList<ExpressionSegment> result = new LinkedList<ExpressionSegment>();
        if (null != ctx.subquery()) {
            MySQLStatementParser.SubqueryContext subquery = ctx.subquery();
            result.add((ExpressionSegment)new SubqueryExpressionSegment(new SubquerySegment(subquery.getStart().getStartIndex(), subquery.getStop().getStopIndex(), (SelectStatement)this.visit((ParseTree)ctx.subquery()))));
            return result;
        }
        for (MySQLStatementParser.ExprContext each : ctx.expr()) {
            result.add((ExpressionSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    private PredicateBracketValue createBracketValue(MySQLStatementParser.PredicateContext ctx) {
        PredicateLeftBracketValue predicateLeftBracketValue = null != ctx.subquery() ? new PredicateLeftBracketValue(ctx.subquery().LP_().getSymbol().getStartIndex(), ctx.subquery().LP_().getSymbol().getStopIndex()) : new PredicateLeftBracketValue(ctx.LP_().getSymbol().getStartIndex(), ctx.LP_().getSymbol().getStopIndex());
        PredicateRightBracketValue predicateRightBracketValue = null != ctx.subquery() ? new PredicateRightBracketValue(ctx.subquery().RP_().getSymbol().getStartIndex(), ctx.subquery().RP_().getSymbol().getStopIndex()) : new PredicateRightBracketValue(ctx.RP_().getSymbol().getStartIndex(), ctx.RP_().getSymbol().getStopIndex());
        return new PredicateBracketValue(predicateLeftBracketValue, predicateRightBracketValue);
    }

    private PredicateSegment createBetweenSegment(MySQLStatementParser.PredicateContext ctx) {
        ColumnSegment column = (ColumnSegment)this.visit((ParseTree)ctx.bitExpr(0));
        ExpressionSegment between = (ExpressionSegment)this.visit((ParseTree)ctx.bitExpr(1));
        ExpressionSegment and = (ExpressionSegment)this.visit((ParseTree)ctx.predicate());
        return new PredicateSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), column, (PredicateRightValue)new PredicateBetweenRightValue(between, and));
    }

    private ASTNode visitRemainPredicate(MySQLStatementParser.PredicateContext ctx) {
        for (MySQLStatementParser.BitExprContext bitExprContext : ctx.bitExpr()) {
            this.visit((ParseTree)bitExprContext);
        }
        for (MySQLStatementParser.ExprContext exprContext : ctx.expr()) {
            this.visit((ParseTree)exprContext);
        }
        for (MySQLStatementParser.SimpleExprContext simpleExprContext : ctx.simpleExpr()) {
            this.visit((ParseTree)simpleExprContext);
        }
        if (null != ctx.predicate()) {
            this.visit((ParseTree)ctx.predicate());
        }
        return new CommonExpressionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getText());
    }

    @Override
    public final ASTNode visitBitExpr(MySQLStatementParser.BitExprContext ctx) {
        if (null != ctx.simpleExpr()) {
            return this.createExpressionSegment((ASTNode)this.visit((ParseTree)ctx.simpleExpr()), ctx);
        }
        this.visitRemainBitExpr(ctx);
        return new CommonExpressionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getText());
    }

    private ASTNode createExpressionSegment(ASTNode astNode, ParserRuleContext context) {
        if (astNode instanceof StringLiteralValue) {
            return new LiteralExpressionSegment(context.start.getStartIndex(), context.stop.getStopIndex(), (Object)((StringLiteralValue)astNode).getValue());
        }
        if (astNode instanceof NumberLiteralValue) {
            return new LiteralExpressionSegment(context.start.getStartIndex(), context.stop.getStopIndex(), (Object)((NumberLiteralValue)astNode).getValue());
        }
        if (astNode instanceof BooleanLiteralValue) {
            return new LiteralExpressionSegment(context.start.getStartIndex(), context.stop.getStopIndex(), (Object)((BooleanLiteralValue)astNode).getValue());
        }
        if (astNode instanceof ParameterMarkerValue) {
            return new ParameterMarkerExpressionSegment(context.start.getStartIndex(), context.stop.getStopIndex(), ((ParameterMarkerValue)astNode).getValue().intValue());
        }
        if (astNode instanceof SubquerySegment) {
            return new SubqueryExpressionSegment((SubquerySegment)astNode);
        }
        if (astNode instanceof OtherLiteralValue) {
            return new CommonExpressionSegment(context.getStart().getStartIndex(), context.getStop().getStopIndex(), context.getText());
        }
        return astNode;
    }

    private void visitRemainBitExpr(MySQLStatementParser.BitExprContext ctx) {
        if (null != ctx.intervalExpression()) {
            this.visit((ParseTree)ctx.intervalExpression().expr());
        }
        ctx.bitExpr().forEach(arg_0 -> ((MySQLVisitor)this).visit(arg_0));
    }

    @Override
    public final ASTNode visitSimpleExpr(MySQLStatementParser.SimpleExprContext ctx) {
        if (null != ctx.subquery()) {
            return new SubquerySegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (SelectStatement)this.visit((ParseTree)ctx.subquery()));
        }
        if (null != ctx.parameterMarker()) {
            return (ASTNode)this.visit((ParseTree)ctx.parameterMarker());
        }
        if (null != ctx.literals()) {
            return (ASTNode)this.visit((ParseTree)ctx.literals());
        }
        if (null != ctx.intervalExpression()) {
            return (ASTNode)this.visit((ParseTree)ctx.intervalExpression());
        }
        if (null != ctx.functionCall()) {
            return (ASTNode)this.visit((ParseTree)ctx.functionCall());
        }
        if (null != ctx.columnName()) {
            return (ASTNode)this.visit((ParseTree)ctx.columnName());
        }
        return this.visitRemainSimpleExpr(ctx);
    }

    @Override
    public final ASTNode visitIntervalExpression(MySQLStatementParser.IntervalExpressionContext ctx) {
        this.calculateParameterCount(Collections.singleton(ctx.expr()));
        return new ExpressionProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getText());
    }

    @Override
    public final ASTNode visitFunctionCall(MySQLStatementParser.FunctionCallContext ctx) {
        if (null != ctx.aggregationFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.aggregationFunction());
        }
        if (null != ctx.specialFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.specialFunction());
        }
        if (null != ctx.regularFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.regularFunction());
        }
        throw new IllegalStateException("FunctionCallContext must have aggregationFunction, regularFunction or specialFunction.");
    }

    @Override
    public final ASTNode visitAggregationFunction(MySQLStatementParser.AggregationFunctionContext ctx) {
        String aggregationType = ctx.aggregationFunctionName().getText();
        return AggregationType.isAggregationType((String)aggregationType) ? this.createAggregationSegment(ctx, aggregationType) : new ExpressionProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getText());
    }

    private ASTNode createAggregationSegment(MySQLStatementParser.AggregationFunctionContext ctx, String aggregationType) {
        AggregationType type = AggregationType.valueOf((String)aggregationType.toUpperCase());
        int innerExpressionStartIndex = ((TerminalNode)ctx.getChild(1)).getSymbol().getStartIndex();
        if (null == ctx.distinct()) {
            return new AggregationProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), type, innerExpressionStartIndex);
        }
        return new AggregationDistinctProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), type, innerExpressionStartIndex, this.getDistinctExpression(ctx));
    }

    private String getDistinctExpression(MySQLStatementParser.AggregationFunctionContext ctx) {
        StringBuilder result = new StringBuilder();
        for (int i = 3; i < ctx.getChildCount() - 1; ++i) {
            result.append(ctx.getChild(i).getText());
        }
        return result.toString();
    }

    @Override
    public final ASTNode visitSpecialFunction(MySQLStatementParser.SpecialFunctionContext ctx) {
        if (null != ctx.groupConcatFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.groupConcatFunction());
        }
        if (null != ctx.windowFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.windowFunction());
        }
        if (null != ctx.castFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.castFunction());
        }
        if (null != ctx.convertFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.convertFunction());
        }
        if (null != ctx.positionFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.positionFunction());
        }
        if (null != ctx.substringFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.substringFunction());
        }
        if (null != ctx.extractFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.extractFunction());
        }
        if (null != ctx.charFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.charFunction());
        }
        if (null != ctx.weightStringFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.weightStringFunction());
        }
        return new ExpressionProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getText());
    }

    @Override
    public final ASTNode visitGroupConcatFunction(MySQLStatementParser.GroupConcatFunctionContext ctx) {
        this.calculateParameterCount(ctx.expr());
        return new ExpressionProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getText());
    }

    @Override
    public final ASTNode visitWindowFunction(MySQLStatementParser.WindowFunctionContext ctx) {
        this.calculateParameterCount(ctx.expr());
        return new ExpressionProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getText());
    }

    @Override
    public final ASTNode visitCastFunction(MySQLStatementParser.CastFunctionContext ctx) {
        this.calculateParameterCount(Collections.singleton(ctx.expr()));
        return new ExpressionProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getText());
    }

    @Override
    public final ASTNode visitConvertFunction(MySQLStatementParser.ConvertFunctionContext ctx) {
        this.calculateParameterCount(Collections.singleton(ctx.expr()));
        return new ExpressionProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getText());
    }

    @Override
    public final ASTNode visitPositionFunction(MySQLStatementParser.PositionFunctionContext ctx) {
        this.calculateParameterCount(ctx.expr());
        return new ExpressionProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getText());
    }

    @Override
    public final ASTNode visitSubstringFunction(MySQLStatementParser.SubstringFunctionContext ctx) {
        this.calculateParameterCount(Collections.singleton(ctx.expr()));
        return new ExpressionProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getText());
    }

    @Override
    public final ASTNode visitExtractFunction(MySQLStatementParser.ExtractFunctionContext ctx) {
        this.calculateParameterCount(Collections.singleton(ctx.expr()));
        return new ExpressionProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getText());
    }

    @Override
    public final ASTNode visitCharFunction(MySQLStatementParser.CharFunctionContext ctx) {
        this.calculateParameterCount(ctx.expr());
        return new ExpressionProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getText());
    }

    @Override
    public final ASTNode visitWeightStringFunction(MySQLStatementParser.WeightStringFunctionContext ctx) {
        this.calculateParameterCount(Collections.singleton(ctx.expr()));
        return new ExpressionProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getText());
    }

    @Override
    public final ASTNode visitRegularFunction(MySQLStatementParser.RegularFunctionContext ctx) {
        this.calculateParameterCount(ctx.expr());
        return new ExpressionProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getText());
    }

    private ASTNode visitRemainSimpleExpr(MySQLStatementParser.SimpleExprContext ctx) {
        if (null != ctx.caseExpression()) {
            return (ASTNode)this.visit((ParseTree)ctx.caseExpression());
        }
        for (MySQLStatementParser.ExprContext exprContext : ctx.expr()) {
            this.visit((ParseTree)exprContext);
        }
        for (MySQLStatementParser.SimpleExprContext simpleExprContext : ctx.simpleExpr()) {
            this.visit((ParseTree)simpleExprContext);
        }
        return new CommonExpressionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getText());
    }

    @Override
    public final ASTNode visitCaseExpression(MySQLStatementParser.CaseExpressionContext ctx) {
        return new OtherLiteralValue(ctx.getText());
    }

    @Override
    public final ASTNode visitDataTypeName(MySQLStatementParser.DataTypeNameContext ctx) {
        return new KeywordValue(ctx.getText());
    }

    private void calculateParameterCount(Collection<MySQLStatementParser.ExprContext> exprContexts) {
        for (MySQLStatementParser.ExprContext each : exprContexts) {
            this.visit((ParseTree)each);
        }
    }

    @Override
    public final ASTNode visitDataType(MySQLStatementParser.DataTypeContext ctx) {
        DataTypeSegment dataTypeSegment = new DataTypeSegment();
        dataTypeSegment.setDataTypeName(((KeywordValue)this.visit((ParseTree)ctx.dataTypeName())).getValue());
        dataTypeSegment.setStartIndex(ctx.start.getStartIndex());
        dataTypeSegment.setStopIndex(ctx.stop.getStopIndex());
        if (null != ctx.dataTypeLength()) {
            DataTypeLengthSegment dataTypeLengthSegment = (DataTypeLengthSegment)this.visit((ParseTree)ctx.dataTypeLength());
            dataTypeSegment.setDataLength(dataTypeLengthSegment);
        }
        return dataTypeSegment;
    }

    @Override
    public final ASTNode visitDataTypeLength(MySQLStatementParser.DataTypeLengthContext ctx) {
        DataTypeLengthSegment dataTypeLengthSegment = new DataTypeLengthSegment();
        dataTypeLengthSegment.setStartIndex(ctx.start.getStartIndex());
        dataTypeLengthSegment.setStopIndex(ctx.stop.getStartIndex());
        List<TerminalNode> numbers = ctx.NUMBER_();
        if (numbers.size() == 1) {
            dataTypeLengthSegment.setPrecision(Integer.parseInt(numbers.get(0).getText()));
        }
        if (numbers.size() == 2) {
            dataTypeLengthSegment.setPrecision(Integer.parseInt(numbers.get(0).getText()));
            dataTypeLengthSegment.setScale(Integer.parseInt(numbers.get(1).getText()));
        }
        return dataTypeLengthSegment;
    }

    @Override
    public final ASTNode visitOrderByClause(MySQLStatementParser.OrderByClauseContext ctx) {
        LinkedList<OrderByItemSegment> items = new LinkedList<OrderByItemSegment>();
        for (MySQLStatementParser.OrderByItemContext each : ctx.orderByItem()) {
            items.add((OrderByItemSegment)this.visit((ParseTree)each));
        }
        return new OrderBySegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), items);
    }

    @Override
    public final ASTNode visitOrderByItem(MySQLStatementParser.OrderByItemContext ctx) {
        OrderDirection orderDirection;
        OrderDirection orderDirection2 = orderDirection = null != ctx.DESC() ? OrderDirection.DESC : OrderDirection.ASC;
        if (null != ctx.columnName()) {
            ColumnSegment column = (ColumnSegment)this.visit((ParseTree)ctx.columnName());
            return new ColumnOrderByItemSegment(column, orderDirection);
        }
        if (null != ctx.numberLiterals()) {
            return new IndexOrderByItemSegment(ctx.numberLiterals().getStart().getStartIndex(), ctx.numberLiterals().getStop().getStopIndex(), SQLUtil.getExactlyNumber((String)ctx.numberLiterals().getText(), (int)10).intValue(), orderDirection);
        }
        return new ExpressionOrderByItemSegment(ctx.expr().getStart().getStartIndex(), ctx.expr().getStop().getStopIndex(), ctx.expr().getText(), orderDirection);
    }

    @Generated
    protected int getCurrentParameterIndex() {
        return this.currentParameterIndex;
    }
}

