/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.servlet.contentencode;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.wink.common.internal.http.AcceptEncoding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentEncodingResponseFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(ContentEncodingResponseFilter.class);
    private static final RuntimeDelegate.HeaderDelegate<AcceptEncoding> acceptEncodingHeaderDelegate = RuntimeDelegate.getInstance().createHeaderDelegate(AcceptEncoding.class);

    public void init(FilterConfig arg0) throws ServletException {
        logger.trace("init({}) entry", (Object)arg0);
        logger.trace("init() exit");
    }

    public void destroy() {
        logger.trace("destroy() entry");
        logger.trace("destroy() exit");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        if (logger.isTraceEnabled()) {
            logger.trace("doFilter({}, {}, {}) entry", new Object[]{servletRequest, servletResponse, chain});
        }
        if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            AcceptEncoding acceptEncoding = ContentEncodingResponseFilter.getAcceptEncodingHeader(httpServletRequest);
            logger.trace("AcceptEncoding header was {}", (Object)acceptEncoding);
            if (acceptEncoding != null && (acceptEncoding.isAnyEncodingAllowed() || acceptEncoding.getAcceptableEncodings().size() > 0)) {
                logger.trace("AcceptEncoding header was set so wrapping HttpServletResponse");
                HttpServletResponseContentEncodingWrapperImpl wrappedServletResponse = new HttpServletResponseContentEncodingWrapperImpl((HttpServletResponse)servletResponse, acceptEncoding);
                logger.trace("Passing on request and response down the filter chain");
                chain.doFilter(servletRequest, (ServletResponse)wrappedServletResponse);
                logger.trace("Finished filter chain");
                EncodedOutputStream encodedOutputStream = wrappedServletResponse.getEncodedOutputStream();
                if (encodedOutputStream != null) {
                    logger.trace("Calling encodedOutputStream finish");
                    encodedOutputStream.finish();
                }
                logger.trace("doFilter exit()");
                return;
            }
        }
        logger.trace("AcceptEncoding header not found so processing like normal request");
        chain.doFilter(servletRequest, servletResponse);
        logger.trace("doFilter exit()");
    }

    static AcceptEncoding getAcceptEncodingHeader(HttpServletRequest httpServletRequest) {
        logger.trace("getAcceptEncodingHeader({}) entry", (Object)httpServletRequest);
        Enumeration acceptEncodingEnum = httpServletRequest.getHeaders("Accept-Encoding");
        StringBuilder sb = new StringBuilder();
        if (acceptEncodingEnum.hasMoreElements()) {
            sb.append((String)acceptEncodingEnum.nextElement());
            while (acceptEncodingEnum.hasMoreElements()) {
                sb.append(",");
                sb.append((String)acceptEncodingEnum.nextElement());
            }
            String acceptEncodingHeader = sb.toString();
            logger.trace("acceptEncodingHeader is {} so returning as AcceptEncodingHeader", (Object)acceptEncodingHeader);
            return (AcceptEncoding)acceptEncodingHeaderDelegate.fromString(acceptEncodingHeader);
        }
        logger.trace("No Accept-Encoding header");
        logger.trace("getAcceptEncodingHeader() exit - returning null");
        return null;
    }

    static class HttpServletResponseContentEncodingWrapperImpl
    extends HttpServletResponseWrapper {
        private static final Logger logger = LoggerFactory.getLogger(HttpServletResponseContentEncodingWrapperImpl.class);
        private final AcceptEncoding acceptEncoding;
        private ServletOutputStream outputStream;
        private EncodedOutputStream encodedOutputStream;
        private int varyHeaderCount = 0;

        public EncodedOutputStream getEncodedOutputStream() {
            return this.encodedOutputStream;
        }

        public HttpServletResponseContentEncodingWrapperImpl(HttpServletResponse response, AcceptEncoding acceptEncoding) {
            super(response);
            this.acceptEncoding = acceptEncoding;
        }

        private boolean containsAcceptEncoding(String value) {
            String[] str;
            for (String s : str = value.split(",")) {
                if (!"Accept-Encoding".equalsIgnoreCase(s.trim())) continue;
                return true;
            }
            return false;
        }

        public void addHeader(String name, String value) {
            logger.trace("addHeader({}, {}) entry", (Object)name, (Object)value);
            if ("Vary".equalsIgnoreCase(name)) {
                ++this.varyHeaderCount;
                logger.trace("Vary header count is now {}", (Object)this.varyHeaderCount);
                if (this.varyHeaderCount == 1) {
                    if (!"*".equals(value) && !this.containsAcceptEncoding(value)) {
                        logger.trace("Vary header did not contain Accept-Encoding so appending to Vary header value");
                        super.addHeader("Vary", value + ", " + "Accept-Encoding");
                        return;
                    }
                } else if ("Accept-Encoding".equals(value)) {
                    logger.trace("Skipping Vary header that was only Accept-Encoding since it was already appended to a previous Vary header value");
                    return;
                }
            }
            super.addHeader(name, value);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            logger.trace("getOutputStream() entry");
            if (this.outputStream == null) {
                logger.trace("output stream was null");
                this.outputStream = super.getOutputStream();
                List acceptableEncodings = this.acceptEncoding.getAcceptableEncodings();
                logger.trace("acceptableEncodings is {}", (Object)acceptableEncodings);
                for (String encoding : acceptableEncodings) {
                    logger.trace("encoding under test is {}", (Object)encoding);
                    if ("gzip".equalsIgnoreCase(encoding)) {
                        logger.trace("going to use gzip encoding");
                        this.encodedOutputStream = new GzipEncoderOutputStream((OutputStream)this.outputStream, (HttpServletResponse)this);
                        this.outputStream = this.encodedOutputStream;
                        logger.trace("getOutputStream() exit - returning gzipped encode stream");
                        return this.outputStream;
                    }
                    if (!"deflate".equalsIgnoreCase(encoding)) continue;
                    logger.trace("going to use deflate encoding");
                    this.encodedOutputStream = new DeflaterContentEncodedOutputStream((OutputStream)this.outputStream, (HttpServletResponse)this);
                    this.outputStream = this.encodedOutputStream;
                    logger.trace("getOutputStream() exit - returning deflate encode stream");
                    return this.outputStream;
                }
                if (this.acceptEncoding.isAnyEncodingAllowed() && !this.acceptEncoding.getBannedEncodings().contains("gzip")) {
                    logger.trace("going to use gzip encoding because any encoding is allowed");
                    this.encodedOutputStream = new GzipEncoderOutputStream((OutputStream)this.outputStream, (HttpServletResponse)this);
                    this.outputStream = this.encodedOutputStream;
                    logger.trace("getOutputStream() exit - returning gzipped encode stream");
                    return this.outputStream;
                }
            }
            logger.trace("getOutputStream() exit - returning output stream");
            return this.outputStream;
        }
    }

    static class DeflaterContentEncodedOutputStream
    extends EncodedOutputStream {
        private final HttpServletResponse response;

        public DeflaterContentEncodedOutputStream(OutputStream outputStream, HttpServletResponse response) throws IOException {
            super(new DeflaterOutputStream(outputStream));
            this.response = response;
        }

        public void isFirstWrite() {
            this.response.addHeader("Content-Encoding", "deflate");
            this.response.addHeader("Vary", "Accept-Encoding");
        }
    }

    static class GzipEncoderOutputStream
    extends EncodedOutputStream {
        private final HttpServletResponse response;

        public GzipEncoderOutputStream(OutputStream outputStream, HttpServletResponse response) throws IOException {
            super(new GZIPOutputStream(outputStream));
            this.response = response;
        }

        public void isFirstWrite() {
            this.response.addHeader("Content-Encoding", "gzip");
            this.response.addHeader("Vary", "Accept-Encoding");
        }
    }

    static abstract class EncodedOutputStream
    extends ServletOutputStream {
        private boolean isWritten = false;
        private DeflaterOutputStream outputStream;

        public EncodedOutputStream(DeflaterOutputStream outputStream) {
            this.outputStream = outputStream;
        }

        public void write(int b) throws IOException {
            if (!this.isWritten) {
                this.isFirstWrite();
                this.isWritten = true;
            }
            this.outputStream.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (!this.isWritten) {
                this.isFirstWrite();
                this.isWritten = true;
            }
            this.outputStream.write(b, off, len);
        }

        public void write(byte[] b) throws IOException {
            if (!this.isWritten) {
                this.isFirstWrite();
                this.isWritten = true;
            }
            this.outputStream.write(b);
        }

        public void flush() throws IOException {
            if (!this.isWritten) {
                this.isFirstWrite();
                this.isWritten = true;
            }
            this.outputStream.flush();
        }

        public void close() throws IOException {
            this.outputStream.finish();
            this.outputStream.close();
        }

        public void finish() throws IOException {
            this.outputStream.finish();
        }

        public abstract void isFirstWrite();
    }
}

