/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmaven.runtime.loader.realm;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.gmaven.feature.Provider;
import org.codehaus.gmaven.runtime.loader.realm.RealmManager;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.ClassWorldException;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.codehaus.plexus.classworlds.strategy.ParentFirstStrategy;
import org.codehaus.plexus.classworlds.strategy.Strategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRealmManager
implements RealmManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ClassWorld classWorld = new ClassWorld();
    private Map providerRealms = new HashMap();
    private int uniqueCounter = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ClassRealm createProviderRealm(String key, URL[] classPath, ClassLoader parent) throws ClassWorldException {
        if (!$assertionsDisabled && key == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && classPath == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        String id = Provider.class.getName() + "[" + key + "]";
        this.log.debug("Creating provider realm: {}", (Object)id);
        ClassRealm realm = this.classWorld.newRealm(id, parent);
        this.setupRealm(realm, classPath);
        this.providerRealms.put(key, realm);
        return realm;
    }

    private synchronized String uniqueId() {
        return System.currentTimeMillis() + ":" + this.uniqueCounter++;
    }

    public ClassRealm createComponentRealm(Provider provider, URL[] classPath) throws ClassWorldException {
        if (!$assertionsDisabled && provider == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && classPath == null) {
            throw new AssertionError();
        }
        String id = provider.getClass().getName() + "#component[" + this.uniqueId() + "]";
        this.log.debug("Creating component realm: {}", (Object)id);
        ClassRealm providerRealm = (ClassRealm)this.providerRealms.get(provider.key());
        if (providerRealm == null) {
            throw new Error("No realm for provider: " + provider);
        }
        this.log.debug("    Provider realm: {}", (Object)providerRealm.getId());
        ClassRealm realm = providerRealm.createChildRealm(id);
        this.setupRealm(realm, classPath);
        return realm;
    }

    public void releaseComponentRealm(ClassRealm realm) throws NoSuchRealmException {
        if (!$assertionsDisabled && realm == null) {
            throw new AssertionError();
        }
        this.log.debug("Releasing component realm: {}", (Object)realm.getId());
        this.classWorld.disposeRealm(realm.getId());
    }

    private void setupRealm(ClassRealm realm, URL[] classPath) {
        if (!$assertionsDisabled && realm == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && classPath == null) {
            throw new AssertionError();
        }
        this.setStrategy(realm, (Strategy)new ParentFirstStrategy(realm));
        for (int i = 0; i < classPath.length; ++i) {
            realm.addURL(classPath[i]);
            this.log.debug("    {}", (Object)classPath[i]);
        }
        if (this.log.isTraceEnabled()) {
            ByteArrayOutputStream buff = new ByteArrayOutputStream();
            realm.display(new PrintStream(buff, true));
            this.log.trace("Realm configuration:\n" + new String(buff.toByteArray()));
        }
    }

    private void setStrategy(ClassRealm realm, Strategy strategy) {
        if (!$assertionsDisabled && realm == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && strategy == null) {
            throw new AssertionError();
        }
        try {
            Field field = realm.getClass().getDeclaredField("strategy");
            try {
                field.set(realm, strategy);
            }
            catch (IllegalAccessException ignore) {
                field.setAccessible(true);
                try {
                    field.set(realm, strategy);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalAccessError(e.getMessage());
                }
            }
        }
        catch (NoSuchFieldException e) {
            throw new Error(e);
        }
    }

    static {
        $assertionsDisabled = !DefaultRealmManager.class.desiredAssertionStatus();
    }
}

