/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.transform.BaseScript;
import java.util.Arrays;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.SEMANTIC_ANALYSIS)
public class BaseScriptASTTransformation
extends AbstractASTTransformation {
    private static final Class<BaseScript> MY_CLASS = BaseScript.class;
    private static final ClassNode MY_TYPE = ClassHelper.make(MY_CLASS);
    private static final String MY_TYPE_NAME = "@" + MY_TYPE.getNameWithoutPackage();
    private SourceUnit sourceUnit;

    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.sourceUnit = source;
        if (nodes.length != 2 || !(nodes[0] instanceof AnnotationNode) || !(nodes[1] instanceof AnnotatedNode)) {
            throw new GroovyBugError("Internal error: expecting [AnnotationNode, AnnotatedNode] but got: " + Arrays.asList(nodes));
        }
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        AnnotationNode node = (AnnotationNode)nodes[0];
        if (!MY_TYPE.equals(node.getClassNode())) {
            return;
        }
        if (parent instanceof DeclarationExpression) {
            DeclarationExpression de = (DeclarationExpression)parent;
            ClassNode cNode = de.getDeclaringClass();
            if (!cNode.isScript()) {
                this.addError("Annotation " + MY_TYPE_NAME + " can only be used within a Script.", parent);
                return;
            }
            if (de.isMultipleAssignmentDeclaration()) {
                this.addError("Annotation " + MY_TYPE_NAME + " not supported with multiple assignment notation.", parent);
                return;
            }
            if (!(de.getRightExpression() instanceof EmptyExpression)) {
                this.addError("Annotation " + MY_TYPE_NAME + " not supported with variable assignment.", parent);
                return;
            }
            ClassNode baseScriptType = de.getVariableExpression().getType().getPlainNodeReference();
            if (!baseScriptType.isScript()) {
                this.addError("Declared type " + baseScriptType + " does not extend groovy.lang.Script class!", parent);
                return;
            }
            cNode.setSuperClass(baseScriptType);
            de.setRightExpression(new VariableExpression("this"));
        }
    }

    public SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    protected void addError(String msg, ASTNode expr) {
        this.sourceUnit.getErrorCollector().addErrorAndContinue(new SyntaxErrorMessage(new SyntaxException(msg + '\n', expr.getLineNumber(), expr.getColumnNumber(), expr.getLastLineNumber(), expr.getLastColumnNumber()), this.sourceUnit));
    }
}

