/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dependency;

import java.io.File;
import java.io.IOException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.util.FileUtils;

public class DependencyUtil {
    protected static void copyFile(File artifact, File destFile, Log log) throws MojoExecutionException {
        if (!destFile.exists()) {
            try {
                log.info((CharSequence)("Copying " + artifact.getAbsolutePath() + " to " + destFile));
                FileUtils.copyFile((File)artifact, (File)destFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error copying artifact from " + artifact + " to " + destFile, (Exception)e);
            }
        } else {
            log.info((CharSequence)(artifact.getName() + " already exists."));
        }
    }

    protected static void unpackFile(Artifact artifact, File unpackDirectory, File markersDirectory, ArchiverManager archiverManager, Log log) throws MojoExecutionException {
        markersDirectory.mkdirs();
        File markerFile = new File(markersDirectory, artifact.getGroupId() + "." + artifact.getArtifactId() + "-" + artifact.getVersion() + ".unpacked");
        if (!markerFile.exists()) {
            try {
                unpackDirectory.mkdirs();
                DependencyUtil.unpack(artifact.getFile(), unpackDirectory, archiverManager, log);
                markerFile.getParentFile().mkdirs();
                markerFile.createNewFile();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error creating marker file: " + markerFile);
            }
        } else {
            log.info((CharSequence)(artifact.getFile().getName() + " already unpacked."));
        }
    }

    private static void unpack(File file, File location, ArchiverManager archiverManager, Log log) throws MojoExecutionException {
        String archiveExt = FileUtils.getExtension((String)file.getAbsolutePath()).toLowerCase();
        try {
            UnArchiver unArchiver = archiverManager.getUnArchiver(archiveExt);
            unArchiver.setSourceFile(file);
            unArchiver.setDestDirectory(location);
            unArchiver.extract();
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("Unknown archiver type", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error unpacking file: " + file + "to: " + location, (Exception)e);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error unpacking file: " + file + "to: " + location, (Exception)((Object)e));
        }
    }

    public static String getFormattedFileName(Artifact artifact, boolean removeVersion) {
        String destFileName = null;
        destFileName = !removeVersion ? artifact.getFile().getName() : (artifact.getClassifier() != null ? artifact.getArtifactId() + "-" + artifact.getClassifier() + "." + artifact.getType() : artifact.getArtifactId() + "." + artifact.getType());
        return destFileName;
    }
}

