/*
 * Decompiled with CFR 0.152.
 */
package org.drools.commands.runtime.process;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.command.ProcessInstanceIdCommand;
import org.kie.internal.command.RegistryContext;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class GetProcessInstanceCommand
implements ExecutableCommand<ProcessInstance>,
ProcessInstanceIdCommand {
    private static final long serialVersionUID = 5890677592835087670L;
    @XmlAttribute(required=true)
    private String processInstanceId;
    @XmlAttribute
    private boolean readOnly = false;
    @XmlAttribute(name="out-identifier")
    private String outIdentifier;

    public GetProcessInstanceCommand() {
    }

    public GetProcessInstanceCommand(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getOutIdentifier() {
        return this.outIdentifier;
    }

    public void setOutIdentifier(String outIdentifier) {
        this.outIdentifier = outIdentifier;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public ProcessInstance execute(Context context) {
        KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        if (this.processInstanceId == null) {
            return null;
        }
        ProcessInstance processInstance = ksession.getProcessInstance(this.processInstanceId, this.readOnly);
        if (this.outIdentifier != null) {
            ((ExecutionResults)((RegistryContext)context).lookup(ExecutionResults.class)).setResult(this.outIdentifier, (Object)processInstance);
        }
        return processInstance;
    }

    public String toString() {
        return "session.getProcessInstance(" + this.processInstanceId + ");";
    }
}

