/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class AsyncHttpConnection
extends HttpConnection {
    private static final int NO_PROGRESS_INFO = Integer.getInteger("org.mortbay.jetty.NO_PROGRESS_INFO", 100);
    private static final int NO_PROGRESS_CLOSE = Integer.getInteger("org.mortbay.jetty.NO_PROGRESS_CLOSE", 200);
    private static final Logger LOG = Log.getLogger(AsyncHttpConnection.class);
    private int _total_no_progress;

    public AsyncHttpConnection(Connector connector, EndPoint endpoint, Server server) {
        super(connector, endpoint, server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Connection handle() throws IOException {
        connection /* !! */  = this;
        some_progress = false;
        progress = true;
        try {
            AsyncHttpConnection.setCurrentConnection(this);
            more_in_buffer = false;
            while (this._endp.isOpen() && (more_in_buffer || progress) && connection /* !! */  == this) {
                progress = false;
                try {
                    if (this._request._async.isAsync() && !this._request._async.isComplete()) {
                        this.handleRequest();
                    } else if (!this._parser.isComplete() && this._parser.parseAvailable() > 0) {
                        progress = true;
                    }
                    if (this._generator.isCommitted() && !this._generator.isComplete() && this._generator.flushBuffer() > 0L) {
                        progress = true;
                    }
                    if (this._endp.isBufferingOutput()) {
                        this._endp.flush();
                    }
                    if (!progress && !some_progress && (this._endp.isInputShutdown() || this._endp.isOutputShutdown())) {
                        this._endp.close();
                    }
                    if (!this._endp.isInputShutdown() || !this._parser.isIdle() && !this._parser.isComplete()) ** GOTO lbl64
                    ** GOTO lbl59
                }
                catch (HttpException e) {
                    block40: {
                        block38: {
                            block39: {
                                try {
                                    if (AsyncHttpConnection.LOG.isDebugEnabled()) {
                                        AsyncHttpConnection.LOG.debug("uri=" + this._uri, new Object[0]);
                                        AsyncHttpConnection.LOG.debug("fields=" + this._requestFields, new Object[0]);
                                        AsyncHttpConnection.LOG.debug(e);
                                    }
                                    this._generator.sendError(e.getStatus(), e.getReason(), null, true);
                                    this._parser.reset();
                                    this._endp.close();
                                    if (this._endp.isInputShutdown() && (this._parser.isIdle() || this._parser.isComplete())) {
                                    }
                                    break block38;
                                }
                                catch (Throwable var6_7) {
                                    if (this._endp.isInputShutdown() && (this._parser.isIdle() || this._parser.isComplete())) {
                                        AsyncHttpConnection.LOG.debug("complete half close {}", new Object[]{this});
                                        more_in_buffer = false;
                                        this._endp.close();
                                        this.reset(true);
                                    } else if (this._parser.isComplete() && this._generator.isComplete() && !this._endp.isBufferingOutput()) {
                                        if (this._response.getStatus() == 101 && (switched = (Connection)this._request.getAttribute("org.eclipse.jetty.io.Connection")) != null) {
                                            this._parser.reset();
                                            this._generator.reset(true);
                                            connection /* !! */  = switched;
                                        }
                                        progress = true;
                                        this.reset(false);
                                        more_in_buffer = this._parser.isMoreInBuffer() != false || this._endp.isBufferingInput() != false;
                                    } else if (this._request.isAsyncStarted()) {
                                        AsyncHttpConnection.LOG.debug("suspended {}", new Object[]{this});
                                        more_in_buffer = false;
                                        progress = false;
                                    } else {
                                        more_in_buffer = this._parser.isMoreInBuffer() != false || this._endp.isBufferingInput() != false;
                                    }
                                    some_progress |= progress | ((SelectChannelEndPoint)this._endp).isProgressing();
                                    throw var6_7;
                                }
lbl59:
                                // 1 sources

                                AsyncHttpConnection.LOG.debug("complete half close {}", new Object[]{this});
                                more_in_buffer = false;
                                this._endp.close();
                                this.reset(true);
                                break block39;
lbl64:
                                // 1 sources

                                if (this._parser.isComplete() && this._generator.isComplete() && !this._endp.isBufferingOutput()) {
                                    if (this._response.getStatus() == 101 && (switched = (Connection)this._request.getAttribute("org.eclipse.jetty.io.Connection")) != null) {
                                        this._parser.reset();
                                        this._generator.reset(true);
                                        connection /* !! */  = switched;
                                    }
                                    progress = true;
                                    this.reset(false);
                                    more_in_buffer = this._parser.isMoreInBuffer() != false || this._endp.isBufferingInput() != false;
                                } else if (this._request.isAsyncStarted()) {
                                    AsyncHttpConnection.LOG.debug("suspended {}", new Object[]{this});
                                    more_in_buffer = false;
                                    progress = false;
                                } else {
                                    more_in_buffer = this._parser.isMoreInBuffer() != false || this._endp.isBufferingInput() != false;
                                }
                            }
                            some_progress |= progress | ((SelectChannelEndPoint)this._endp).isProgressing();
                            continue;
                            AsyncHttpConnection.LOG.debug("complete half close {}", new Object[]{this});
                            more_in_buffer = false;
                            this._endp.close();
                            this.reset(true);
                            break block40;
                        }
                        if (this._parser.isComplete() && this._generator.isComplete() && !this._endp.isBufferingOutput()) {
                            if (this._response.getStatus() == 101 && (switched = (Connection)this._request.getAttribute("org.eclipse.jetty.io.Connection")) != null) {
                                this._parser.reset();
                                this._generator.reset(true);
                                connection /* !! */  = switched;
                            }
                            progress = true;
                            this.reset(false);
                            more_in_buffer = this._parser.isMoreInBuffer() != false || this._endp.isBufferingInput() != false;
                        } else if (this._request.isAsyncStarted()) {
                            AsyncHttpConnection.LOG.debug("suspended {}", new Object[]{this});
                            more_in_buffer = false;
                            progress = false;
                        } else {
                            more_in_buffer = this._parser.isMoreInBuffer() != false || this._endp.isBufferingInput() != false;
                        }
                    }
                    some_progress |= progress | ((SelectChannelEndPoint)this._endp).isProgressing();
                }
            }
        }
        catch (Throwable var8_9) {
            AsyncHttpConnection.setCurrentConnection(null);
            this._parser.returnBuffers();
            this._generator.returnBuffers();
            if (this._generator.isCommitted() && !this._generator.isComplete() && this._endp.isOpen() && !this._endp.isOutputShutdown()) {
                ((AsyncEndPoint)this._endp).scheduleWrite();
            }
            if (some_progress) {
                this._total_no_progress = 0;
                throw var8_9;
            }
            totalNoProgress = ++this._total_no_progress;
            if (AsyncHttpConnection.NO_PROGRESS_INFO > 0 && totalNoProgress == AsyncHttpConnection.NO_PROGRESS_INFO && (AsyncHttpConnection.NO_PROGRESS_CLOSE <= 0 || totalNoProgress < AsyncHttpConnection.NO_PROGRESS_CLOSE)) {
                AsyncHttpConnection.LOG.info("EndPoint making no progress: {} {}", new Object[]{totalNoProgress, this._endp});
            }
            if (AsyncHttpConnection.NO_PROGRESS_CLOSE <= 0) throw var8_9;
            if (totalNoProgress != AsyncHttpConnection.NO_PROGRESS_CLOSE) throw var8_9;
            AsyncHttpConnection.LOG.warn("Closing EndPoint making no progress: {} {}", new Object[]{totalNoProgress, this._endp});
            if (this._endp instanceof SelectChannelEndPoint == false) throw var8_9;
            System.err.println(((SelectChannelEndPoint)this._endp).getSelectManager().dump());
            ((SelectChannelEndPoint)this._endp).getChannel().close();
            throw var8_9;
        }
        AsyncHttpConnection.setCurrentConnection(null);
        this._parser.returnBuffers();
        this._generator.returnBuffers();
        if (this._generator.isCommitted() && !this._generator.isComplete() && this._endp.isOpen() && !this._endp.isOutputShutdown()) {
            ((AsyncEndPoint)this._endp).scheduleWrite();
        }
        if (some_progress) {
            this._total_no_progress = 0;
            return connection /* !! */ ;
        }
        totalNoProgress = ++this._total_no_progress;
        if (AsyncHttpConnection.NO_PROGRESS_INFO > 0 && totalNoProgress == AsyncHttpConnection.NO_PROGRESS_INFO && (AsyncHttpConnection.NO_PROGRESS_CLOSE <= 0 || totalNoProgress < AsyncHttpConnection.NO_PROGRESS_CLOSE)) {
            AsyncHttpConnection.LOG.info("EndPoint making no progress: {} {}", new Object[]{totalNoProgress, this._endp});
        }
        if (AsyncHttpConnection.NO_PROGRESS_CLOSE <= 0) return connection /* !! */ ;
        if (totalNoProgress != AsyncHttpConnection.NO_PROGRESS_CLOSE) return connection /* !! */ ;
        AsyncHttpConnection.LOG.warn("Closing EndPoint making no progress: {} {}", new Object[]{totalNoProgress, this._endp});
        if (this._endp instanceof SelectChannelEndPoint == false) return connection /* !! */ ;
        System.err.println(((SelectChannelEndPoint)this._endp).getSelectManager().dump());
        ((SelectChannelEndPoint)this._endp).getChannel().close();
        return connection /* !! */ ;
    }
}

