/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.io.ChannelEndPoint;
import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.SpinLock;

public class SelectChannelEndPoint
extends ChannelEndPoint
implements ManagedSelector.SelectableEndPoint {
    public static final Logger LOG = Log.getLogger(SelectChannelEndPoint.class);
    private final SpinLock _lock = new SpinLock();
    private boolean _updatePending;
    private final AtomicBoolean _open = new AtomicBoolean();
    private final ManagedSelector _selector;
    private final SelectionKey _key;
    private int _interestOps;
    private final Runnable _runUpdateKey = new Runnable(){

        @Override
        public void run() {
            SelectChannelEndPoint.this.updateKey();
        }
    };
    private final Runnable _runFillable = new Runnable(){

        @Override
        public void run() {
            SelectChannelEndPoint.this.getFillInterest().fillable();
        }
    };
    private final Runnable _runCompleteWrite = new Runnable(){

        @Override
        public void run() {
            SelectChannelEndPoint.this.getWriteFlusher().completeWrite();
        }
    };
    private final Runnable _runFillableCompleteWrite = new Runnable(){

        @Override
        public void run() {
            SelectChannelEndPoint.this.getFillInterest().fillable();
            SelectChannelEndPoint.this.getWriteFlusher().completeWrite();
        }
    };

    public SelectChannelEndPoint(SocketChannel channel, ManagedSelector selector, SelectionKey key, Scheduler scheduler, long idleTimeout) {
        super(scheduler, channel);
        this._selector = selector;
        this._key = key;
        this.setIdleTimeout(idleTimeout);
    }

    @Override
    protected void needsFillInterest() {
        this.changeInterests(1);
    }

    @Override
    protected void onIncompleteFlush() {
        this.changeInterests(4);
    }

    @Override
    public Runnable onSelected() {
        boolean writable;
        int newInterestOps;
        int oldInterestOps;
        int readyOps;
        try (SpinLock.Lock lock = this._lock.lock();){
            this._updatePending = true;
            readyOps = this._key.readyOps();
            oldInterestOps = this._interestOps;
            this._interestOps = newInterestOps = oldInterestOps & ~readyOps;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("onSelected {}->{} for {}", oldInterestOps, newInterestOps, this);
        }
        boolean readable = (readyOps & 1) != 0;
        boolean bl = writable = (readyOps & 4) != 0;
        return readable ? (writable ? this._runFillableCompleteWrite : this._runFillable) : (writable ? this._runCompleteWrite : null);
    }

    @Override
    public void updateKey() {
        try {
            int newInterestOps;
            int oldInterestOps;
            try (SpinLock.Lock lock = this._lock.lock();){
                this._updatePending = false;
                oldInterestOps = this._key.interestOps();
                newInterestOps = this._interestOps;
                if (oldInterestOps != newInterestOps) {
                    this._key.interestOps(newInterestOps);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Key interests updated {} -> {} on {}", oldInterestOps, newInterestOps, this);
            }
        }
        catch (CancelledKeyException x) {
            LOG.debug("Ignoring key update for concurrently closed channel {}", this);
            this.close();
        }
        catch (Throwable x) {
            LOG.warn("Ignoring key update for " + this, x);
            this.close();
        }
    }

    private void changeInterests(int operation) {
        int newInterestOps;
        int oldInterestOps;
        boolean pending;
        try (SpinLock.Lock lock = this._lock.lock();){
            pending = this._updatePending;
            oldInterestOps = this._interestOps;
            newInterestOps = oldInterestOps | operation;
            if (newInterestOps != oldInterestOps) {
                this._interestOps = newInterestOps;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("changeInterests p={} {}->{} for {}", pending, oldInterestOps, newInterestOps, this);
        }
        if (!pending) {
            this._selector.submit(this._runUpdateKey);
        }
    }

    @Override
    public void close() {
        if (this._open.compareAndSet(true, false)) {
            super.close();
            this._selector.destroyEndPoint(this);
        }
    }

    @Override
    public boolean isOpen() {
        return this._open.get();
    }

    @Override
    public void onOpen() {
        if (this._open.compareAndSet(false, true)) {
            super.onOpen();
        }
    }

    @Override
    public String toString() {
        try {
            boolean valid = this._key != null && this._key.isValid();
            int keyInterests = valid ? this._key.interestOps() : -1;
            int keyReadiness = valid ? this._key.readyOps() : -1;
            return String.format("%s{io=%d,kio=%d,kro=%d}", super.toString(), this._interestOps, keyInterests, keyReadiness);
        }
        catch (Throwable x) {
            return String.format("%s{io=%s,kio=-2,kro=-2}", super.toString(), this._interestOps);
        }
    }
}

