/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jetty.start.Module;
import org.eclipse.jetty.start.NaturalSort;
import org.eclipse.jetty.start.StartLog;
import org.eclipse.jetty.start.Utils;

public class Licensing {
    private static final String PROP_ACK_LICENSES = "org.eclipse.jetty.start.ack.licenses";
    public Map<String, List<String>> licenseMap = new TreeMap<String, List<String>>(new NaturalSort.Strings());

    public void addModule(Module module) {
        if (!module.hasLicense()) {
            return;
        }
        if (this.licenseMap.containsKey(module.getName())) {
            return;
        }
        this.licenseMap.put(module.getName(), module.getLicense());
    }

    public boolean hasLicenses() {
        return !this.licenseMap.isEmpty();
    }

    public boolean acknowledgeLicenses() throws IOException {
        if (!this.hasLicenses()) {
            return true;
        }
        System.err.printf("%nALERT: There are enabled module(s) with licenses.%n", new Object[0]);
        System.err.printf("The following %d module(s):%n", this.licenseMap.size());
        System.err.printf(" + contains software not provided by the Eclipse Foundation!%n", new Object[0]);
        System.err.printf(" + contains software not covered by the Eclipse Public License!%n", new Object[0]);
        System.err.printf(" + has not been audited for compliance with its license%n", new Object[0]);
        for (String key : this.licenseMap.keySet()) {
            System.err.printf("%n Module: %s%n", key);
            for (String line : this.licenseMap.get(key)) {
                System.err.printf("  + %s%n", line);
            }
        }
        boolean licenseAck = false;
        String propBasedAckValue = System.getProperty(PROP_ACK_LICENSES);
        if (propBasedAckValue != null) {
            StartLog.log("TESTING MODE", "Programmatic ACK - %s=%s", PROP_ACK_LICENSES, propBasedAckValue);
            licenseAck = Boolean.parseBoolean(propBasedAckValue);
        } else {
            if (Boolean.getBoolean("org.eclipse.jetty.start.testing")) {
                throw new RuntimeException("Test Configuration Missing - Pre-specify answer to (org.eclipse.jetty.start.ack.licenses) in test case");
            }
            BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
            System.err.printf("%nProceed (y/N)? ", new Object[0]);
            String response = input.readLine();
            licenseAck = Utils.isNotBlank(response) && response.toLowerCase().startsWith("y");
        }
        return licenseAck;
    }
}

