/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

public class Version
implements Comparable<Version> {
    private int _version = 0;
    private int _revision = -1;
    private int _subrevision = -1;
    private String _suffix = "";

    public Version(String version_string) {
        this.parse(version_string);
    }

    @Override
    public int compareTo(Version other) {
        if (other == null) {
            throw new NullPointerException("other version is null");
        }
        if (this._version < other._version) {
            return -1;
        }
        if (this._version > other._version) {
            return 1;
        }
        if (this._revision < other._revision) {
            return -1;
        }
        if (this._revision > other._revision) {
            return 1;
        }
        if (this._subrevision < other._subrevision) {
            return -1;
        }
        if (this._subrevision > other._subrevision) {
            return 1;
        }
        return 0;
    }

    public boolean isNewerThan(Version other) {
        return this.compareTo(other) == 1;
    }

    public boolean isNewerThanOrEqualTo(Version other) {
        int comp = this.compareTo(other);
        return comp == 0 || comp == 1;
    }

    public boolean isOlderThan(Version other) {
        return this.compareTo(other) == -1;
    }

    public boolean isOlderThanOrEqualTo(Version other) {
        int comp = this.compareTo(other);
        return comp == 0 || comp == -1;
    }

    public boolean isInRange(Version low, Version high) {
        return this.compareTo(low) >= 0 && this.compareTo(high) <= 0;
    }

    public void parse(String version_string) {
        int pos;
        this._version = 0;
        this._revision = -1;
        this._subrevision = -1;
        this._suffix = "";
        int startpos = 0;
        int endpos = version_string.length();
        for (pos = 0; pos < endpos && Character.isDigit(version_string.charAt(pos)); ++pos) {
        }
        this._version = Integer.parseInt(version_string.substring(startpos, pos));
        if (pos < endpos && version_string.charAt(pos) == '.') {
            startpos = ++pos;
            while (pos < endpos && Character.isDigit(version_string.charAt(pos))) {
                ++pos;
            }
            this._revision = Integer.parseInt(version_string.substring(startpos, pos));
        }
        if (pos < endpos && version_string.charAt(pos) == '.') {
            startpos = ++pos;
            while (pos < endpos && Character.isDigit(version_string.charAt(pos))) {
                ++pos;
            }
            this._subrevision = Integer.parseInt(version_string.substring(startpos, pos));
        }
        if (pos < endpos) {
            this._suffix = version_string.substring(pos);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(10);
        sb.append(this._version);
        if (this._revision >= 0) {
            sb.append('.');
            sb.append(this._revision);
            if (this._subrevision >= 0) {
                sb.append('.');
                sb.append(this._subrevision);
                sb.append(this._suffix);
            }
        }
        return sb.toString();
    }
}

