/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import org.exparity.hamcrest.date.core.IsAfter;
import org.exparity.hamcrest.date.core.IsBefore;
import org.exparity.hamcrest.date.core.IsDayOfMonth;
import org.exparity.hamcrest.date.core.IsDayOfWeek;
import org.exparity.hamcrest.date.core.IsFirstDayOfMonth;
import org.exparity.hamcrest.date.core.IsHour;
import org.exparity.hamcrest.date.core.IsLastDayOfMonth;
import org.exparity.hamcrest.date.core.IsLeapYear;
import org.exparity.hamcrest.date.core.IsMaximum;
import org.exparity.hamcrest.date.core.IsMinimum;
import org.exparity.hamcrest.date.core.IsMinute;
import org.exparity.hamcrest.date.core.IsMonth;
import org.exparity.hamcrest.date.core.IsSame;
import org.exparity.hamcrest.date.core.IsSameDay;
import org.exparity.hamcrest.date.core.IsSameOrAfter;
import org.exparity.hamcrest.date.core.IsSameOrBefore;
import org.exparity.hamcrest.date.core.IsSecond;
import org.exparity.hamcrest.date.core.IsWithin;
import org.exparity.hamcrest.date.core.IsYear;
import org.exparity.hamcrest.date.core.TemporalConverters;
import org.exparity.hamcrest.date.core.TemporalFunctions;
import org.exparity.hamcrest.date.core.TemporalMatcher;
import org.exparity.hamcrest.date.core.TemporalProviders;
import org.exparity.hamcrest.date.core.types.Interval;
import org.hamcrest.Factory;

public abstract class OffsetDateTimeMatchers {
    public static TemporalMatcher<OffsetDateTime> after(OffsetDateTime date) {
        return new IsAfter<OffsetDateTime, OffsetDateTime>(TemporalConverters.OFFSETDATETIME_AS_OFFSETDATETIME, TemporalProviders.offsetDateTime(date), TemporalFunctions.OFFSETDATETIME);
    }

    public static TemporalMatcher<OffsetDateTime> after(int year, Month month, int dayOfMonth, int hour, int minute, int second, int nanos, ZoneOffset tz) {
        return OffsetDateTimeMatchers.after(OffsetDateTime.of(year, month.getValue(), dayOfMonth, hour, minute, second, nanos, tz));
    }

    public static TemporalMatcher<OffsetDateTime> before(OffsetDateTime date) {
        return new IsBefore<OffsetDateTime, OffsetDateTime>(TemporalConverters.OFFSETDATETIME_AS_OFFSETDATETIME, TemporalProviders.offsetDateTime(date), TemporalFunctions.OFFSETDATETIME);
    }

    public static TemporalMatcher<OffsetDateTime> before(int year, Month month, int dayOfMonth, int hour, int minute, int second, int nanos, ZoneOffset tz) {
        return OffsetDateTimeMatchers.before(OffsetDateTime.of(year, month.getValue(), dayOfMonth, hour, minute, second, nanos, tz));
    }

    public static TemporalMatcher<OffsetDateTime> sameDay(OffsetDateTime date) {
        return new IsSameDay<OffsetDateTime>(TemporalConverters.OFFSETDATETIME_AS_LOCALDATE, TemporalProviders.localDate(date));
    }

    public static TemporalMatcher<OffsetDateTime> isDay(LocalDate date) {
        return new IsSameDay<OffsetDateTime>(TemporalConverters.OFFSETDATETIME_AS_LOCALDATE, TemporalProviders.localDate(date));
    }

    public static TemporalMatcher<OffsetDateTime> isDay(int year, Month month, int dayOfMonth) {
        return OffsetDateTimeMatchers.isDay(LocalDate.of(year, month, dayOfMonth));
    }

    public static TemporalMatcher<OffsetDateTime> isDay(int year, Month month, int dayOfMonth, ZoneId zone) {
        return OffsetDateTimeMatchers.isDay(LocalDate.of(year, month, dayOfMonth)).atZone(zone);
    }

    public static TemporalMatcher<OffsetDateTime> sameInstant(OffsetDateTime date) {
        return new IsSame<OffsetDateTime, OffsetDateTime>(TemporalConverters.OFFSETDATETIME_AS_OFFSETDATETIME, TemporalProviders.offsetDateTime(date), TemporalFunctions.OFFSETDATETIME);
    }

    public static TemporalMatcher<OffsetDateTime> isInstant(int year, Month month, int dayOfMonth, int hour, int minute, int second, int nanos, ZoneOffset tz) {
        return OffsetDateTimeMatchers.sameInstant(OffsetDateTime.of(year, month.getValue(), dayOfMonth, hour, minute, second, nanos, tz));
    }

    public static TemporalMatcher<OffsetDateTime> sameOrBefore(OffsetDateTime date) {
        return new IsSameOrBefore<OffsetDateTime, OffsetDateTime>(TemporalConverters.OFFSETDATETIME_AS_OFFSETDATETIME, TemporalProviders.offsetDateTime(date), TemporalFunctions.OFFSETDATETIME);
    }

    @Factory
    public static TemporalMatcher<OffsetDateTime> sameOrBefore(int year, Month month, int day, int hour, int minute, int second, int nanos, ZoneOffset tz) {
        return OffsetDateTimeMatchers.sameOrBefore(OffsetDateTime.of(year, month.getValue(), day, hour, minute, second, nanos, tz));
    }

    public static TemporalMatcher<OffsetDateTime> sameOrAfter(OffsetDateTime date) {
        return new IsSameOrAfter<OffsetDateTime, OffsetDateTime>(TemporalConverters.OFFSETDATETIME_AS_OFFSETDATETIME, TemporalProviders.offsetDateTime(date), TemporalFunctions.OFFSETDATETIME);
    }

    @Factory
    public static TemporalMatcher<OffsetDateTime> sameOrAfter(int year, Month month, int day, int hour, int minute, int second, int nanos, ZoneOffset tz) {
        return OffsetDateTimeMatchers.sameOrAfter(OffsetDateTime.of(year, month.getValue(), day, hour, minute, second, nanos, tz));
    }

    public static TemporalMatcher<OffsetDateTime> sameMonthOfYear(OffsetDateTime date) {
        return new IsMonth<OffsetDateTime>(TemporalConverters.OFFSETDATETIME_AS_MONTH, TemporalProviders.month(date));
    }

    public static TemporalMatcher<OffsetDateTime> sameDayOfMonth(OffsetDateTime date) {
        return new IsDayOfMonth<OffsetDateTime>(TemporalConverters.OFFSETDATETIME_AS_DAYOFMONTH, TemporalProviders.dayOfMonth(date));
    }

    public static TemporalMatcher<OffsetDateTime> isDayOfMonth(int dayOfMonth) {
        return new IsDayOfMonth<OffsetDateTime>(TemporalConverters.OFFSETDATETIME_AS_DAYOFMONTH, TemporalProviders.dayOfMonth(dayOfMonth));
    }

    public static TemporalMatcher<OffsetDateTime> sameYear(OffsetDateTime date) {
        return OffsetDateTimeMatchers.isYear(date.getYear());
    }

    public static TemporalMatcher<OffsetDateTime> isYear(int year) {
        return new IsYear<OffsetDateTime>(TemporalConverters.OFFSETDATETIME_AS_YEAR, TemporalProviders.year(year));
    }

    public static TemporalMatcher<OffsetDateTime> within(long period, ChronoUnit unit, OffsetDateTime date) {
        return new IsWithin<OffsetDateTime, OffsetDateTime>(Interval.of(period, unit), TemporalConverters.OFFSETDATETIME_AS_OFFSETDATETIME, TemporalProviders.offsetDateTime(date), TemporalFunctions.OFFSETDATETIME);
    }

    public static TemporalMatcher<OffsetDateTime> within(long period, ChronoUnit unit, int year, Month month, int dayofMonth, int hour, int minute, int second, int nanos, ZoneOffset tz) {
        return OffsetDateTimeMatchers.within(period, unit, OffsetDateTime.of(year, month.getValue(), dayofMonth, hour, minute, second, nanos, tz));
    }

    public static TemporalMatcher<OffsetDateTime> isYesterday() {
        return OffsetDateTimeMatchers.sameDay(OffsetDateTime.now().plusDays(-1L));
    }

    public static TemporalMatcher<OffsetDateTime> isToday() {
        return OffsetDateTimeMatchers.sameDay(OffsetDateTime.now());
    }

    public static TemporalMatcher<OffsetDateTime> isTomorrow() {
        return OffsetDateTimeMatchers.sameDay(OffsetDateTime.now().plusDays(1L));
    }

    public static TemporalMatcher<OffsetDateTime> sameDayOfWeek(OffsetDateTime date) {
        return OffsetDateTimeMatchers.isDayOfWeek(DayOfWeek.from(date));
    }

    public static TemporalMatcher<OffsetDateTime> isDayOfWeek(DayOfWeek dayOfWeek) {
        return new IsDayOfWeek<OffsetDateTime>(TemporalConverters.OFFSETDATETIME_AS_DAYOFWEEK, TemporalProviders.daysOfWeek(dayOfWeek));
    }

    public static TemporalMatcher<OffsetDateTime> isDayOfWeek(DayOfWeek ... daysOfWeek) {
        return new IsDayOfWeek<OffsetDateTime>(TemporalConverters.OFFSETDATETIME_AS_DAYOFWEEK, TemporalProviders.daysOfWeek(daysOfWeek));
    }

    public static TemporalMatcher<OffsetDateTime> isMonday() {
        return OffsetDateTimeMatchers.isDayOfWeek(DayOfWeek.MONDAY);
    }

    public static TemporalMatcher<OffsetDateTime> isTuesday() {
        return OffsetDateTimeMatchers.isDayOfWeek(DayOfWeek.TUESDAY);
    }

    public static TemporalMatcher<OffsetDateTime> isWednesday() {
        return OffsetDateTimeMatchers.isDayOfWeek(DayOfWeek.WEDNESDAY);
    }

    public static TemporalMatcher<OffsetDateTime> isThursday() {
        return OffsetDateTimeMatchers.isDayOfWeek(DayOfWeek.THURSDAY);
    }

    public static TemporalMatcher<OffsetDateTime> isFriday() {
        return OffsetDateTimeMatchers.isDayOfWeek(DayOfWeek.FRIDAY);
    }

    public static TemporalMatcher<OffsetDateTime> isSaturday() {
        return OffsetDateTimeMatchers.isDayOfWeek(DayOfWeek.SATURDAY);
    }

    public static TemporalMatcher<OffsetDateTime> isSunday() {
        return OffsetDateTimeMatchers.isDayOfWeek(DayOfWeek.SUNDAY);
    }

    public static TemporalMatcher<OffsetDateTime> isWeekday() {
        return OffsetDateTimeMatchers.isDayOfWeek(DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY);
    }

    public static TemporalMatcher<OffsetDateTime> isWeekend() {
        return OffsetDateTimeMatchers.isDayOfWeek(DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    public static TemporalMatcher<OffsetDateTime> isFirstDayOfMonth() {
        return new IsFirstDayOfMonth<OffsetDateTime>(TemporalConverters.OFFSETDATETIME_AS_OFFSETDATETIME);
    }

    public static TemporalMatcher<OffsetDateTime> isMinimum(ChronoField field) {
        return new IsMinimum<OffsetDateTime>(TemporalConverters.OFFSETDATETIME_AS_OFFSETDATETIME, field);
    }

    public static TemporalMatcher<OffsetDateTime> isLastDayOfMonth() {
        return new IsLastDayOfMonth<OffsetDateTime>(TemporalConverters.OFFSETDATETIME_AS_OFFSETDATETIME);
    }

    public static TemporalMatcher<OffsetDateTime> isMaximum(ChronoField field) {
        return new IsMaximum<OffsetDateTime>(TemporalConverters.OFFSETDATETIME_AS_OFFSETDATETIME, field);
    }

    public static TemporalMatcher<OffsetDateTime> isMonth(Month month) {
        return new IsMonth<OffsetDateTime>(TemporalConverters.OFFSETDATETIME_AS_MONTH, TemporalProviders.month(month));
    }

    public static TemporalMatcher<OffsetDateTime> isJanuary() {
        return OffsetDateTimeMatchers.isMonth(Month.JANUARY);
    }

    public static TemporalMatcher<OffsetDateTime> isFebruary() {
        return OffsetDateTimeMatchers.isMonth(Month.FEBRUARY);
    }

    public static TemporalMatcher<OffsetDateTime> isMarch() {
        return OffsetDateTimeMatchers.isMonth(Month.MARCH);
    }

    public static TemporalMatcher<OffsetDateTime> isApril() {
        return OffsetDateTimeMatchers.isMonth(Month.APRIL);
    }

    public static TemporalMatcher<OffsetDateTime> isMay() {
        return OffsetDateTimeMatchers.isMonth(Month.MAY);
    }

    public static TemporalMatcher<OffsetDateTime> isJune() {
        return OffsetDateTimeMatchers.isMonth(Month.JUNE);
    }

    public static TemporalMatcher<OffsetDateTime> isJuly() {
        return OffsetDateTimeMatchers.isMonth(Month.JULY);
    }

    public static TemporalMatcher<OffsetDateTime> isAugust() {
        return OffsetDateTimeMatchers.isMonth(Month.AUGUST);
    }

    public static TemporalMatcher<OffsetDateTime> isSeptember() {
        return OffsetDateTimeMatchers.isMonth(Month.SEPTEMBER);
    }

    public static TemporalMatcher<OffsetDateTime> isOctober() {
        return OffsetDateTimeMatchers.isMonth(Month.OCTOBER);
    }

    public static TemporalMatcher<OffsetDateTime> isNovember() {
        return OffsetDateTimeMatchers.isMonth(Month.NOVEMBER);
    }

    public static TemporalMatcher<OffsetDateTime> isDecember() {
        return OffsetDateTimeMatchers.isMonth(Month.DECEMBER);
    }

    public static TemporalMatcher<OffsetDateTime> isLeapYear() {
        return new IsLeapYear<OffsetDateTime>(TemporalConverters.OFFSETDATETIME_AS_YEAR);
    }

    public static TemporalMatcher<OffsetDateTime> isHour(int hour) {
        return new IsHour<OffsetDateTime>(TemporalConverters.OFFSETDATETIME_AS_HOUR, TemporalProviders.hour(hour));
    }

    public static TemporalMatcher<OffsetDateTime> sameHourOfDay(OffsetDateTime date) {
        return new IsHour<OffsetDateTime>(TemporalConverters.OFFSETDATETIME_AS_HOUR, TemporalProviders.hour(date));
    }

    public static TemporalMatcher<OffsetDateTime> isMinute(int minute) {
        return new IsMinute<OffsetDateTime>(TemporalConverters.OFFSETDATETIME_AS_MINUTE, TemporalProviders.minute(minute));
    }

    public static TemporalMatcher<OffsetDateTime> sameMinuteOfHour(OffsetDateTime date) {
        return new IsMinute<OffsetDateTime>(TemporalConverters.OFFSETDATETIME_AS_MINUTE, TemporalProviders.minute(date));
    }

    public static TemporalMatcher<OffsetDateTime> isSecond(int second) {
        return new IsSecond<OffsetDateTime>(TemporalConverters.OFFSETDATETIME_AS_SECOND, TemporalProviders.second(second));
    }

    public static TemporalMatcher<OffsetDateTime> sameSecondOfMinute(OffsetDateTime date) {
        return new IsSecond<OffsetDateTime>(TemporalConverters.OFFSETDATETIME_AS_SECOND, TemporalProviders.second(date));
    }
}

