/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core.function;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import org.exparity.hamcrest.date.core.TemporalFunction;
import org.exparity.hamcrest.date.core.types.Interval;

public class LocalDateFunction
implements TemporalFunction<LocalDate> {
    private static final String DATE_PATTERN = "EEE, dd MMM yyyy";

    @Override
    public boolean isAfter(LocalDate expected, LocalDate actual) {
        return expected.isAfter(actual);
    }

    @Override
    public boolean isBefore(LocalDate expected, LocalDate actual) {
        return expected.isBefore(actual);
    }

    @Override
    public boolean isSame(LocalDate expected, LocalDate actual) {
        return expected.isEqual(actual);
    }

    @Override
    public Interval interval(LocalDate expected, LocalDate other, ChronoUnit unit) {
        return Interval.of(expected.until(other, unit), unit);
    }

    @Override
    public String describe(LocalDate temporal, Locale locale) {
        return temporal.format(DateTimeFormatter.ofPattern(DATE_PATTERN, locale));
    }
}

