/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.datum;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.resources.Classes;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.util.Utilities;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.datum.Datum;
import org.opengis.util.InternationalString;

public class AbstractDatum
extends AbstractIdentifiedObject
implements Datum {
    private static final long serialVersionUID = -4894180465652474930L;
    private static final String[] LOCALIZABLES = new String[]{"anchorPoint", "scope"};
    private final InternationalString anchorPoint;
    private final long realizationEpoch;
    private final Extent domainOfValidity;
    private final InternationalString scope;

    public AbstractDatum(Datum datum) {
        super((IdentifiedObject)datum);
        Date epoch = datum.getRealizationEpoch();
        this.realizationEpoch = epoch != null ? epoch.getTime() : Long.MIN_VALUE;
        this.domainOfValidity = datum.getDomainOfValidity();
        this.scope = datum.getScope();
        this.anchorPoint = datum.getAnchorPoint();
    }

    public AbstractDatum(Map<String, ?> properties) {
        this(properties, new HashMap<String, Object>());
    }

    private AbstractDatum(Map<String, ?> properties, Map<String, Object> subProperties) {
        super(properties, subProperties, LOCALIZABLES);
        this.anchorPoint = (InternationalString)subProperties.get("anchorPoint");
        Date realizationEpoch = (Date)subProperties.get("realizationEpoch");
        this.domainOfValidity = (Extent)subProperties.get("domainOfValidity");
        this.scope = (InternationalString)subProperties.get("scope");
        this.realizationEpoch = realizationEpoch != null ? realizationEpoch.getTime() : Long.MIN_VALUE;
    }

    static Map<String, Object> name(int key) {
        HashMap<String, Object> properties = new HashMap<String, Object>(4);
        InternationalString name = Vocabulary.formatInternational((int)key);
        properties.put("name", name.toString(null));
        properties.put("alias", name);
        return properties;
    }

    public InternationalString getAnchorPoint() {
        return this.anchorPoint;
    }

    public Date getRealizationEpoch() {
        return this.realizationEpoch != Long.MIN_VALUE ? new Date(this.realizationEpoch) : null;
    }

    public Extent getDomainOfValidity() {
        return this.domainOfValidity;
    }

    public Extent getValidArea() {
        return this.domainOfValidity;
    }

    public InternationalString getScope() {
        return this.scope;
    }

    int getLegacyDatumType() {
        return 0;
    }

    @Override
    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (super.equals(object, compareMetadata)) {
            if (!compareMetadata) {
                return this.nameMatches(object.getName().getCode()) || object.nameMatches(this.getName().getCode());
            }
            AbstractDatum that = (AbstractDatum)object;
            return this.realizationEpoch == that.realizationEpoch && Utilities.equals((Object)this.domainOfValidity, (Object)that.domainOfValidity) && Utilities.equals((Object)this.anchorPoint, (Object)that.anchorPoint) && Utilities.equals((Object)this.scope, (Object)that.scope);
        }
        return false;
    }

    @Override
    protected String formatWKT(Formatter formatter) {
        formatter.append(this.getLegacyDatumType());
        return Classes.getShortClassName((Object)this);
    }
}

