/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.glassfish.hk2.Binder;
import org.glassfish.hk2.BinderFactory;
import org.glassfish.hk2.Bindings;
import org.glassfish.hk2.NamedBinder;
import org.glassfish.hk2.TypeLiteral;
import org.jvnet.hk2.component.AbstractResolvedBinder;
import org.jvnet.hk2.component.BinderImpl;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;

class BinderFactoryImpl
implements BinderFactory {
    final BinderFactory parent;
    final List<AbstractResolvedBinder> binders = new ArrayList<AbstractResolvedBinder>();

    BinderFactoryImpl(BinderFactory parent) {
        this.parent = parent;
    }

    public BinderFactory inParent() {
        return this.parent;
    }

    public Binder<Object> bind(String contractName) {
        BinderImpl<Object> binder = new BinderImpl<Object>(this);
        binder.addContract(contractName);
        return binder;
    }

    public Binder<Object> bind(String ... contractNames) {
        BinderImpl<Object> binder = new BinderImpl<Object>(this);
        for (String contractName : contractNames) {
            binder.addContract(contractName);
        }
        return binder;
    }

    public <T> Binder<T> bind(Class<T> contract, Class<?> ... contracts) {
        BinderImpl binder = new BinderImpl(this);
        binder.addContract(contract);
        for (Class<?> c : contracts) {
            binder.addContract(c);
        }
        return binder;
    }

    public <T> Binder<T> bind(TypeLiteral<T> typeLiteral) {
        BinderImpl binder = new BinderImpl(this);
        binder.addContract(BinderFactoryImpl.exploreType(typeLiteral), typeLiteral.getRawType());
        return binder;
    }

    public NamedBinder<Object> bind() {
        return new BinderImpl(this);
    }

    void add(AbstractResolvedBinder<?> binder) {
        this.binders.add(binder);
    }

    Bindings registerIn(Habitat habitat) {
        FactoryBindings bindings = new FactoryBindings(habitat);
        for (AbstractResolvedBinder binder : this.binders) {
            Inhabitant<?> inhabitant = binder.registerIn(habitat);
            bindings.add(binder, inhabitant);
        }
        this.binders.clear();
        return bindings;
    }

    private static void exploreType(Type type, StringBuilder builder) {
        if (type instanceof ParameterizedType) {
            builder.append(TypeLiteral.getRawType((Type)type).getName());
            List<Type> types = Arrays.asList(((ParameterizedType)type).getActualTypeArguments());
            Iterator typesEnum = types.iterator();
            ArrayList<Type> nonWildcards = new ArrayList<Type>();
            while (typesEnum.hasNext()) {
                Type genericType = (Type)typesEnum.next();
                if (genericType instanceof WildcardType) continue;
                nonWildcards.add(genericType);
            }
            if (!nonWildcards.isEmpty()) {
                builder.append("<");
                Iterator typesItr = nonWildcards.iterator();
                while (typesItr.hasNext()) {
                    BinderFactoryImpl.exploreType((Type)typesItr.next(), builder);
                    if (!typesItr.hasNext()) continue;
                    builder.append(",");
                }
                builder.append(">");
            }
        } else {
            builder.append(TypeLiteral.getRawType((Type)type).getName());
        }
    }

    static String exploreType(Type type) {
        StringBuilder builder = new StringBuilder();
        BinderFactoryImpl.exploreType(type, builder);
        return builder.toString();
    }

    static String exploreType(TypeLiteral<?> typeLiteral) {
        StringBuilder builder = new StringBuilder();
        BinderFactoryImpl.exploreType(typeLiteral.getType(), builder);
        return builder.toString();
    }

    private static class FactoryBindings
    implements Bindings {
        private Habitat habitat;
        private HashMap<AbstractResolvedBinder<?>, Inhabitant<?>> bindings = new HashMap();

        public FactoryBindings(Habitat habitat) {
            this.habitat = habitat;
        }

        public void add(AbstractResolvedBinder<?> binder, Inhabitant<?> inhabitant) {
            this.bindings.put(binder, inhabitant);
        }

        public synchronized boolean isActive() {
            return null != this.bindings;
        }

        public synchronized void release() {
            if (!this.isActive()) {
                throw new IllegalStateException();
            }
            for (Map.Entry<AbstractResolvedBinder<?>, Inhabitant<?>> entry : this.bindings.entrySet()) {
                entry.getKey().releaseFrom(this.habitat, entry.getValue());
            }
            this.bindings = null;
            this.habitat = null;
        }
    }
}

