/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component;

import com.sun.hk2.component.ConstructorCreator;
import com.sun.hk2.component.FactoryCreator;
import com.sun.hk2.component.InjectableParametizedConstructorCreator;
import com.sun.hk2.component.InjectionResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.glassfish.hk2.Provider;
import org.jvnet.hk2.annotations.Factory;
import org.jvnet.hk2.annotations.FactoryFor;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.Creator;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.component.Reference;

public class Creators {
    public static <T> Creator<T> create(Class<T> c, Habitat habitat, MultiMap<String, String> metadata) {
        Factory f = c.getAnnotation(Factory.class);
        if (f != null) {
            return new FactoryCreator<T>(c, f.value(), habitat, metadata);
        }
        Inhabitant<?> factory = habitat.getInhabitantByAnnotation(FactoryFor.class, c.getName());
        if (factory != null) {
            return new FactoryCreator<T>(c, factory, habitat, metadata);
        }
        boolean isAbstract = Modifier.isAbstract(c.getModifiers());
        if (!isAbstract) {
            Reference<Constructor<T>> defaultCtorRef = new Reference<Constructor<T>>();
            Reference<Constructor<T>> noArgCtorRef = new Reference<Constructor<T>>();
            Creators.qualifyingConstructors(c, null, Creators.getInjectionAnnotations(habitat), defaultCtorRef, noArgCtorRef);
            if (defaultCtorRef.get() != null) {
                return new InjectableParametizedConstructorCreator<T>(c, defaultCtorRef.get(), habitat, metadata);
            }
            if (noArgCtorRef.get() != null) {
                return new ConstructorCreator<T>(c, habitat, metadata);
            }
        }
        return null;
    }

    private static Set<Class<? extends Annotation>> getInjectionAnnotations(Habitat habitat) {
        HashSet<Class<? extends Annotation>> annotations = new HashSet<Class<? extends Annotation>>();
        for (Inhabitant<? extends InjectionResolver> resolver : Creators.getAllInjectionResolvers(habitat)) {
            annotations.add(resolver.get().type);
        }
        return annotations;
    }

    public static List<Inhabitant<? extends InjectionResolver>> getAllInjectionResolvers(Habitat habitat) {
        ArrayList<Inhabitant<? extends InjectionResolver>> resolvers = new ArrayList<Inhabitant<? extends InjectionResolver>>();
        Inhabitant<InjectionResolver> specialResolver = habitat.getInhabitant(InjectionResolver.class, "Inject");
        specialResolver.get();
        resolvers.add(specialResolver);
        for (Inhabitant<InjectionResolver> inhabitant : habitat.getInhabitants(InjectionResolver.class)) {
            if (inhabitant == specialResolver) continue;
            resolvers.add(inhabitant);
        }
        if (habitat.getDefault() != habitat) {
            for (Provider provider : habitat.getDefault().forContract(InjectionResolver.class).all()) {
                resolvers.add((Inhabitant)provider);
            }
        }
        return resolvers;
    }

    public static <T> void qualifyingConstructors(Class<T> c, List<Constructor<?>> allList, Set<Class<? extends Annotation>> injectionAnnotations, Reference<Constructor<T>> defaultCtor, Reference<Constructor<T>> noArgCtor) {
        Constructor<?>[] ctors;
        try {
            ctors = c.getDeclaredConstructors();
        }
        catch (Exception e) {
            ctors = c.getConstructors();
        }
        for (Constructor<?> ctor : ctors) {
            if (0 == ctor.getParameterTypes().length) {
                if (null != allList) {
                    allList.add(ctor);
                }
                if (null == noArgCtor) continue;
                noArgCtor.set(ctor);
                continue;
            }
            if (Creators.isInjectable(injectionAnnotations, ctor)) {
                if (null != allList) {
                    allList.add(ctor);
                }
                if (null == defaultCtor || null != defaultCtor.get()) continue;
                defaultCtor.set(ctor);
                continue;
            }
            boolean allInjectable = true;
            for (Annotation[] a : ctor.getParameterAnnotations()) {
                if (Creators.isInject(injectionAnnotations, a)) continue;
                allInjectable = false;
                break;
            }
            if (!allInjectable) continue;
            if (null != allList) {
                allList.add(ctor);
            }
            if (null == defaultCtor || null != defaultCtor.get()) continue;
            defaultCtor.set(ctor);
        }
    }

    private static boolean isInject(Set<Class<? extends Annotation>> injectionAnnotations, Annotation ... a) {
        for (Annotation ae : a) {
            if (!injectionAnnotations.contains(ae.annotationType()) && !ae.annotationType().equals(javax.inject.Inject.class)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInjectable(Set<Class<? extends Annotation>> injectionAnnotations, AnnotatedElement ae) {
        for (Class<? extends Annotation> injectionAnnotation : injectionAnnotations) {
            if (ae.getAnnotation(injectionAnnotation) == null) continue;
            return true;
        }
        return null != ae.getAnnotation(Inject.class) || null != ae.getAnnotation(javax.inject.Inject.class);
    }
}

